/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.ipc.json;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.MappingJsonFactory;
import org.codehaus.jackson.map.ObjectMapper;
import org.eclipse.smila.ipc.IpcStreamReader;
import org.eclipse.smila.ipc.IpcToken;

public class JsonStreamReader
implements IpcStreamReader {
    private static final JsonFactory FACTORY;
    private static final Map<JsonToken, IpcToken> TOKEN_MAPPING;
    private final JsonParser _parser;
    private boolean _firstToken = true;
    private boolean _firstValue = true;
    private boolean _lastToken;
    private boolean _levelCountEnabled;
    private int _levelCount;

    static {
        ObjectMapper mapper = new ObjectMapper();
        FACTORY = new MappingJsonFactory(mapper);
        FACTORY.configure(JsonParser.Feature.INTERN_FIELD_NAMES, false);
        TOKEN_MAPPING = new HashMap<JsonToken, IpcToken>();
        TOKEN_MAPPING.put(JsonToken.END_ARRAY, IpcToken.SEQUENCE_END);
        TOKEN_MAPPING.put(JsonToken.END_OBJECT, IpcToken.MAPPING_END);
        TOKEN_MAPPING.put(JsonToken.FIELD_NAME, IpcToken.SCALAR_STRING);
        TOKEN_MAPPING.put(JsonToken.NOT_AVAILABLE, IpcToken.UNDEFINED);
        TOKEN_MAPPING.put(JsonToken.START_ARRAY, IpcToken.SEQUENCE_START);
        TOKEN_MAPPING.put(JsonToken.START_OBJECT, IpcToken.MAPPING_START);
        TOKEN_MAPPING.put(JsonToken.VALUE_FALSE, IpcToken.SCALAR_BOOL);
        TOKEN_MAPPING.put(JsonToken.VALUE_NULL, IpcToken.UNDEFINED);
        TOKEN_MAPPING.put(JsonToken.VALUE_NUMBER_FLOAT, IpcToken.SCALAR_DOUBLE);
        TOKEN_MAPPING.put(JsonToken.VALUE_NUMBER_INT, IpcToken.SCALAR_INT);
        TOKEN_MAPPING.put(JsonToken.VALUE_STRING, IpcToken.SCALAR_STRING);
        TOKEN_MAPPING.put(JsonToken.VALUE_TRUE, IpcToken.SCALAR_BOOL);
    }

    JsonStreamReader(InputStream stream) throws IOException {
        this._parser = FACTORY.createJsonParser(stream);
        this._parser.enable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
    }

    @Override
    public void close() throws IOException {
        if (this._parser != null) {
            this._parser.enable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
            this._parser.close();
        }
    }

    @Override
    public void closeWithoutStream() throws IOException {
        if (this._parser != null) {
            this._parser.disable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
            this._parser.close();
        }
    }

    @Override
    public boolean currentBoolValue() throws IOException {
        return Boolean.valueOf(this._parser.getText());
    }

    @Override
    public double currentDoubleValue() throws IOException {
        return this._parser.getDoubleValue();
    }

    @Override
    public long currentLongValue() throws IOException {
        return this._parser.getLongValue();
    }

    @Override
    public String currentStringValue() throws IOException {
        if (this._firstValue) {
            return null;
        }
        if (this._lastToken) {
            return null;
        }
        return this._parser.getText();
    }

    @Override
    public boolean nextBoolValue() throws IOException {
        this.nextParserToken();
        return this.currentBoolValue();
    }

    @Override
    public double nextDoubleValue() throws IOException {
        this.nextParserToken();
        return this.currentDoubleValue();
    }

    @Override
    public long nextLongValue() throws IOException {
        this.nextParserToken();
        return this.currentLongValue();
    }

    @Override
    public String nextStringValue() throws IOException {
        this.nextToken();
        return this.currentStringValue();
    }

    @Override
    public IpcToken nextToken() throws IOException {
        if (this._firstToken) {
            this._firstToken = false;
            return IpcToken.OBJECT_START;
        }
        if (this._lastToken) {
            throw new IllegalStateException("JSON Object has ended. Parsing of multiple JSON objects is not supported.");
        }
        if (this._levelCountEnabled && this._levelCount == 0) {
            this._lastToken = true;
            return IpcToken.OBJECT_END;
        }
        JsonToken jsonToken = this.nextParserToken();
        if (jsonToken == null) {
            this._lastToken = true;
            return IpcToken.OBJECT_END;
        }
        IpcToken ipcToken = TOKEN_MAPPING.get(jsonToken);
        if (IpcToken.MAPPING_START.equals((Object)ipcToken) || IpcToken.SEQUENCE_START.equals((Object)ipcToken)) {
            this._levelCountEnabled = true;
            ++this._levelCount;
        } else if (IpcToken.MAPPING_END.equals((Object)ipcToken) || IpcToken.SEQUENCE_END.equals((Object)ipcToken)) {
            --this._levelCount;
        }
        return ipcToken;
    }

    private JsonToken nextParserToken() throws IOException {
        this._firstValue = false;
        return this._parser.nextToken();
    }

    public <T> T readObject(Class<T> type) throws IOException {
        return (T)this._parser.readValueAs(type);
    }

    @Override
    public InputStream getStream() {
        throw new UnsupportedOperationException();
    }
}

