/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.dao.jpa;

import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.BpelEventFilter;
import org.apache.ode.bpel.common.Filter;
import org.apache.ode.bpel.common.InstanceFilter;
import org.apache.ode.bpel.dao.BpelDAOConnection;
import org.apache.ode.bpel.dao.MessageExchangeDAO;
import org.apache.ode.bpel.dao.ProcessDAO;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.bpel.dao.ScopeDAO;
import org.apache.ode.bpel.evt.BpelEvent;
import org.apache.ode.bpel.evt.ScopeEvent;
import org.apache.ode.dao.jpa.EventDAOImpl;
import org.apache.ode.dao.jpa.MessageExchangeDAOImpl;
import org.apache.ode.dao.jpa.ProcessDAOImpl;
import org.apache.ode.dao.jpa.ProcessInstanceDAOImpl;
import org.apache.ode.dao.jpa.ScopeDAOImpl;
import org.apache.ode.utils.ISO8601DateParser;
import org.apache.openjpa.persistence.OpenJPAPersistence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BPELDAOConnectionImpl
implements BpelDAOConnection {
    static final Log __log = LogFactory.getLog(BPELDAOConnectionImpl.class);
    EntityManager _em;

    public BPELDAOConnectionImpl(EntityManager entityManager) {
        this._em = entityManager;
    }

    public List<BpelEvent> bpelEventQuery(InstanceFilter instanceFilter, BpelEventFilter bpelEventFilter) {
        throw new UnsupportedOperationException();
    }

    public List<Date> bpelEventTimelineQuery(InstanceFilter instanceFilter, BpelEventFilter bpelEventFilter) {
        throw new UnsupportedOperationException();
    }

    public ProcessInstanceDAO getInstance(Long l) {
        ProcessInstanceDAOImpl processInstanceDAOImpl = (ProcessInstanceDAOImpl)this._em.find(ProcessInstanceDAOImpl.class, (Object)l);
        return processInstanceDAOImpl;
    }

    public void close() {
        this._em = null;
    }

    public MessageExchangeDAO createMessageExchange(String string, char c) {
        MessageExchangeDAOImpl messageExchangeDAOImpl = new MessageExchangeDAOImpl(string, c);
        this._em.persist((Object)messageExchangeDAOImpl);
        return messageExchangeDAOImpl;
    }

    public void releaseMessageExchange(String string) {
    }

    public ProcessDAO createProcess(QName qName, QName qName2, String string, long l) {
        ProcessDAOImpl processDAOImpl = new ProcessDAOImpl(qName, qName2, string, l);
        this._em.persist((Object)processDAOImpl);
        return processDAOImpl;
    }

    public ProcessDAO getProcess(QName qName) {
        List list = this._em.createQuery("select x from ProcessDAOImpl x where x._processId = ?1").setParameter(1, (Object)qName.toString()).getResultList();
        if (list.size() == 0) {
            return null;
        }
        ProcessDAOImpl processDAOImpl = (ProcessDAOImpl)list.get(0);
        return processDAOImpl;
    }

    public ScopeDAO getScope(Long l) {
        return (ScopeDAO)this._em.find(ScopeDAOImpl.class, (Object)l);
    }

    public void insertBpelEvent(BpelEvent bpelEvent, ProcessDAO processDAO, ProcessInstanceDAO processInstanceDAO) {
        EventDAOImpl eventDAOImpl = new EventDAOImpl();
        eventDAOImpl.setTstamp(new Timestamp(System.currentTimeMillis()));
        eventDAOImpl.setType(BpelEvent.eventName((BpelEvent)bpelEvent));
        String string = bpelEvent.toString();
        eventDAOImpl.setDetail(string.substring(0, Math.min(254, string.length())));
        if (processDAO != null) {
            eventDAOImpl.setProcess((ProcessDAOImpl)processDAO);
        }
        if (processInstanceDAO != null) {
            eventDAOImpl.setInstance((ProcessInstanceDAOImpl)processInstanceDAO);
        }
        if (bpelEvent instanceof ScopeEvent) {
            eventDAOImpl.setScopeId(((ScopeEvent)bpelEvent).getScopeId());
        }
        eventDAOImpl.setEvent(bpelEvent);
        this._em.persist((Object)eventDAOImpl);
    }

    private static String dateFilter(String string) {
        String string2 = Filter.getDateWithoutOp((String)string);
        String string3 = string.substring(0, string.indexOf(string2));
        Date date = null;
        try {
            date = ISO8601DateParser.parse((String)string2);
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        Timestamp timestamp = new Timestamp(date.getTime());
        return string3 + " '" + timestamp.toString() + "'";
    }

    public Collection<ProcessInstanceDAO> instanceQuery(InstanceFilter instanceFilter) {
        Object object;
        Object object2;
        Object object3;
        Query query;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select pi from ProcessInstanceDAOImpl as pi");
        if (instanceFilter != null) {
            int n;
            Object object42;
            query = new ArrayList();
            if (instanceFilter.getIidFilter() != null) {
                object3 = new StringBuffer();
                object42 = instanceFilter.getIidFilter();
                for (n = 0; n < object42.size(); ++n) {
                    ((StringBuffer)object3).append(" pi._instanceId = '").append((String)object42.get(n)).append("'");
                    if (n >= object42.size() - 1) continue;
                    ((StringBuffer)object3).append(" or");
                }
                query.add(" (" + object3 + ")");
            }
            if (instanceFilter.getPidFilter() != null) {
                object3 = new StringBuffer();
                object42 = instanceFilter.getPidFilter();
                for (n = 0; n < object42.size(); ++n) {
                    ((StringBuffer)object3).append(" pi._process._processId = '").append((String)object42.get(n)).append("'");
                    if (n >= object42.size() - 1) continue;
                    ((StringBuffer)object3).append(" or");
                }
                query.add(" (" + object3 + ")");
            }
            if (instanceFilter.getNameFilter() != null) {
                object3 = instanceFilter.getNameFilter();
                if (((String)object3).endsWith("*")) {
                    object3 = ((String)object3).substring(0, ((String)object3).length() - 1) + "%";
                }
                query.add(" pi._process._processType like '%" + object3 + "'");
            }
            if (instanceFilter.getNamespaceFilter() != null) {
                query.add(" pi._process._processType like '{" + instanceFilter.getNamespaceFilter() + "%'");
            }
            if (instanceFilter.getStartedDateFilter() != null) {
                for (Object object42 : instanceFilter.getStartedDateFilter()) {
                    query.add(" pi._dateCreated " + BPELDAOConnectionImpl.dateFilter((String)object42));
                }
            }
            if (instanceFilter.getLastActiveDateFilter() != null) {
                for (Object object42 : instanceFilter.getLastActiveDateFilter()) {
                    query.add(" pi._lastActive " + BPELDAOConnectionImpl.dateFilter((String)object42));
                }
            }
            if (instanceFilter.getStatusFilter() != null) {
                object3 = new StringBuffer();
                object42 = instanceFilter.convertFilterState();
                for (n = 0; n < object42.size(); ++n) {
                    ((StringBuffer)object3).append(" pi._state = ").append(object42.get(n));
                    if (n >= object42.size() - 1) continue;
                    ((StringBuffer)object3).append(" or");
                }
                query.add(" (" + ((StringBuffer)object3).toString() + ")");
            }
            if (instanceFilter.getPropertyValuesFilter() != null) {
                object3 = instanceFilter.getPropertyValuesFilter();
                stringBuffer.append(" inner join pi._rootScope._correlationSets as cs");
                int n2 = 0;
                for (String string : object3.keySet()) {
                    stringBuffer.append(" inner join cs._props as csp" + ++n2);
                    query.add(" csp" + n2 + ".propertyKey = '" + string + "' and csp" + n2 + ".propertyValue = '" + ((String)object3.get(string)).replaceAll("&#32;", " ") + "'");
                }
            }
            object3 = new StringBuffer("");
            if (instanceFilter.getOrders() != null) {
                ((StringBuffer)object3).append(" order by");
                List list = instanceFilter.getOrders();
                for (int i = 0; i < list.size(); ++i) {
                    String string;
                    string = (String)list.get(i);
                    object2 = " asc";
                    if (string.startsWith("-")) {
                        object2 = " desc";
                    }
                    object = " pi._instanceId";
                    if (string.endsWith("name") || string.endsWith("namespace")) {
                        object = " pi._process._processType";
                    }
                    if (string.endsWith("version")) {
                        object = " pi._process._version";
                    }
                    if (string.endsWith("status")) {
                        object = " pi._state";
                    }
                    if (string.endsWith("started")) {
                        object = " pi._dateCreated";
                    }
                    if (string.endsWith("last-active")) {
                        object = " pi._lastActive";
                    }
                    ((StringBuffer)object3).append((String)object + (String)object2);
                    if (i >= list.size() - 1) continue;
                    ((StringBuffer)object3).append(", ");
                }
            }
            if (query.size() > 0) {
                stringBuffer.append(" where");
                for (int i = 0; i < query.size(); ++i) {
                    stringBuffer.append((String)query.get(i));
                    if (i >= query.size() - 1) continue;
                    stringBuffer.append(" and");
                }
            }
            stringBuffer.append((StringBuffer)object3);
        }
        if (__log.isDebugEnabled()) {
            __log.debug((Object)stringBuffer.toString());
        }
        query = this._em.createQuery(stringBuffer.toString());
        object3 = OpenJPAPersistence.cast((Query)query);
        object3.getFetchPlan().setFetchBatchSize(instanceFilter.getLimit());
        List list = query.getResultList();
        ArrayList<ProcessInstanceDAO> arrayList = new ArrayList<ProcessInstanceDAO>();
        int n = 0;
        object2 = list.iterator();
        while (object2.hasNext() && n++ <= instanceFilter.getLimit()) {
            object = (ProcessInstanceDAO)object2.next();
            arrayList.add((ProcessInstanceDAO)object);
        }
        return arrayList;
    }

    public Collection<ProcessInstanceDAO> instanceQuery(String string) {
        return this.instanceQuery(new InstanceFilter(string));
    }

    public void setEntityManger(EntityManager entityManager) {
        this._em = entityManager;
    }

    public MessageExchangeDAO getMessageExchange(String string) {
        List list = this._em.createQuery("select x from MessageExchangeDAOImpl x where x._id = ?1").setParameter(1, (Object)string).getResultList();
        if (list.size() == 0) {
            return null;
        }
        MessageExchangeDAOImpl messageExchangeDAOImpl = (MessageExchangeDAOImpl)list.get(0);
        return messageExchangeDAOImpl;
    }

    public EntityManager getEntityManager() {
        return this._em;
    }
}

