/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.framework.httphandler;

import java.util.Map;
import org.eclipse.smila.connectivity.framework.CrawlState;
import org.eclipse.smila.connectivity.framework.CrawlerController;
import org.eclipse.smila.connectivity.framework.httphandler.BaseConnectivityHandler;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.http.server.util.URLCreator;

public class CrawlersHandler
extends BaseConnectivityHandler {
    public static final String KEY_CRAWLERS = "crawlers";
    public static final String KEY_NAME = "name";
    public static final String KEY_STATE = "state";
    public static final String KEY_URL = "url";
    private CrawlerController _crawlerController;

    public Object process(String method, String requestUri, Record inputRecord) throws Exception {
        AnyMap resultMap = DataFactory.DEFAULT.createAnyMap();
        AnySeq stateSeq = DataFactory.DEFAULT.createAnySeq();
        if (this._crawlerController != null) {
            Map<String, CrawlState> crawlerTaskStates = this._crawlerController.getCrawlerTasksState();
            for (String availableCrawler : this._crawlerController.getAvailableConfigurations()) {
                AnyMap stateMap = DataFactory.DEFAULT.createAnyMap();
                CrawlState state = crawlerTaskStates.get(availableCrawler);
                String stateString = state != null ? state.getState().name() : "Undefined";
                stateMap.put(KEY_NAME, availableCrawler);
                stateMap.put(KEY_STATE, stateString);
                stateMap.put(KEY_URL, URLCreator.create((String)this.getRequestHost(), (String)requestUri, (String)availableCrawler).toURI().toASCIIString());
                stateSeq.add((Object)stateMap);
            }
            resultMap.put(KEY_CRAWLERS, (Any)stateSeq);
        }
        return resultMap;
    }

    protected boolean isValidMethod(String method, String requestUri) {
        return "GET".equals(method);
    }

    protected void setCrawlerController(CrawlerController crawlerController) {
        this._crawlerController = crawlerController;
    }

    protected void unsetCrawlerController(CrawlerController crawlerController) {
        if (this._crawlerController == crawlerController) {
            this._crawlerController = null;
        }
    }
}

