/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.framework.performancecounters;

import java.util.Date;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.connectivity.framework.performancecounters.ConnectivityPerformanceAgent;
import org.eclipse.smila.connectivity.framework.performancecounters.ConnectivityPerformanceAgentBase;
import org.eclipse.smila.connectivity.framework.performancecounters.CrawlerControllerPerformanceAgent;
import org.eclipse.smila.connectivity.framework.schema.config.DataSourceConnectionConfig;
import org.eclipse.smila.management.ManagementAgentLocation;
import org.eclipse.smila.management.ManagementRegistration;
import org.eclipse.smila.management.performance.PerformanceCounter;

public abstract class ConnectivityPerformanceCounterHelperBase<AgentType extends ConnectivityPerformanceAgent> {
    protected Log _log = LogFactory.getLog(this.getClass());
    protected CrawlerControllerPerformanceAgent _controllerAgent;
    protected final AgentType _typeAgent;
    protected final AgentType _instanceAgent;
    protected final Class<AgentType> _agentClass;

    public ConnectivityPerformanceCounterHelperBase(DataSourceConnectionConfig configuration, int hashCode, Class<AgentType> agentClass) {
        this._agentClass = agentClass;
        try {
            this._controllerAgent = (CrawlerControllerPerformanceAgent)ManagementRegistration.INSTANCE.getAgent(this.getPerformanceAgentLocation());
        }
        catch (Throwable throwable) {
            this._log.warn((Object)"Controller Agent was not found!");
        }
        String crawlerName = configuration.getDataConnectionID().getId().replaceFirst(String.valueOf(this.getdateConnectionIdSuffix()) + "$", "");
        ManagementAgentLocation typeAgentLocation = ManagementRegistration.INSTANCE.getCategory(this.getPerformanceAgentCategory()).getCategory(crawlerName).getLocation("Total");
        this._typeAgent = this.initAgent(typeAgentLocation);
        ManagementAgentLocation instanceAgentLocation = ManagementRegistration.INSTANCE.getCategory(this.getPerformanceAgentCategory()).getCategory(crawlerName).getLocation(String.valueOf(configuration.getDataSourceID()) + " - " + String.valueOf(hashCode));
        this._instanceAgent = this.initAgent(instanceAgentLocation);
    }

    public AgentType getInstanceAgent() {
        return this._instanceAgent;
    }

    protected abstract String getPerformanceAgentLocation();

    protected abstract String getPerformanceAgentCategory();

    protected abstract String getdateConnectionIdSuffix();

    public void setStartDate(Date date) {
        if (this._typeAgent != null) {
            ((ConnectivityPerformanceAgent)this._typeAgent).setStartDate(date);
        } else {
            this._log.warn((Object)"Type agent agent is null");
        }
        if (this._instanceAgent != null) {
            ((ConnectivityPerformanceAgent)this._instanceAgent).setStartDate(date);
        } else {
            this._log.warn((Object)"Instance agent agent is null");
        }
    }

    public void setJobName(String jobName) {
        if (this._typeAgent != null) {
            ((ConnectivityPerformanceAgent)this._typeAgent).setJobName(jobName);
        } else {
            this._log.warn((Object)"Type agent agent is null");
        }
        if (this._instanceAgent != null) {
            ((ConnectivityPerformanceAgent)this._instanceAgent).setJobName(jobName);
        } else {
            this._log.warn((Object)"Instance agent agent is null");
        }
    }

    public void setEndDate(Date endDate) {
        if (this._typeAgent != null) {
            ((ConnectivityPerformanceAgent)this._typeAgent).setEndDate(endDate);
        } else {
            this._log.warn((Object)"Type agent agent is null");
        }
        if (this._instanceAgent != null) {
            ((ConnectivityPerformanceAgent)this._instanceAgent).setEndDate(endDate);
        } else {
            this._log.warn((Object)"Instance agent agent is null");
        }
    }

    protected abstract AgentType initAgent(ManagementAgentLocation var1);

    public void incrementDeltaIndices() {
        this.incrementDeltaIndicesBy(1L);
    }

    public void incrementDeltaIndicesBy(long value) {
        if (this._controllerAgent != null) {
            this._controllerAgent.getDeltaIndices().incrementBy(value);
            this._controllerAgent.getAverageDeltaIndicesProcessingTime().incrementBy(value);
        } else {
            this._log.warn((Object)"Controller agent is null");
        }
        if (this._typeAgent != null) {
            ((ConnectivityPerformanceAgentBase)this._typeAgent).getDeltaIndices().incrementBy(value);
            ((ConnectivityPerformanceAgentBase)this._typeAgent).getAverageDeltaIndicesProcessingTime().incrementBy(value);
        } else {
            this._log.warn((Object)"Type agent agent is null");
        }
        if (this._instanceAgent != null) {
            ((ConnectivityPerformanceAgentBase)this._instanceAgent).getDeltaIndices().incrementBy(value);
            ((ConnectivityPerformanceAgentBase)this._instanceAgent).getAverageDeltaIndicesProcessingTime().incrementBy(value);
        } else {
            this._log.warn((Object)"Instance agent agent is null");
        }
    }

    public void incrementAttachmentBytes(long value) {
        if (this._controllerAgent != null) {
            this._controllerAgent.getAttachmentTransferRate().incrementBy(value);
            this._controllerAgent.getAttachmentBytesTransfered().incrementBy(value);
        } else {
            this._log.warn((Object)"Controller agent is null");
        }
        if (this._typeAgent != null) {
            ((ConnectivityPerformanceAgentBase)this._typeAgent).getAttachmentTransferRate().incrementBy(value);
            ((ConnectivityPerformanceAgentBase)this._typeAgent).getAttachmentBytesTransfered().incrementBy(value);
        } else {
            this._log.warn((Object)"Type agent agent is null");
        }
        if (this._instanceAgent != null) {
            ((ConnectivityPerformanceAgentBase)this._instanceAgent).getAttachmentTransferRate().incrementBy(value);
            ((ConnectivityPerformanceAgentBase)this._instanceAgent).getAttachmentBytesTransfered().incrementBy(value);
        } else {
            this._log.warn((Object)"Instance agent agent is null");
        }
    }

    public void incrementRecords() {
        this.incrementRecordsBy(1L);
    }

    public void incrementRecordsBy(long value) {
        if (this._controllerAgent != null) {
            this._controllerAgent.getRecords().incrementBy(value);
            this._controllerAgent.getAverageRecordsProcessingTime().incrementBy(value);
        } else {
            this._log.warn((Object)"Controller agent is null");
        }
        if (this._typeAgent != null) {
            ((ConnectivityPerformanceAgentBase)this._typeAgent).getRecords().incrementBy(value);
            ((ConnectivityPerformanceAgentBase)this._typeAgent).getAverageRecordsProcessingTime().incrementBy(value);
        } else {
            this._log.warn((Object)"Type agent agent is null");
        }
        if (this._instanceAgent != null) {
            ((ConnectivityPerformanceAgentBase)this._instanceAgent).getRecords().incrementBy(value);
            ((ConnectivityPerformanceAgentBase)this._instanceAgent).getAverageRecordsProcessingTime().incrementBy(value);
        } else {
            this._log.warn((Object)"Instance agent agent is null");
        }
    }

    public void increment(String name) {
        this.incrementBy(name, 1L);
    }

    public void incrementBy(String name, long value) {
        try {
            PerformanceCounter counter;
            if (this._typeAgent != null) {
                counter = (PerformanceCounter)PropertyUtils.getProperty(this._typeAgent, (String)name);
                counter.incrementBy(value);
            } else {
                this._log.warn((Object)"Type agent agent is null");
            }
            if (this._instanceAgent != null) {
                counter = (PerformanceCounter)PropertyUtils.getProperty(this._instanceAgent, (String)name);
                counter.incrementBy(value);
            } else {
                this._log.warn((Object)"Instance agent agent is null");
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public void addException(Throwable ex) {
        this.addException(ex, false);
    }

    public void addCriticalException(Throwable ex) {
        this.addException(ex, true);
    }

    public void addException(Throwable exception, boolean isCritical) {
        if (this._controllerAgent != null) {
            this._controllerAgent.getErrorBuffer().addError(exception, isCritical);
            if (isCritical) {
                this._controllerAgent.getExceptionsCritical().increment();
            } else {
                this._controllerAgent.getExceptions().increment();
            }
        } else {
            this._log.warn((Object)"Controller agent is null");
        }
        if (this._typeAgent != null) {
            ((ConnectivityPerformanceAgentBase)this._typeAgent).getErrorBuffer().addError(exception, isCritical);
            if (isCritical) {
                ((ConnectivityPerformanceAgentBase)this._typeAgent).getExceptionsCritical().increment();
            } else {
                ((ConnectivityPerformanceAgentBase)this._typeAgent).getExceptions().increment();
            }
        } else {
            this._log.warn((Object)"Type agent agent is null");
        }
        if (this._instanceAgent != null) {
            ((ConnectivityPerformanceAgentBase)this._instanceAgent).getErrorBuffer().addError(exception, isCritical);
            if (isCritical) {
                ((ConnectivityPerformanceAgentBase)this._instanceAgent).getExceptionsCritical().increment();
            } else {
                ((ConnectivityPerformanceAgentBase)this._instanceAgent).getExceptions().increment();
            }
        } else {
            this._log.warn((Object)"Instance agent agent is null");
        }
    }

    public void setImportRunId(String importRunId) {
        if (this._typeAgent != null) {
            ((ConnectivityPerformanceAgent)this._typeAgent).setImportRunId(importRunId);
        } else {
            this._log.warn((Object)"Type agent agent is null");
        }
        if (this._instanceAgent != null) {
            ((ConnectivityPerformanceAgent)this._instanceAgent).setImportRunId(importRunId);
        } else {
            this._log.warn((Object)"Instance agent agent is null");
        }
    }
}

