/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.taskmanager.httphandler;

import java.net.MalformedURLException;
import java.util.Map;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.http.server.json.JsonRequestHandler;
import org.eclipse.smila.http.server.util.URLCreator;
import org.eclipse.smila.taskmanager.BadParameterTaskmanagerException;
import org.eclipse.smila.taskmanager.TaskManager;
import org.eclipse.smila.taskmanager.persistence.TaskCounter;

public class TaskStateHandler
extends JsonRequestHandler {
    private TaskManager _taskManager;

    public Object process(String method, String requestUri, Record inputRecord) throws Exception {
        if ("GET".equals(method)) {
            AnyMap result = FACTORY.createAnyMap();
            result.put("failsafety", (Number)this._taskManager.getFailSafetyLevel());
            Map<String, TaskCounter> taskCounters = this._taskManager.getTaskCounters();
            AnySeq workers = FACTORY.createAnySeq();
            for (TaskCounter counter : taskCounters.values()) {
                AnyMap workerSection = FACTORY.createAnyMap();
                workerSection.put("name", counter.getWorkerName());
                this.createCounterSection(workerSection, requestUri, "todo", counter.getTasksTodo());
                this.createCounterSection(workerSection, requestUri, "inprogress", counter.getTasksInProgress());
                workers.add((Object)workerSection);
            }
            result.put("workers", (Any)workers);
            AnySeq scaleUp = FACTORY.createAnySeq();
            Map<String, Integer> scaleUpCounters = this._taskManager.getScaleUpCounters();
            for (Map.Entry<String, Integer> counter : scaleUpCounters.entrySet()) {
                AnyMap hostSection = FACTORY.createAnyMap();
                hostSection.put("host", counter.getKey());
                hostSection.put("count", (Number)counter.getValue());
                scaleUp.add((Object)hostSection);
            }
            result.put("maxScaleUp", (Number)this._taskManager.getMaxScaleUp());
            result.put("scaleUp", (Any)scaleUp);
            return result;
        }
        return null;
    }

    protected int getErrorStatus(String method, String requestUri, Throwable ex) {
        if (ex instanceof IllegalArgumentException) {
            return 400;
        }
        if (ex.getCause() != null && ex.getCause() instanceof BadParameterTaskmanagerException) {
            return 404;
        }
        return super.getErrorStatus(method, requestUri, ex);
    }

    private void createCounterSection(AnyMap workerTaskSection, String requestUri, String type, long count) throws MalformedURLException {
        AnyMap counterSection = FACTORY.createAnyMap();
        counterSection.put("count", (Number)count);
        counterSection.put("url", URLCreator.create((String)this.getRequestHost(), (String)requestUri, (String)(workerTaskSection.get((Object)"name") + "/" + type)).toString());
        workerTaskSection.put(type, (Any)counterSection);
    }

    protected boolean isValidMethod(String method, String requestUri) {
        return "GET".equals(method);
    }

    public void setTaskManager(TaskManager taskManager) {
        this._taskManager = taskManager;
    }

    public void unsetTaskManager(TaskManager taskManager) {
        if (this._taskManager == taskManager) {
            this._taskManager = null;
        }
    }
}

