/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.taskmanager.httphandler;

import java.util.Collection;
import java.util.List;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.InvalidValueTypeException;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.http.server.json.JsonRequestHandler;
import org.eclipse.smila.taskmanager.BadParameterTaskmanagerException;
import org.eclipse.smila.taskmanager.Task;
import org.eclipse.smila.taskmanager.TaskManager;

public class WorkerTaskHandler
extends JsonRequestHandler {
    public static final String KEY_WORKERHOST = "workerHost";
    public static final String KEY_QUALIFIER = "qualifier";
    private TaskManager _taskManager;

    public Object process(String method, String requestUri, Record inputRecord) throws Exception {
        String workerName;
        Task task;
        String workerHost = null;
        Collection<String> qualifiers = null;
        if (inputRecord != null) {
            workerHost = this.getWorkerHostName(inputRecord);
            qualifiers = this.getQualifier(inputRecord);
        }
        if ((task = this._taskManager.getTask(workerName = this.getWorkerName(requestUri), workerHost, qualifiers)) != null) {
            return task.toAny();
        }
        return null;
    }

    private String getWorkerHostName(Record inputRecord) {
        String workerHost = null;
        AnyMap inputRecordAsAny = inputRecord.getMetadata();
        if (inputRecordAsAny.containsKey((Object)KEY_WORKERHOST)) {
            workerHost = inputRecordAsAny.getStringValue(KEY_WORKERHOST);
        }
        return workerHost;
    }

    protected Collection<String> getQualifier(Record inputRecord) {
        List qualifier = null;
        try {
            AnyMap inputRecordAsAny = inputRecord.getMetadata();
            if (inputRecordAsAny.containsKey((Object)KEY_QUALIFIER)) {
                qualifier = inputRecordAsAny.getSeq(KEY_QUALIFIER).asStrings();
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Cannot convert qualifiers.", ex);
        }
        return qualifier;
    }

    protected int getErrorStatus(String method, String requestUri, Throwable ex) {
        if (ex instanceof IllegalArgumentException || ex instanceof InvalidValueTypeException || ex instanceof BadParameterTaskmanagerException) {
            return 400;
        }
        return super.getErrorStatus(method, requestUri, ex);
    }

    protected int getSuccessStatus(String requestMethod, String requestUri, Record inputRecord, Object resultObject) {
        if (resultObject == null) {
            return 204;
        }
        return super.getSuccessStatus(requestMethod, requestUri, inputRecord, resultObject);
    }

    private String getWorkerName(String requestUri) {
        List uriParts = this.getDynamicUriParts(requestUri);
        if (uriParts.size() > 0) {
            return (String)uriParts.get(0);
        }
        throw new IllegalArgumentException("Invalid request URI, does not match uri pattern '" + this.getUriPattern() + "'.");
    }

    protected boolean isValidMethod(String method, String requestUri) {
        return "GET".equals(method) || "POST".equals(method);
    }

    public void setTaskManager(TaskManager taskManager) {
        this._taskManager = taskManager;
    }

    public void unsetTaskManager(TaskManager taskManager) {
        if (this._taskManager == taskManager) {
            this._taskManager = null;
        }
    }
}

