/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.jobmanager.DefinitionBase;
import org.eclipse.smila.jobmanager.InvalidConfigException;
import org.eclipse.smila.jobmanager.internal.AccessAny;

public class BucketDefinition
extends DefinitionBase {
    public static final String KEY_BUCKETS = "buckets";
    public static final String KEY_TYPE = "type";
    public static final String KEY_MODE = "mode";
    public static final String KEY_PARAMETERS = "parameters";
    private final String _dataObjectType;
    private final AnyMap _parameters;

    public BucketDefinition(AnyMap bucket) throws InvalidConfigException {
        super(bucket);
        this._dataObjectType = AccessAny.getStringRequired(bucket, KEY_TYPE);
        this._parameters = bucket.getMap(KEY_PARAMETERS);
    }

    public BucketDefinition(String name, String dataObjectType) {
        super(name);
        this._dataObjectType = dataObjectType;
        this._parameters = null;
    }

    public static BucketDefinition parseBucket(AnyMap bucketAny) throws InvalidConfigException {
        BucketDefinition workflow = null;
        try {
            workflow = new BucketDefinition(bucketAny);
        }
        catch (InvalidConfigException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new InvalidConfigException("Invalid any structure", ex);
        }
        return workflow;
    }

    public static Collection<BucketDefinition> parseBuckets(AnyMap bucketsAny, boolean setReadOnly) throws InvalidConfigException {
        ArrayList<BucketDefinition> buckets;
        block6: {
            buckets = new ArrayList<BucketDefinition>();
            try {
                if (bucketsAny.containsKey((Object)KEY_BUCKETS)) {
                    for (Any bucketAny : bucketsAny.getSeq(KEY_BUCKETS)) {
                        if (!bucketAny.isMap()) continue;
                        if (setReadOnly) {
                            bucketAny.asMap().put("readOnly", Boolean.valueOf(setReadOnly));
                        }
                        buckets.add(new BucketDefinition((AnyMap)bucketAny));
                    }
                    break block6;
                }
                throw new InvalidConfigException("Missing field buckets");
            }
            catch (InvalidConfigException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new InvalidConfigException("Invalid any structure", ex);
            }
        }
        return buckets;
    }

    public String getDataObjectType() {
        return this._dataObjectType;
    }

    public AnyMap getParameters() {
        return this._parameters;
    }

    @Override
    public AnyMap toAny(boolean includingAdditionalAttributes) {
        try {
            AnyMap bucketAny = super.toAny(includingAdditionalAttributes);
            if (!includingAdditionalAttributes) {
                bucketAny.put(KEY_TYPE, this._dataObjectType);
                if (this._parameters != null) {
                    bucketAny.put(KEY_PARAMETERS, (Any)this._parameters);
                }
            }
            return bucketAny;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to create Any object for bucket " + this._name, ex);
        }
    }
}

