/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager.httphandler;

import java.util.List;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.http.server.json.JsonRequestHandler;
import org.eclipse.smila.jobmanager.BucketDefinition;
import org.eclipse.smila.jobmanager.InvalidConfigException;
import org.eclipse.smila.jobmanager.JobManager;
import org.eclipse.smila.jobmanager.persistence.ConfigNotFoundException;
import org.eclipse.smila.jobmanager.persistence.DefinitionPersistence;
import org.osgi.service.component.ComponentContext;

public class BucketHandler
extends JsonRequestHandler {
    private JobManager _jobManager;
    private DefinitionPersistence _defPersistence;

    protected void activate(ComponentContext context) {
        super.activate(context);
        this._defPersistence = this._jobManager.getDefinitionPersistence();
    }

    protected void deactivate(ComponentContext context) {
        this._defPersistence = null;
    }

    public Object process(String method, String requestUri, Record inputRecord) throws Exception {
        String bucketName = this.getBucketName(requestUri);
        if ("GET".equals(method)) {
            BucketDefinition bucket;
            boolean returnDetails = false;
            if (inputRecord != null && inputRecord.getMetadata().containsKey((Object)"returnDetails")) {
                returnDetails = inputRecord.getMetadata().getBooleanValue("returnDetails");
            }
            if ((bucket = this._defPersistence.getBucket(bucketName)) == null) {
                throw new ConfigNotFoundException("Bucket '" + bucketName + "' not found.");
            }
            return bucket.toAny(returnDetails);
        }
        this._defPersistence.removeBucket(bucketName);
        return null;
    }

    protected int getErrorStatus(String method, String requestUri, Throwable ex) {
        if (ex instanceof IllegalArgumentException || ex instanceof InvalidConfigException) {
            return 400;
        }
        return super.getErrorStatus(method, requestUri, ex);
    }

    private String getBucketName(String requestUri) {
        List uriParts = this.getDynamicUriParts(requestUri);
        if (uriParts.size() > 0) {
            return (String)uriParts.get(0);
        }
        throw new IllegalArgumentException("Invalid request URI, does not match uri pattern '" + this.getUriPattern() + "'.");
    }

    protected boolean isValidMethod(String method, String requestUri) {
        return "GET".equals(method) || "DELETE".equals(method);
    }

    public void setJobManager(JobManager jobManager) {
        this._jobManager = jobManager;
    }

    public void unsetJobManager(JobManager jobManager) {
        if (this._jobManager == jobManager) {
            this._jobManager = null;
        }
    }
}

