/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager.httphandler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.http.server.json.JsonRequestHandler;
import org.eclipse.smila.http.server.util.URLCreator;
import org.eclipse.smila.jobmanager.JobManager;
import org.eclipse.smila.jobmanager.persistence.DefinitionPersistence;
import org.eclipse.smila.jobmanager.persistence.PersistenceException;
import org.eclipse.smila.utils.http.NotFoundHTTPResult;
import org.osgi.service.component.ComponentContext;

public class WorkersHandler
extends JsonRequestHandler {
    private JobManager _jobManager;
    private DefinitionPersistence _defPersistence;

    protected void activate(ComponentContext context) {
        super.activate(context);
        this._defPersistence = this._jobManager.getDefinitionPersistence();
    }

    protected void deactivate(ComponentContext context) {
        this._defPersistence = null;
    }

    public Object process(String method, String requestUri, Record inputRecord) throws Exception {
        HashMap resultMap = new HashMap();
        ArrayList workerList = new ArrayList();
        for (String workerDefinitionName : this._defPersistence.getWorkers()) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("name", workerDefinitionName);
            map.put("url", URLCreator.create((String)this.getRequestHost(), (String)requestUri, (String)workerDefinitionName));
            workerList.add(map);
        }
        resultMap.put("workers", workerList);
        return resultMap;
    }

    protected int getErrorStatus(String method, String requestUri, Throwable ex) {
        if (ex instanceof NotFoundHTTPResult) {
            return 404;
        }
        if (ex instanceof PersistenceException) {
            return 500;
        }
        return super.getErrorStatus(method, requestUri, ex);
    }

    protected boolean isValidMethod(String method, String requestUri) {
        return "GET".equals(method);
    }

    public void setJobManager(JobManager jobManager) {
        this._jobManager = jobManager;
    }

    public void unsetJobManager(JobManager jobManager) {
        if (this._jobManager == jobManager) {
            this._jobManager = null;
        }
    }
}

