/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.bulkbuilder.helper;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.smila.bulkbuilder.BulkbuilderException;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.ipc.IpcSerializationUtils;

public class MicroBulkbuilder {
    private static final int DEFAULT_EXPECTED_NUMBER_OF_RECORDS = 32;
    private final IpcSerializationUtils _serializationUtils = new IpcSerializationUtils();
    private final Map<String, ByteArrayOutputStream> _microBulks = new ConcurrentHashMap<String, ByteArrayOutputStream>();
    private final Map<String, Integer> _recordCounts = new ConcurrentHashMap<String, Integer>();
    private long _limitOfParallelBulks = -1L;

    public MicroBulkbuilder(long limitOfParallelBulks) {
        this._limitOfParallelBulks = limitOfParallelBulks;
    }

    public void addToMicroBulk(String microBulkId, Record record) throws BulkbuilderException {
        try {
            byte[] newData = this._serializationUtils.record2BinaryObject(record);
            ByteArrayOutputStream microBulk = this._microBulks.get(microBulkId);
            if (microBulk == null) {
                microBulk = this.initMicroBulk(microBulkId, newData.length);
            }
            microBulk.write(newData);
            this.addToRecordCountMap(microBulkId);
        }
        catch (IOException e) {
            throw new BulkbuilderException("Error appending record to micro bulk", e);
        }
    }

    public byte[] finishMicroBulk(String microBulkId) {
        this._recordCounts.remove(microBulkId);
        ByteArrayOutputStream microBulk = this._microBulks.remove(microBulkId);
        if (microBulk == null) {
            return null;
        }
        return microBulk.toByteArray();
    }

    public Integer getNumberOfRecords(String microBulkId) {
        Integer value = this._recordCounts.get(microBulkId);
        if (value == null) {
            return 0;
        }
        return value;
    }

    private synchronized ByteArrayOutputStream initMicroBulk(String microBulkId, int expectedRecordSize) throws BulkbuilderException {
        if (this._limitOfParallelBulks > 0L && (long)this._microBulks.size() >= this._limitOfParallelBulks) {
            throw new BulkbuilderException("No of parallel micro bulks exceeded configured limit " + this._limitOfParallelBulks);
        }
        ByteArrayOutputStream microBulk = new ByteArrayOutputStream(expectedRecordSize * 32);
        this._microBulks.put(microBulkId, microBulk);
        this._recordCounts.put(microBulkId, 0);
        return microBulk;
    }

    private void addToRecordCountMap(String microBulkId) {
        Integer value = this._recordCounts.get(microBulkId);
        this._recordCounts.put(microBulkId, value + 1);
    }
}

