/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.management.jmx;

import java.lang.management.ManagementFactory;
import java.util.HashSet;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.management.ManagementAgent;
import org.eclipse.smila.management.ManagementAgentLocation;
import org.eclipse.smila.management.RegistrationException;
import org.eclipse.smila.management.controller.ManagementController;
import org.eclipse.smila.management.jmx.DynamicMBeanBuilder;

public class JmxManagementController
implements ManagementController {
    private static final String DOMAIN = "SMILA";
    private final Log _log = LogFactory.getLog(JmxManagementController.class);
    private final Object _monitor = new Object();
    private final MBeanServer _server = ManagementFactory.getPlatformMBeanServer();
    private final Set<ManagementAgentLocation> _agents = new HashSet<ManagementAgentLocation>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAgent(ManagementAgentLocation location, ManagementAgent agent) throws RegistrationException {
        ObjectName objectName = this.buildObjectName(location);
        DynamicMBeanBuilder dynamicMBeanBuilder = new DynamicMBeanBuilder(objectName, location, agent);
        Object dmBean = dynamicMBeanBuilder.build();
        Object object = this._monitor;
        synchronized (object) {
            this.register(objectName, dmBean);
        }
    }

    public void unregisterAgent(ManagementAgentLocation location) throws RegistrationException {
        ObjectName objectName = this.buildObjectName(location);
        this.unregister(objectName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAll() {
        Object object = this._monitor;
        synchronized (object) {
            for (ManagementAgentLocation location : this._agents) {
                try {
                    this.unregisterAgent(location);
                }
                catch (Throwable exception) {
                    this._log.error((Object)("Error unregistering agent = " + location.getPath()), exception);
                }
            }
        }
    }

    private void register(ObjectName objectName, Object bean) throws RegistrationException {
        this.unregister(objectName);
        try {
            this._server.registerMBean(bean, objectName);
        }
        catch (Throwable e) {
            throw new RegistrationException(e);
        }
    }

    private void unregister(ObjectName objectName) throws RegistrationException {
        try {
            MBeanInfo beanInfo = this._server.getMBeanInfo(objectName);
            if (beanInfo != null) {
                this._server.unregisterMBean(objectName);
            }
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
        }
        catch (Throwable e) {
            throw new RegistrationException(e);
        }
    }

    private ObjectName buildObjectName(ManagementAgentLocation location) throws RegistrationException {
        ObjectName objectName = null;
        String objectNameString = "SMILA:";
        if (location.getCategory() != null && location.getCategory().getPath() != null && !"".equals(location.getCategory().getPath())) {
            String[] categories = location.getCategory().getPath().split("/");
            int i = 0;
            while (i < categories.length) {
                objectNameString = String.valueOf(objectNameString) + String.format("C%d=%s,", i, categories[i]);
                ++i;
            }
        }
        objectNameString = String.valueOf(objectNameString) + "Agent=" + location.getName();
        this._log.info((Object)objectNameString);
        try {
            objectName = new ObjectName(objectNameString);
        }
        catch (Throwable e) {
            throw new RegistrationException(e);
        }
        return objectName;
    }
}

