/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.binarystorage.persistence.jpa;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.io.IOUtils;

public class BinaryStorageDao
implements Serializable {
    private static final long serialVersionUID = 6500268394234442139L;
    private String _id;
    private byte[] _binObject;

    protected BinaryStorageDao() {
    }

    public BinaryStorageDao(String id, byte[] data) {
        if (id == null) {
            throw new IllegalArgumentException("parameter id is null");
        }
        if (id.length() == 0) {
            throw new IllegalArgumentException("parameter id is an empty String");
        }
        this._id = id;
        this._binObject = data;
    }

    public BinaryStorageDao(String id, InputStream input) throws IOException {
        if (id == null) {
            throw new IllegalArgumentException("parameter id is null");
        }
        if (id.length() == 0) {
            throw new IllegalArgumentException("parameter id is an empty String");
        }
        if (input == null) {
            throw new IllegalArgumentException("parameter input is null");
        }
        this._id = id;
        this._binObject = IOUtils.toByteArray((InputStream)input);
    }

    public String getId() {
        return this._id;
    }

    public byte[] getBytes() {
        return this._binObject;
    }

    public ByteArrayInputStream getBytesAsStream() {
        return new ByteArrayInputStream(this._binObject);
    }
}

