/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.bpel;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.xml.namespace.QName;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.rtrep.common.extension.AbstractExtensionBundle;
import org.apache.ode.utils.DOMUtils;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.clusterconfig.ClusterConfigService;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.objectstore.ObjectStoreService;
import org.eclipse.smila.ode.ODEConfigProperties;
import org.eclipse.smila.ode.ODEServer;
import org.eclipse.smila.ode.ODEServerContextFactory;
import org.eclipse.smila.ode.ODEServerException;
import org.eclipse.smila.ode.WebServiceContextFactory;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.WorkflowProcessor;
import org.eclipse.smila.processing.bpel.MessageHelper;
import org.eclipse.smila.processing.bpel.ODEDeploymentManager;
import org.eclipse.smila.processing.bpel.PipeletManager;
import org.eclipse.smila.processing.bpel.PipelinePerformanceCounter;
import org.eclipse.smila.processing.bpel.SMILAExtensionBundle;
import org.eclipse.smila.processing.bpel.WorkflowStorage;
import org.eclipse.smila.processing.bpel.WorkflowUpdateWatcher;
import org.eclipse.smila.utils.config.ConfigUtils;
import org.eclipse.smila.zookeeper.ZooKeeperService;
import org.osgi.service.component.ComponentContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ODEWorkflowProcessor
implements WorkflowProcessor {
    public static final String WORKFLOW_STORE = "bpel";
    private static final String ERROR_CLUSTER_INCONSISTENT = " There may be inconsistencies in cluster deploy of this workflow. Please repeat the operation.";
    private final Log _log = LogFactory.getLog(this.getClass());
    private Properties _properties;
    private ODEServer _bpelServer;
    private WebServiceContextFactory _processingContext;
    private WorkflowStorage _workflowStorage;
    private ODEDeploymentManager _deploymentManager;
    private WorkflowUpdateWatcher _updateWatcher;
    private ObjectStoreService _objectStoreService;
    private ClusterConfigService _clusterConfigService;
    private ZooKeeperService _zkService;
    private final AtomicLong _requestIdSequence = new AtomicLong(0L);
    private final Map<String, Blackboard> _blackboards = new Hashtable<String, Blackboard>();
    private final Map<String, Exception> _pipeletExceptions = new HashMap<String, Exception>();
    private MessageHelper _messageHelper;
    private final Map<String, PipelinePerformanceCounter> _pipelinePerformanceCounter = new HashMap<String, PipelinePerformanceCounter>();
    private final ReadWriteLock _lock = new ReentrantReadWriteLock(true);

    public ODEWorkflowProcessor() {
        this._log.debug((Object)(String.valueOf(this.getClass().getName()) + " instance created."));
    }

    public String[] process(String workflowName, Blackboard blackboard, String[] recordIds) throws ProcessingException {
        long startTime = System.nanoTime();
        String requestId = this.initRequest(blackboard);
        String[] resultIds = null;
        boolean success = false;
        PipelinePerformanceCounter counter = this._pipelinePerformanceCounter.get(workflowName);
        try {
            if (this._bpelServer == null) {
                throw new ProcessingException("Cannot process request, because BPEL engine is not yet initialised");
            }
            Element message = this._messageHelper.createMessage(blackboard, recordIds, requestId);
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)("Request: " + DOMUtils.domToString((Node)message)));
            }
            QName processQName = this.getProcessId(workflowName);
            try {
                Element result = this._bpelServer.invoke(processQName, "process", message);
                if (result != null) {
                    if (this._log.isTraceEnabled()) {
                        this._log.trace((Object)("Final Result: " + DOMUtils.domToString((Node)result)));
                    }
                    resultIds = this._messageHelper.parseMessage(blackboard, result);
                    success = true;
                    String[] stringArray = resultIds;
                    return stringArray;
                }
                return null;
            }
            catch (ODEServerException ex) {
                try {
                    Exception pipeletEx = this._pipeletExceptions.get(requestId);
                    String details = pipeletEx == null ? ex.getMessage() : pipeletEx.getMessage();
                    Throwable cause = pipeletEx == null ? ex : pipeletEx;
                    throw new ProcessingException("Error processing BPEL workflow " + workflowName + ": " + details, cause);
                }
                catch (ProcessingException ex2) {
                    this.countError(ex2, false, counter);
                    throw ex2;
                }
                catch (Throwable ex3) {
                    this.countError(ex3, true, counter);
                    throw new ProcessingException(ex3);
                }
            }
        }
        finally {
            this.cleanupRequest(requestId);
            this.countInvocation(recordIds, resultIds, startTime, success, counter);
        }
    }

    public List<String> getWorkflowNames() {
        if (this._pipelinePerformanceCounter == null) {
            return null;
        }
        return new ArrayList<String>(this._pipelinePerformanceCounter.keySet());
    }

    public AnyMap getWorkflowDefinition(String workflowName) throws ProcessingException {
        QName processId = this.getProcessId(workflowName);
        try {
            if (this._deploymentManager.isPredefinedWorkflow(workflowName)) {
                AnyMap resultMap = DataFactory.DEFAULT.createAnyMap();
                String bpelContent = this._bpelServer.getBpelDocument(processId);
                if (bpelContent != null) {
                    Value bpel = DataFactory.DEFAULT.createStringValue(bpelContent);
                    resultMap.put("name", workflowName);
                    resultMap.put("readOnly", Boolean.valueOf(true));
                    resultMap.put("definition", (Any)bpel);
                    return resultMap;
                }
            } else if (this._deploymentManager.isCustomWorkflow(workflowName)) {
                return this._workflowStorage.getWorkflow(workflowName);
            }
        }
        catch (Exception ex) {
            throw new ProcessingException("Error reading BPEL definition for workflow '" + workflowName + "'", (Throwable)ex);
        }
        return null;
    }

    public void setWorkflowDefinition(String workflowName, AnyMap workflowDefinition) throws ProcessingException {
        this.checkWorkflowName(workflowName);
        workflowDefinition.remove((Object)"readOnly");
        String timestamp = this.setTimestamp(workflowDefinition);
        if (StringUtils.isEmpty((String)workflowDefinition.getStringValue("definition"))) {
            throw new ProcessingException("Workflow '" + workflowName + "' can not be deployed, " + "definition" + " is empty");
        }
        File deployDir = this._deploymentManager.validateWorkflow(workflowName, workflowDefinition);
        AnyMap oldWorkflowAny = this._workflowStorage.getWorkflow(workflowName);
        this._workflowStorage.setWorkflow(workflowName, workflowDefinition);
        try {
            this._updateWatcher.workflowUpdated(workflowName, timestamp);
        }
        catch (ProcessingException e) {
            String errorMessage = "Error updating workflow '" + workflowName + "'.";
            this._log.warn((Object)(String.valueOf(errorMessage) + " Error while notifying update watcher."), (Throwable)e);
            try {
                if (oldWorkflowAny != null) {
                    this._workflowStorage.setWorkflow(workflowName, oldWorkflowAny);
                } else {
                    this._workflowStorage.deleteWorkflow(workflowName);
                }
            }
            catch (ProcessingException e2) {
                errorMessage = String.valueOf(errorMessage) + ERROR_CLUSTER_INCONSISTENT;
                this._log.error((Object)(String.valueOf(errorMessage) + " Error rolling back storage of new workflow version."), (Throwable)e2);
            }
            throw new ProcessingException(errorMessage, (Throwable)e, true);
        }
        try {
            QName processName = this._deploymentManager.deployWorkflowDir(workflowName, deployDir);
            this.registerPipeline(processName);
        }
        catch (ProcessingException e) {
            String errorMessage = "Error updating workflow '" + workflowName + "'." + ERROR_CLUSTER_INCONSISTENT;
            this._log.error((Object)(String.valueOf(errorMessage) + " Error deploying new workflow version."), (Throwable)e);
            throw new ProcessingException(errorMessage, (Throwable)e, true);
        }
    }

    public void deleteWorkflowDefinition(String workflowName) throws ProcessingException {
        this.checkWorkflowName(workflowName);
        AnyMap oldWorkflowAny = this._workflowStorage.getWorkflow(workflowName);
        this._workflowStorage.deleteWorkflow(workflowName);
        try {
            this._updateWatcher.workflowDeleted(workflowName);
        }
        catch (ProcessingException e) {
            String errorMessage = "Error deleting workflow '" + workflowName + "'.";
            this._log.warn((Object)(String.valueOf(errorMessage) + " Error while notifying update watcher."), (Throwable)e);
            try {
                if (oldWorkflowAny != null) {
                    this._workflowStorage.setWorkflow(workflowName, oldWorkflowAny);
                }
            }
            catch (ProcessingException e2) {
                errorMessage = String.valueOf(errorMessage) + ERROR_CLUSTER_INCONSISTENT;
                this._log.error((Object)(String.valueOf(errorMessage) + " Error rolling back deletion of workflow."), (Throwable)e2);
            }
            throw new ProcessingException(errorMessage, (Throwable)e, true);
        }
        try {
            QName processName = this._deploymentManager.undeployWorkflow(workflowName);
            this.unregisterPipeline(processName);
        }
        catch (ProcessingException e) {
            String errorMessage = "Error deleting workflow '" + workflowName + "'." + ERROR_CLUSTER_INCONSISTENT;
            this._log.error((Object)(String.valueOf(errorMessage) + " Error undeploying workflow."), (Throwable)e);
            throw new ProcessingException(errorMessage, (Throwable)e, true);
        }
    }

    public void synchronizeWorkflowDefinition(String workflowName, boolean isDeleted) throws ProcessingException {
        this.checkWorkflowName(workflowName);
        AnyMap workflowDefinition = this._workflowStorage.getWorkflow(workflowName);
        if (isDeleted) {
            QName processName = this._deploymentManager.undeployWorkflow(workflowName);
            this.unregisterPipeline(processName);
        } else {
            if (workflowDefinition == null) {
                throw new ProcessingException("Definition for workflow '" + workflowName + "' not found for reload.");
            }
            QName processName = this._deploymentManager.deployWorkflow(workflowName, workflowDefinition);
            this.registerPipeline(processName);
        }
    }

    public Blackboard getBlackboard(String id) throws ProcessingException {
        Blackboard blackboard = this._blackboards.get(id);
        if (blackboard == null) {
            throw new ProcessingException("Blackboard for request " + id + " is not registered anymore.");
        }
        return blackboard;
    }

    public void setPipeletException(String requestId, Exception ex) {
        this._pipeletExceptions.put(requestId, ex);
    }

    public MessageHelper getMessageHelper() {
        return this._messageHelper;
    }

    protected void activate(ComponentContext context) {
        this._lock.writeLock().lock();
        try {
            try {
                this._workflowStorage = new WorkflowStorage(WORKFLOW_STORE, this._objectStoreService, this._clusterConfigService);
                if (this._bpelServer == null) {
                    this.readConfiguration();
                    this._messageHelper = new MessageHelper(this._properties);
                    this._updateWatcher = new WorkflowUpdateWatcher(this._zkService, this);
                    this.initializeBPEL();
                    this._updateWatcher.startPolling();
                    this._updateWatcher.startWatching();
                }
            }
            catch (Throwable ex) {
                this._log.error((Object)"Start of BPEL workflow service failed: Unknown fatal error. Service is non-functional, please fix problem and restart bundle", ex);
                this._lock.writeLock().unlock();
            }
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }

    protected void deactivate(ComponentContext context) {
        this._lock.writeLock().lock();
        try {
            if (this._updateWatcher != null) {
                this._updateWatcher.stopPolling();
                this._updateWatcher.stopWatching();
            }
            if (this._bpelServer != null) {
                this._bpelServer.shutdown();
                this._bpelServer = null;
                this._processingContext = null;
            }
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }

    public void setObjectStoreService(ObjectStoreService objectStore) {
        this._objectStoreService = objectStore;
    }

    public void unsetObjectStoreService(ObjectStoreService objectStore) {
        if (this._objectStoreService == objectStore) {
            this._objectStoreService = null;
        }
    }

    public void setClusterConfigService(ClusterConfigService ccs) {
        this._clusterConfigService = ccs;
    }

    public void unsetClusterConfigService(ClusterConfigService ccs) {
        if (this._clusterConfigService == ccs) {
            this._clusterConfigService = null;
        }
    }

    public void setZooKeeperService(ZooKeeperService zks) {
        this._zkService = zks;
    }

    public void unsetZooKeeperService(ZooKeeperService zks) {
        if (this._zkService == zks) {
            this._zkService = null;
        }
    }

    private void initializeBPEL() throws IOException, ODEServerException {
        this._log.debug((Object)"Initialize BPEL engine");
        ODEConfigProperties odeConfig = new ODEConfigProperties(this._properties, "ode.");
        this._processingContext = new WebServiceContextFactory();
        this._bpelServer = new ODEServer(odeConfig, (ODEServerContextFactory)this._processingContext);
        this._bpelServer.registerExtensionBundle((AbstractExtensionBundle)new SMILAExtensionBundle());
        this._deploymentManager = new ODEDeploymentManager(this._bpelServer);
        try {
            this.deployPredefinedPipelines();
        }
        catch (ProcessingException ex) {
            this._log.error((Object)"Deployment of predefined pipelines failed. Installing custom pipelines should still work.", (Throwable)ex);
        }
        try {
            this.deployCustomPipelines();
        }
        catch (ProcessingException ex) {
            this._log.error((Object)"Deployment of existing custom pipelines failed. Installing additional custom pipelines should still work.", (Throwable)ex);
        }
        this._log.debug((Object)"Initialization of BPEL engine successful");
    }

    private QName getProcessId(String workflowName) {
        return new QName("http://www.eclipse.org/smila/processor", workflowName);
    }

    private void deployPredefinedPipelines() throws ProcessingException, IOException {
        String pipelineDirName = this._properties.getProperty("pipeline.dir", "pipelines");
        Collection<QName> processes = this._deploymentManager.deployPredefinedWorkflows(pipelineDirName);
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        for (QName processName : processes) {
            this._log.info((Object)("Registering predefined pipeline " + processName));
            this.registerPipeline(processName);
        }
        Thread.currentThread().setContextClassLoader(oldCL);
    }

    private void deployCustomPipelines() throws ProcessingException, IOException {
        Collection<String> workflowNames = this._workflowStorage.getWorkflowNames();
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        for (String workflowName : workflowNames) {
            AnyMap workflowDefinition = this._workflowStorage.getWorkflow(workflowName);
            String timestamp = workflowDefinition.getStringValue("timestamp");
            QName processName = this._deploymentManager.deployWorkflow(workflowName, workflowDefinition);
            this._updateWatcher.workflowLoadedOnStart(workflowName, timestamp);
            this._log.info((Object)("Registering custom pipeline " + processName));
            this.registerPipeline(processName);
        }
        Thread.currentThread().setContextClassLoader(oldCL);
    }

    private void registerPipeline(QName processName) {
        PipeletManager.getInstance().registerPipeline(this, processName);
        String pipelineName = processName.getLocalPart();
        this._pipelinePerformanceCounter.put(pipelineName, new PipelinePerformanceCounter(pipelineName));
    }

    private void unregisterPipeline(QName processName) {
        if (processName != null) {
            PipeletManager.getInstance().registerPipeline(this, processName);
            String pipelineName = processName.getLocalPart();
            this._pipelinePerformanceCounter.remove(pipelineName);
        }
    }

    private void checkWorkflowName(String workflowName) throws ProcessingException {
        if (StringUtils.isEmpty((String)workflowName)) {
            throw new ProcessingException("Workflow name must not be undefined or empty.");
        }
        if (this._deploymentManager.isPredefinedWorkflow(workflowName)) {
            throw new ProcessingException("Workflow '" + workflowName + "' can not be changed, cause it's predefined");
        }
    }

    private String setTimestamp(AnyMap workflowDefinition) {
        Value value = workflowDefinition.getFactory().createDateTimeValue(new Date());
        workflowDefinition.put("timestamp", (Any)value);
        return value.asString();
    }

    private void readConfiguration() throws IOException {
        this._properties = new Properties();
        InputStream configurationFileStream = null;
        try {
            try {
                configurationFileStream = ConfigUtils.getConfigStream((String)"org.eclipse.smila.processing.bpel", (String)"processor.properties");
                this._properties.load(configurationFileStream);
            }
            catch (IOException ex) {
                throw new IOException("Could not read configuration property file processor.properties: " + ex.toString());
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(configurationFileStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)configurationFileStream);
    }

    private String initRequest(Blackboard blackboard) {
        this._lock.readLock().lock();
        String requestId = Long.toString(this._requestIdSequence.getAndIncrement());
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Starting to process request ID = " + requestId));
        }
        this._blackboards.put(requestId, blackboard);
        return requestId;
    }

    private void countInvocation(String[] incomingIds, String[] outgoingIds, long startTime, boolean success, PipelinePerformanceCounter counter) {
        if (counter != null) {
            counter.countInvocationNanos(System.nanoTime() - startTime, success, ArrayUtils.getLength((Object)incomingIds), ArrayUtils.getLength((Object)outgoingIds));
        }
    }

    private void countError(Throwable ex, boolean isCritical, PipelinePerformanceCounter counter) {
        if (counter != null) {
            counter.addError(ex, isCritical);
        }
    }

    private void cleanupRequest(String requestId) {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Cleaning up request ID = " + requestId));
        }
        this._blackboards.remove(requestId);
        this._pipeletExceptions.remove(requestId);
        this._lock.readLock().unlock();
    }
}

