/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.bpel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.clusterconfig.ClusterConfigException;
import org.eclipse.smila.clusterconfig.ClusterConfigService;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.ipc.IpcSerializationUtils;
import org.eclipse.smila.objectstore.ObjectStoreException;
import org.eclipse.smila.objectstore.ObjectStoreService;
import org.eclipse.smila.objectstore.ServiceUnavailableException;
import org.eclipse.smila.objectstore.StoreObject;
import org.eclipse.smila.objectstore.StoreOutputStream;
import org.eclipse.smila.objectstore.util.ObjectStoreRetryUtil;
import org.eclipse.smila.processing.ProcessingException;

public final class WorkflowStorage {
    private static final int MAX_RETRY_ON_STORE_UNAVAILABLE = 3;
    private final Log _log = LogFactory.getLog(this.getClass());
    private final IpcSerializationUtils _serializationUtils = new IpcSerializationUtils();
    private boolean _isStorePrepared;
    private final String _storeName;
    private final ObjectStoreService _objectStoreService;
    private final ClusterConfigService _clusterConfigService;

    public WorkflowStorage(String storeName, ObjectStoreService objectStore, ClusterConfigService clusterConfig) {
        this._storeName = storeName;
        this._objectStoreService = objectStore;
        this._clusterConfigService = clusterConfig;
    }

    public void setWorkflow(String workflowName, AnyMap workflow) throws ProcessingException {
        try {
            this.writeObjectToStore(workflowName, workflow);
        }
        catch (ObjectStoreException e) {
            throw new ProcessingException("Error adding workflow '" + workflowName + "' to store", (Throwable)e);
        }
    }

    public void deleteWorkflow(String workflowName) throws ProcessingException {
        try {
            this.removeObjectFromStore(workflowName);
        }
        catch (ObjectStoreException e) {
            throw new ProcessingException("Error deleting workflow '" + workflowName + "' to store", (Throwable)e);
        }
    }

    public AnyMap getWorkflow(String workflowName) throws ProcessingException {
        block3: {
            try {
                if (this.existsObjectInStore(workflowName)) break block3;
                return null;
            }
            catch (ObjectStoreException e) {
                throw new ProcessingException("Error getting workflow '" + workflowName + "' from store", (Throwable)e);
            }
        }
        return this.readObjectFromStore(workflowName);
    }

    public Collection<String> getWorkflowNames() throws ProcessingException {
        try {
            return this.readObjectNamesFromStore();
        }
        catch (ObjectStoreException e) {
            throw new ProcessingException("Error getting workflow names from store", (Throwable)e);
        }
    }

    /*
     * Loose catch block
     */
    private void writeObjectToStore(String objectId, AnyMap object) throws ObjectStoreException {
        Throwable retryableEx = null;
        this.ensureStore();
        int i = 0;
        while (i < 3) {
            StoreOutputStream storeOutputStream = null;
            try {
                storeOutputStream = this._objectStoreService.writeObject(this._storeName, objectId);
                this._serializationUtils.map2JsonStream((OutputStream)storeOutputStream, object);
            }
            catch (IOException ex) {
                if (storeOutputStream != null) {
                    storeOutputStream.abort();
                }
                retryableEx = ex;
                this._log.warn((Object)("IOException on writing object '" + objectId + "', retrying: " + ex.toString()));
                IOUtils.closeQuietly((OutputStream)storeOutputStream);
            }
            catch (ServiceUnavailableException ex2) {
                retryableEx = ex2;
                this._log.warn((Object)("ServiceUnavailableException on writing object '" + objectId + "', retrying: " + ex2.toString()));
                {
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(storeOutputStream);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((OutputStream)storeOutputStream);
            }
            IOUtils.closeQuietly((OutputStream)storeOutputStream);
            return;
            ++i;
        }
        throw new ServiceUnavailableException("Finally failed to write object '" + objectId + "' to store", retryableEx);
    }

    private Collection<String> readObjectNamesFromStore() throws ObjectStoreException {
        this.ensureStore();
        TreeSet<String> objectNames = new TreeSet<String>();
        for (StoreObject info : this._objectStoreService.getStoreObjectInfos(this._storeName)) {
            String objectName = info.getId();
            objectNames.add(objectName);
        }
        return objectNames;
    }

    private AnyMap readObjectFromStore(String objectId) throws ObjectStoreException {
        this.ensureStore();
        Throwable retryableEx = null;
        int i = 0;
        while (i < 3) {
            block7: {
                AnyMap anyMap;
                InputStream jobJsonStream = null;
                try {
                    jobJsonStream = this._objectStoreService.readObject(this._storeName, objectId);
                    anyMap = this._serializationUtils.jsonStream2record(jobJsonStream).getMetadata();
                }
                catch (Throwable throwable) {
                    try {
                        IOUtils.closeQuietly(jobJsonStream);
                        throw throwable;
                    }
                    catch (IOException ex) {
                        retryableEx = ex;
                        this._log.warn((Object)("IOException on writing object '" + objectId + "', retrying: " + ex.toString()));
                        break block7;
                    }
                    catch (ServiceUnavailableException ex) {
                        retryableEx = ex;
                        this._log.warn((Object)("ServiceUnavailableException on writing object '" + objectId + "', retrying: " + ex.toString()));
                    }
                }
                IOUtils.closeQuietly((InputStream)jobJsonStream);
                return anyMap;
            }
            ++i;
        }
        throw new ServiceUnavailableException("Finally failed to read object '" + objectId + "' from store", retryableEx);
    }

    private boolean existsObjectInStore(String objectId) throws ObjectStoreException {
        this.ensureStore();
        return ObjectStoreRetryUtil.retryExistsObject((ObjectStoreService)this._objectStoreService, (String)this._storeName, (String)objectId);
    }

    private void removeObjectFromStore(String objectId) throws ObjectStoreException {
        this.ensureStore();
        this._objectStoreService.removeObject(this._storeName, objectId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureStore() throws ObjectStoreException {
        if (!this._isStorePrepared) {
            AnyMap storeProps = this.getStoreProperties();
            ServiceUnavailableException ioex = null;
            int i = 0;
            while (i < 3) {
                try {
                    WorkflowStorage workflowStorage = this;
                    synchronized (workflowStorage) {
                        if (!this._objectStoreService.existsStore(this._storeName)) {
                            this._objectStoreService.createStore(this._storeName, storeProps);
                        }
                        this._isStorePrepared = true;
                        return;
                    }
                }
                catch (ServiceUnavailableException ex) {
                    ioex = ex;
                    this._log.warn((Object)("ServiceUnavailableException on preparing store '" + this._storeName + "', retrying: " + ex.toString()));
                    ++i;
                }
            }
            throw new ServiceUnavailableException("Finally failed to prepare store '" + this._storeName + "'", (Throwable)ioex);
        }
    }

    private AnyMap getStoreProperties() {
        long replicationlevel;
        long commitlevel;
        int numberOfNodes = 1;
        long failSafetyLevel = 0L;
        try {
            numberOfNodes = this._clusterConfigService.getClusterNodes().size();
            failSafetyLevel = this._clusterConfigService.getFailSafetyLevel();
        }
        catch (ClusterConfigException clusterConfigException) {
            this._log.warn((Object)"Can't connect to local ClusterConfigService");
        }
        if (numberOfNodes <= 2) {
            commitlevel = 0L;
            replicationlevel = numberOfNodes - 1;
        } else {
            commitlevel = 1L;
            replicationlevel = commitlevel + failSafetyLevel;
        }
        AnyMap storeProperties = DataFactory.DEFAULT.createAnyMap();
        storeProperties.put("replicationlevel", (Number)replicationlevel);
        storeProperties.put("commitlevel", (Number)commitlevel);
        return storeProperties;
    }
}

