/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.lucene.internal;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.datamodel.ValueFormatHelper;
import org.eclipse.smila.lucene.LuceneIndexService;
import org.eclipse.smila.lucene.LuceneSearchService;
import org.eclipse.smila.lucene.LuceneService;
import org.eclipse.smila.lucene.internal.MappingsLoader;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.search.api.helper.QueryParameterAccessor;
import org.eclipse.smila.search.datadictionary.DataDictionaryController;
import org.eclipse.smila.search.datadictionary.DataDictionaryException;
import org.eclipse.smila.search.datadictionary.messages.datadictionary.DAnyFinderDataDictionary;
import org.eclipse.smila.search.datadictionary.messages.datadictionary.DIndex;
import org.eclipse.smila.search.datadictionary.messages.ddconfig.DFieldConfig;
import org.eclipse.smila.search.index.IndexAdmin;
import org.eclipse.smila.search.index.IndexConnection;
import org.eclipse.smila.search.index.IndexException;
import org.eclipse.smila.search.index.IndexManager;
import org.eclipse.smila.search.lucene.index.access.IndexWriterPool;
import org.eclipse.smila.search.lucene.tools.search.lucene.DTextFieldParameter;
import org.eclipse.smila.search.plugin.IIndexAccess;
import org.eclipse.smila.search.plugin.Plugin;
import org.eclipse.smila.search.plugin.PluginFactory;
import org.eclipse.smila.search.templates.NodeTransformerException;
import org.eclipse.smila.search.utils.search.DDateField;
import org.eclipse.smila.search.utils.search.DField;
import org.eclipse.smila.search.utils.search.DNumberField;
import org.eclipse.smila.search.utils.search.DQuery;
import org.eclipse.smila.search.utils.search.DTextField;
import org.eclipse.smila.search.utils.search.ITFParameter;
import org.eclipse.smila.search.utils.searchresult.DHit;
import org.eclipse.smila.search.utils.searchresult.LuceneSearchResult;
import org.eclipse.smila.utils.log.RecordLifecycleLogHelper;
import org.osgi.service.component.ComponentContext;

public class LuceneServiceImpl
implements LuceneService,
LuceneSearchService,
LuceneIndexService {
    private final Log _log = LogFactory.getLog(LuceneServiceImpl.class);
    private HashMap<String, HashMap<String, HashMap<Integer, String>>> _reverseMappings = new HashMap();
    private DAnyFinderDataDictionary _dataDictionary;
    private HashMap<String, HashMap<String, HashMap<String, Integer>>> _mappings;
    private IndexAdmin _indexAdmin;
    private Set<String> _indices = Collections.synchronizedSet(new HashSet());
    private final ReadWriteLock _lock = new ReentrantReadWriteLock(true);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate(ComponentContext context) throws Exception {
        try {
            this.loadMappings();
            this.loadReverseMappings();
            this._dataDictionary = DataDictionaryController.getDataDictionary();
        }
        catch (Exception e) {
            if (this._log.isErrorEnabled()) {
                this._log.error((Object)"error initializing LuceneSearchService", (Throwable)e);
            }
            throw e;
        }
        Set<String> set = this._indices;
        synchronized (set) {
            try {
                this.loadMappings();
                Plugin plugin = PluginFactory.getPlugin();
                IIndexAccess indexAccess = plugin.getIndexAccess();
                this._indexAdmin = indexAccess.getIndexAdmin();
                DAnyFinderDataDictionary dic = DataDictionaryController.getDataDictionary();
                Enumeration indices = dic.getIndices();
                while (indices.hasMoreElements()) {
                    DIndex dIndex = (DIndex)indices.nextElement();
                    if (!this._indexAdmin.exists(dIndex.getName())) {
                        if (this._log.isInfoEnabled()) {
                            this._log.info((Object)("Physical Index [" + dIndex.getName() + "] doesn\ufffd\ufffdt exist. Adapt DataDictionary."));
                        }
                        DataDictionaryController.deleteIndex((String)dIndex.getName());
                        continue;
                    }
                    this._indices.add(dIndex.getName());
                }
            }
            catch (Exception e) {
                if (this._log.isErrorEnabled()) {
                    this._log.error((Object)"error initializing LuceneIndexService", (Throwable)e);
                }
                throw e;
            }
        }
    }

    protected void deactivate(ComponentContext context) throws Exception {
        try {
            this.unloadReverseMappings();
            this.unloadMappings();
            this._dataDictionary = null;
        }
        catch (Exception e) {
            if (this._log.isErrorEnabled()) {
                this._log.error((Object)"error deactivating LuceneSearchService", (Throwable)e);
            }
            throw e;
        }
        this._lock.writeLock().lock();
        try {
            try {
                this._indices = null;
                this._indexAdmin = null;
                this.unloadMappings();
            }
            catch (Exception e) {
                if (this._log.isErrorEnabled()) {
                    this._log.error((Object)"error deactivating LuceneIndexService", (Throwable)e);
                }
                throw e;
            }
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }

    @Override
    public void search(Blackboard blackboard, String requestId, QueryParameterAccessor parameters) throws BlackboardAccessException, IndexException, DataDictionaryException, NodeTransformerException, ProcessingException {
        block10: {
            IndexConnection indexConnection = null;
            try {
                String indexName = parameters.getIndexName();
                indexConnection = IndexManager.getInstance((String)indexName);
                if (indexConnection != null) {
                    AnyMap request = blackboard.getMetadata(requestId);
                    DQuery dQuery = null;
                    if (this.hasQueryString(parameters)) {
                        dQuery = this.createSimpleQuery(parameters, indexName);
                    } else if (this.hasAttributeQuery(parameters, indexName)) {
                        dQuery = this.createFieldedQuery(parameters, indexName);
                    }
                    dQuery = this.appendFilter(dQuery, parameters, indexName);
                    if (dQuery != null) {
                        dQuery = this.appendResultFields(dQuery, parameters, indexName);
                        dQuery = this.appendHiglightingFields(dQuery, parameters, indexName);
                        LuceneSearchResult result = indexConnection.doQuery(dQuery);
                        this.processResult(request, result);
                    } else {
                        request.put("records", (Any)request.getFactory().createAnySeq());
                        request.put("count", (Any)request.getFactory().createLongValue(0));
                    }
                    break block10;
                }
                throw new IndexException("Could not open connection to index " + indexName);
            }
            finally {
                if (indexConnection != null) {
                    IndexManager.releaseInstance((IndexConnection)indexConnection, (boolean)false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRecord(Blackboard blackboard, String id, String indexName, boolean allowDoublets) throws BlackboardAccessException, IndexException, IOException, ParserConfigurationException {
        block14: {
            this._lock.readLock().lock();
            IndexConnection indexConnection = null;
            try {
                if (!this.isIndexExists(indexName)) {
                    Set<String> set = this._indices;
                    synchronized (set) {
                        if (!this.isIndexExists(indexName)) {
                            this.createIndex(indexName);
                        }
                    }
                }
                if ((indexConnection = IndexManager.getInstance((String)indexName)) != null) {
                    HashMap<String, HashMap<String, Integer>> indexMap;
                    if (!allowDoublets && indexConnection.docExists(id)) {
                        indexConnection.deleteDocument(id);
                    }
                    if ((indexMap = this.getMappings().get(indexName)) != null) {
                        indexConnection.learnDocument(blackboard, id, (Map)indexMap.get("attributes"), (Map)indexMap.get("attachments"));
                        if (this._log.isInfoEnabled()) {
                            this._log.info((Object)("adding record " + id + " to Lucene index"));
                        }
                        break block14;
                    }
                    throw new IndexException("Could not find a mapping in file Mappings.xml for index " + indexName);
                }
                throw new IndexException("Could not open connection to index " + indexName);
            }
            finally {
                if (indexConnection != null) {
                    IndexManager.releaseInstance((IndexConnection)indexConnection, (boolean)false);
                }
                this._lock.readLock().unlock();
            }
        }
        if (RecordLifecycleLogHelper.isRecordStateLogEnabled()) {
            RecordLifecycleLogHelper.logRecordState((String)"Record added to lucene index", (String)id);
        }
    }

    @Override
    public void deleteRecord(String id, String indexName) throws IndexException {
        block7: {
            this._lock.readLock().lock();
            IndexConnection indexConnection = null;
            try {
                indexConnection = IndexManager.getInstance((String)indexName);
                if (indexConnection != null) {
                    indexConnection.deleteDocument(id);
                    if (this._log.isInfoEnabled()) {
                        this._log.info((Object)("deleted record " + id + " from Lucene index"));
                    }
                    break block7;
                }
                throw new IndexException("Could not open connection to index " + indexName);
            }
            finally {
                if (indexConnection != null) {
                    IndexManager.releaseInstance((IndexConnection)indexConnection, (boolean)false);
                }
                this._lock.readLock().unlock();
            }
        }
        if (RecordLifecycleLogHelper.isRecordStateLogEnabled()) {
            RecordLifecycleLogHelper.logRecordState((String)"Record deleted from lucene index", (String)id);
        }
    }

    @Override
    public boolean isIndexExists(String indexName) throws IndexException {
        return this._indices.contains(indexName);
    }

    @Override
    public void reorganizeIndex(String indexName) throws IndexException {
        this._lock.readLock().lock();
        try {
            this._indexAdmin.reorganize(indexName);
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createIndex(String indexName) throws IndexException {
        Set<String> set = this._indices;
        synchronized (set) {
            if (this.isIndexExists(indexName)) {
                throw new IndexException(String.format("Index [%s] already exists", indexName));
            }
            try {
                try {
                    this._lock.readLock().lock();
                    DataDictionaryController.addIndex((String)indexName);
                    DIndex dIndex = DataDictionaryController.getIndex((String)indexName);
                    this._indexAdmin.create(dIndex.getIndexStructure());
                    this._indices.add(dIndex.getName());
                }
                catch (DataDictionaryException e) {
                    throw new IndexException((Throwable)e);
                }
            }
            finally {
                this._lock.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteIndex(String indexName) throws IndexException {
        Set<String> set = this._indices;
        synchronized (set) {
            this._lock.readLock().lock();
            try {
                this._indexAdmin.delete(indexName);
                this._indices.remove(indexName);
            }
            finally {
                this._lock.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameIndex(String indexName, String newIndexName) throws IndexException {
        Set<String> set = this._indices;
        synchronized (set) {
            this._lock.readLock().lock();
            try {
                this._indexAdmin.rename(indexName, newIndexName);
                this._indices.remove(indexName);
                this._indices.add(newIndexName);
            }
            finally {
                this._lock.readLock().unlock();
            }
        }
    }

    @Override
    public Iterator<String> getIndexNames() {
        return this._indices.iterator();
    }

    @Override
    public void flushIndex(String indexName) throws IndexException {
        this._lock.readLock().lock();
        try {
            IndexWriterPool.flushIndexWriter(indexName);
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    @Override
    public void removeWriteLock(String indexName) throws IndexException {
        this._lock.readLock().lock();
        try {
            IndexConnection indexConnection = IndexManager.getInstance((String)indexName);
            if (indexConnection != null) {
                indexConnection.unlock();
            }
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    protected void loadMappings() {
        this._mappings = MappingsLoader.loadMappingsMap("Mappings.xml");
    }

    protected void unloadMappings() {
        if (this._mappings != null) {
            Collection<HashMap<String, HashMap<String, Integer>>> collection = this._mappings.values();
            for (HashMap<String, HashMap<String, Integer>> map : collection) {
                if (map == null) continue;
                Collection<HashMap<String, Integer>> values = map.values();
                for (HashMap<String, Integer> submap : values) {
                    if (submap == null) continue;
                    submap.clear();
                }
                map.clear();
            }
            this._mappings.clear();
            this._mappings = null;
        }
    }

    protected HashMap<String, HashMap<String, HashMap<String, Integer>>> getMappings() {
        return this._mappings;
    }

    private boolean hasQueryString(QueryParameterAccessor parameters) {
        String queryString = parameters.getQuery();
        return queryString != null && queryString.trim().length() != 0;
    }

    private boolean hasAttributeQuery(QueryParameterAccessor parameters, String indexName) throws BlackboardAccessException {
        if (parameters.hasQueryAttributes()) {
            DIndex dIndex = this._dataDictionary.getIndex(indexName);
            Iterator fieldIt = dIndex.getConfiguration().getDefaultConfig().getFields();
            while (fieldIt.hasNext()) {
                org.eclipse.smila.search.datadictionary.messages.ddconfig.DField field = (org.eclipse.smila.search.datadictionary.messages.ddconfig.DField)fieldIt.next();
                String attributeName = this.getAttributeName(indexName, field.getFieldNo());
                if (!parameters.hasQueryAttribute(attributeName)) continue;
                return true;
            }
        }
        return false;
    }

    private DQuery createSimpleQuery(QueryParameterAccessor parameters, String indexName) throws ProcessingException {
        String queryAttribute = parameters.getRequiredParameter("QueryAttribute");
        int fieldNo = this.getFieldNo(indexName, queryAttribute);
        org.eclipse.smila.search.datadictionary.messages.ddconfig.DField field = this._dataDictionary.getIndex(indexName).getConfiguration().getDefaultConfig().getField(fieldNo);
        DFieldConfig fieldConfig = field.getFieldConfig();
        DTextField textField = new DTextField();
        textField.setFieldNo(field.getFieldNo());
        textField.setType(fieldConfig.getType());
        textField.setText(parameters.getQuery());
        DQuery dQuery = this.createDQuery(parameters, indexName);
        dQuery.addField((DField)textField);
        return dQuery;
    }

    private DQuery createFieldedQuery(QueryParameterAccessor parameters, String indexName) throws ProcessingException {
        DQuery dQuery = this.createDQuery(parameters, indexName);
        DIndex dIndex = this._dataDictionary.getIndex(indexName);
        Iterator fieldIt = dIndex.getConfiguration().getDefaultConfig().getFields();
        Any rankingConfig = parameters.getRankingConfig();
        AnyMap rankingConfigMap = null;
        if (rankingConfig != null && rankingConfig.isMap() && !rankingConfig.isEmpty()) {
            // empty if block
        }
        while (fieldIt.hasNext()) {
            List values;
            org.eclipse.smila.search.datadictionary.messages.ddconfig.DField field = (org.eclipse.smila.search.datadictionary.messages.ddconfig.DField)fieldIt.next();
            String attributeName = this.getAttributeName(indexName, field.getFieldNo());
            if (!parameters.hasQueryAttribute(attributeName) || (values = parameters.getQueryAttributeValues(attributeName)) == null || values.isEmpty()) continue;
            DField searchField = this.createSearchField(field, values, parameters);
            this.setRankingParameters(searchField, rankingConfigMap, attributeName);
            dQuery.addField(searchField);
        }
        return dQuery;
    }

    private DQuery appendFilter(DQuery dQuery, QueryParameterAccessor parameters, String indexName) throws ProcessingException {
        if (parameters.hasFilters()) {
            DIndex dIndex = this._dataDictionary.getIndex(indexName);
            Iterator fieldIt = dIndex.getConfiguration().getDefaultConfig().getFields();
            while (fieldIt.hasNext()) {
                org.eclipse.smila.search.datadictionary.messages.ddconfig.DField field = (org.eclipse.smila.search.datadictionary.messages.ddconfig.DField)fieldIt.next();
                String attributeName = this.getAttributeName(indexName, field.getFieldNo());
                AnyMap filter = parameters.getFilter(attributeName);
                if (filter == null) continue;
                if (dQuery == null) {
                    dQuery = this.createDQuery(parameters, indexName);
                }
                DField searchField = this.createSearchFilter(field, filter);
                dQuery.addField(searchField);
            }
        }
        return dQuery;
    }

    private DQuery appendResultFields(DQuery dQuery, QueryParameterAccessor parameters, String indexName) {
        List resultAttributes = parameters.getResultAttributes();
        if (resultAttributes != null) {
            ArrayList<Integer> resultFields = new ArrayList<Integer>(resultAttributes.size());
            for (String attributeName : resultAttributes) {
                try {
                    resultFields.add(this.getFieldNo(indexName, attributeName));
                }
                catch (Exception e) {
                    if (!this._log.isWarnEnabled()) continue;
                    this._log.warn((Object)("error appending result fieldNo for attribute " + attributeName), (Throwable)e);
                }
            }
            if (!resultFields.isEmpty()) {
                dQuery.setResultFields(resultFields);
            }
        }
        return dQuery;
    }

    private DQuery appendHiglightingFields(DQuery dQuery, QueryParameterAccessor parameters, String indexName) throws BlackboardAccessException {
        ArrayList<Integer> highlightFields = new ArrayList<Integer>();
        List attributeNames = parameters.getHighlightAttributeNames();
        if (attributeNames != null) {
            for (String attributeName : attributeNames) {
                try {
                    highlightFields.add(this.getFieldNo(indexName, attributeName));
                }
                catch (Exception e) {
                    if (!this._log.isWarnEnabled()) continue;
                    this._log.warn((Object)("error appending highlight fieldNo for attribute " + attributeName), (Throwable)e);
                }
            }
        }
        if (!highlightFields.isEmpty()) {
            dQuery.setHighlightFields(highlightFields);
        }
        return dQuery;
    }

    private DQuery createDQuery(QueryParameterAccessor parameters, String indexName) {
        DQuery dQuery = new DQuery();
        dQuery.setIndexName(indexName);
        dQuery.setMaxHits(parameters.getMaxCount());
        dQuery.setStartHits(Integer.valueOf(parameters.getOffset()));
        dQuery.setMinSimilarity((int)(parameters.getThreshold() * 100.0));
        dQuery.setShowHitDistribution(true);
        dQuery.setTemplateSelectorName(parameters.getParameter("TemplateSelectorName", ""));
        return dQuery;
    }

    private DField createSearchField(org.eclipse.smila.search.datadictionary.messages.ddconfig.DField field, List<Value> values, QueryParameterAccessor parameters) throws ProcessingException {
        DTextField searchField;
        DFieldConfig fieldConfig = field.getFieldConfig();
        String type = fieldConfig.getType();
        if ("FTText".equals(type)) {
            searchField = this.createTextField(values);
        } else if ("FTDate".equals(type)) {
            searchField = this.createDateField(values);
        } else if ("FTNumber".equals(type)) {
            searchField = this.createNumberField(values);
        } else {
            throw new ProcessingException("unknown FieldConfig type " + type);
        }
        searchField.setFieldNo(field.getFieldNo());
        searchField.setType(fieldConfig.getType());
        return searchField;
    }

    private DTextField createTextField(List<Value> values) {
        DTextField textField = new DTextField();
        textField.setText(values.get(0).asString());
        return textField;
    }

    private void setRankingParameters(DField searchField, AnyMap ranking, String attributeName) {
        AnyMap attributeRanking;
        if (ranking != null && !ranking.isEmpty() && searchField instanceof DTextField && ((attributeRanking = ranking.containsKey((Object)attributeName) ? ranking.getMap(attributeName) : ranking).containsKey((Object)"Operator") || attributeRanking.containsKey((Object)"Tolerance"))) {
            String tolerance;
            DTextField textField = (DTextField)searchField;
            DTextFieldParameter parameter = new DTextFieldParameter();
            String operator = attributeRanking.getStringValue("Operator");
            if (operator != null) {
                parameter.setOperator(DTextFieldParameter.DOperator.getInstance(operator));
            }
            if ((tolerance = attributeRanking.getStringValue("Tolerance")) != null) {
                parameter.setTolerance(DTextFieldParameter.DTolerance.getInstance(tolerance));
            }
            textField.setParameter((ITFParameter)parameter);
        }
    }

    private DDateField createDateField(List<Value> values) throws ProcessingException {
        DDateField dateField = new DDateField();
        try {
            if (values.size() == 1) {
                Value value = values.get(0);
                Date date = this.getDate(value, new ValueFormatHelper());
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                dateField.setDateMin(calendar);
                dateField.setDateMax(calendar);
            }
        }
        catch (ParseException e) {
            throw new ProcessingException("error parsing date object " + values.get(0), (Throwable)e);
        }
        return dateField;
    }

    private DNumberField createNumberField(List<Value> values) {
        DNumberField numberField = new DNumberField();
        Long value = this.getLong(values.get(0));
        numberField.setMin(value);
        numberField.setMax(value);
        return numberField;
    }

    private DField createSearchFilter(org.eclipse.smila.search.datadictionary.messages.ddconfig.DField field, AnyMap filter) throws ProcessingException {
        DDateField searchField;
        DFieldConfig fieldConfig = field.getFieldConfig();
        String type = fieldConfig.getType();
        if ("FTText".equals(type)) {
            throw new ProcessingException("FTText does not support filter annotations");
        }
        if ("FTDate".equals(type)) {
            searchField = this.createDateFilter(filter);
        } else if ("FTNumber".equals(type)) {
            searchField = this.createNumberFilter(filter);
        } else {
            throw new ProcessingException("unknown FieldConfig type " + type);
        }
        searchField.setFieldNo(field.getFieldNo());
        searchField.setType(fieldConfig.getType());
        return searchField;
    }

    private DDateField createDateFilter(AnyMap filter) throws ProcessingException {
        Value maxValue;
        DDateField dateField = new DDateField();
        Value minValue = filter.getValue("atLeast");
        if (minValue == null) {
            minValue = filter.getValue("greaterThan");
        }
        if ((maxValue = filter.getValue("atMost")) == null) {
            maxValue = filter.getValue("lessThan");
        }
        if (minValue != null || maxValue != null) {
            ValueFormatHelper helper = new ValueFormatHelper();
            try {
                Calendar minCalendar = Calendar.getInstance();
                if (minValue != null) {
                    Date minDate = this.getDate(minValue, helper);
                    minCalendar.setTime(minDate);
                } else {
                    minCalendar.setTimeInMillis(0L);
                }
                Calendar maxCalendar = Calendar.getInstance();
                if (maxValue != null) {
                    Date maxDate = this.getDate(maxValue, helper);
                    maxCalendar.setTime(maxDate);
                } else {
                    maxCalendar.setTimeInMillis(Long.MAX_VALUE);
                }
                dateField.setDateMin(minCalendar);
                dateField.setDateMax(maxCalendar);
            }
            catch (ParseException e) {
                throw new ProcessingException("error parsing date object of filter " + filter, (Throwable)e);
            }
        } else {
            throw new ProcessingException("");
        }
        return dateField;
    }

    private DNumberField createNumberFilter(AnyMap filter) throws ProcessingException {
        long max;
        long min;
        Value maxValue;
        DNumberField numberField = new DNumberField();
        Value minValue = filter.getValue("atLeast");
        if (minValue == null) {
            minValue = filter.getValue("greaterThan");
        }
        if ((maxValue = filter.getValue("atMost")) == null) {
            maxValue = filter.getValue("lessThan");
        }
        if (minValue != null || maxValue != null) {
            min = Long.MIN_VALUE;
            if (minValue != null) {
                min = this.getLong(minValue);
            }
            max = Long.MAX_VALUE;
            if (maxValue != null) {
                max = this.getLong(maxValue);
            }
        } else {
            throw new ProcessingException("");
        }
        numberField.setMin(Long.valueOf(min));
        numberField.setMax(Long.valueOf(max));
        return numberField;
    }

    private void processResult(AnyMap request, LuceneSearchResult luceneResult) {
        int totalHits = 0;
        int indexSize = 0;
        AnySeq records = request.getFactory().createAnySeq();
        if (luceneResult != null && luceneResult.getResultList() != null) {
            int[] hitStatistic = this.getHitStatistics(luceneResult);
            totalHits = hitStatistic[0];
            indexSize = hitStatistic[1];
            for (Record record : luceneResult.getResultList()) {
                records.add((Object)record.getMetadata());
            }
        }
        request.put("count", (Any)request.getFactory().createLongValue(totalHits));
        request.put("indexSize", (Any)request.getFactory().createLongValue(indexSize));
        request.put("records", (Any)records);
    }

    private int[] getHitStatistics(LuceneSearchResult luceneResult) {
        int resultCount = 0;
        int docsIndexed = 0;
        Enumeration hitEnum = luceneResult.getHitDistribution().getHits();
        while (hitEnum.hasMoreElements()) {
            DHit hit = (DHit)hitEnum.nextElement();
            if (hit.getScore() > 0) {
                resultCount += hit.getHits();
            }
            docsIndexed += hit.getHits();
        }
        return new int[]{resultCount, docsIndexed};
    }

    private String getAttributeName(String indexName, int fieldNo) {
        HashMap<Integer, String> attachMap;
        HashMap<Integer, String> attMap;
        String attributeName = null;
        HashMap<String, HashMap<Integer, String>> indexMap = this._reverseMappings.get(indexName);
        if (indexMap != null && (attMap = indexMap.get("attributes")) != null && (attributeName = attMap.get(fieldNo)) == null && (attachMap = indexMap.get("attachments")) != null) {
            attributeName = attachMap.get(fieldNo);
        }
        return attributeName;
    }

    private int getFieldNo(String indexName, String name) throws ProcessingException {
        if (this.getMappings().get(indexName).get("attributes").containsKey(name)) {
            return this.getMappings().get(indexName).get("attributes").get(name);
        }
        if (this.getMappings().get(indexName).get("attachments").containsKey(name)) {
            return this.getMappings().get(indexName).get("attachments").get(name);
        }
        throw new ProcessingException("Could not find fieldNo for attribute/attachment named " + name);
    }

    private void loadReverseMappings() {
        if (this.getMappings() != null) {
            Iterator<String> indexNames = this.getMappings().keySet().iterator();
            while (indexNames.hasNext()) {
                HashMap reverseMap = new HashMap();
                String indexName = indexNames.next();
                HashMap<String, HashMap<String, Integer>> indexMap = this.getMappings().get(indexName);
                Iterator<String> mapNames = indexMap.keySet().iterator();
                while (mapNames.hasNext()) {
                    HashMap<Integer, String> reverseAttMap = new HashMap<Integer, String>();
                    String mapName = mapNames.next();
                    HashMap<String, Integer> attMap = indexMap.get(mapName);
                    for (String attName : attMap.keySet()) {
                        Integer fieldNo = attMap.get(attName);
                        reverseAttMap.put(fieldNo, attName);
                    }
                    reverseMap.put(mapName, reverseAttMap);
                }
                this._reverseMappings.put(indexName, reverseMap);
            }
        }
    }

    private void unloadReverseMappings() {
        if (this._reverseMappings != null) {
            Collection<HashMap<String, HashMap<Integer, String>>> collection = this._reverseMappings.values();
            for (HashMap<String, HashMap<Integer, String>> map : collection) {
                if (map == null) continue;
                Collection<HashMap<Integer, String>> values = map.values();
                for (HashMap<Integer, String> submap : values) {
                    if (submap == null) continue;
                    submap.clear();
                }
                map.clear();
            }
            this._reverseMappings.clear();
            this._reverseMappings = null;
        }
    }

    private Date parseDate(String dateString, ValueFormatHelper helper) throws ParseException {
        try {
            return helper.parseDateTime(dateString);
        }
        catch (ParseException parseException) {
            try {
                return helper.parseDate(dateString);
            }
            catch (ParseException parseException2) {
                try {
                    return new SimpleDateFormat("dd.MM.yyyy HH:mm:ss").parse(dateString);
                }
                catch (ParseException parseException3) {
                    return new SimpleDateFormat("dd.MM.yyyy").parse(dateString);
                }
            }
        }
    }

    private Date getDate(Value value, ValueFormatHelper helper) throws ParseException {
        if (value.isDate()) {
            return value.asDate();
        }
        if (value.isDateTime()) {
            return value.asDateTime();
        }
        return this.parseDate(value.asString(), helper);
    }

    private Long getLong(Value value) {
        if (value.isLong()) {
            return value.asLong();
        }
        if (value.isDouble()) {
            return value.asDouble().longValue();
        }
        return Long.parseLong(value.asString());
    }
}

