/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.lucene.index.access;

import org.apache.lucene.index.IndexReader;
import org.eclipse.smila.search.index.IndexException;
import org.eclipse.smila.search.lucene.index.access.ISynchronizedCondition;
import org.eclipse.smila.search.lucene.index.access.ISynchronizedOperation;
import org.eclipse.smila.search.lucene.index.access.SynchronizedAbstractExecutor;

public class SynchronizedIndexReaderExecutor<ReturnedType>
extends SynchronizedAbstractExecutor<IndexReader, ReturnedType> {
    private final String _storage;
    private final IndexReaderCondition _condition;

    public SynchronizedIndexReaderExecutor(Object monitored, String storage) {
        super(monitored);
        this._storage = storage;
        this._condition = new IndexReaderCondition();
    }

    @Override
    protected void close(IndexReader object) throws IndexException {
        try {
            object.close();
        }
        catch (Throwable e) {
            throw new IndexException("Unable to close IndexReader", e);
        }
    }

    @Override
    public ReturnedType execute(ISynchronizedOperation<IndexReader, ReturnedType> operation) throws IndexException {
        return this.execute(this._condition, operation);
    }

    private class IndexReaderCondition
    implements ISynchronizedCondition<IndexReader> {
        private IndexReaderCondition() {
        }

        @Override
        public IndexReader initialize() throws IndexException {
            try {
                return IndexReader.open((String)SynchronizedIndexReaderExecutor.this._storage);
            }
            catch (Exception e) {
                throw new IndexException("unable to read index", (Throwable)e);
            }
        }
    }
}

