/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.lucene.messages.advsearch;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import org.eclipse.smila.search.lucene.messages.advsearch.DDateField;
import org.eclipse.smila.search.utils.advsearch.AdvSearchException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

abstract class DDateFieldCodec {
    private DDateFieldCodec() {
    }

    public static Element encode(DDateField dDateField, Element parent) throws AdvSearchException {
        Document doc = parent.getOwnerDocument();
        Element me = (Element)parent.appendChild(doc.createElementNS("http://www.anyfinder.de/AdvancedSearch", "Field"));
        me.setAttribute("xsi:type", "DateField");
        me.setAttribute("FieldNo", String.valueOf(dDateField.getFieldNo()));
        Element child = null;
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        Date cal = null;
        cal = dDateField.getMin();
        child = (Element)me.appendChild(doc.createElementNS("http://www.anyfinder.de/AdvancedSearch", "Min"));
        if (cal != null) {
            child.appendChild(doc.createTextNode(formatter.format(cal)));
        } else {
            child.setAttribute("xsi:nil", "true");
        }
        cal = dDateField.getMax();
        child = (Element)me.appendChild(doc.createElementNS("http://www.anyfinder.de/AdvancedSearch", "Max"));
        if (cal != null) {
            child.appendChild(doc.createTextNode(formatter.format(cal)));
        } else {
            child.setAttribute("xsi:nil", "true");
        }
        return me;
    }

    public static DDateField decode(Element eDateField) throws AdvSearchException {
        try {
            DDateField dDateField = new DDateField();
            dDateField.setFieldNo(Integer.parseInt(eDateField.getAttribute("FieldNo")));
            GregorianCalendar c = new GregorianCalendar();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            NodeList nl = eDateField.getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                String date;
                boolean isNil;
                NamedNodeMap attrs = nl.item(i).getAttributes();
                Node nilItem = attrs == null ? null : attrs.getNamedItem("xsi:nil");
                String xsiNil = nilItem == null ? null : nilItem.getNodeValue();
                boolean bl = isNil = xsiNil != null && (xsiNil.toLowerCase().equals("true") || xsiNil.equals("1"));
                if ("Min".equals(nl.item(i).getLocalName()) && !isNil && nl.item(i).hasChildNodes()) {
                    date = ((Text)nl.item(i).getFirstChild()).getData();
                    try {
                        c.setTime(sdf.parse(date));
                    }
                    catch (ParseException parseException) {
                        throw new AdvSearchException("Error in DateField: Illegal date format '" + date + "'.");
                    }
                    dDateField.setMin(c.getTime());
                }
                if ("Max".equals(nl.item(i).getLocalName()) && !isNil && nl.item(i).hasChildNodes()) {
                    date = ((Text)nl.item(i).getFirstChild()).getData();
                    try {
                        c.setTime(sdf.parse(date));
                    }
                    catch (ParseException parseException) {
                        throw new AdvSearchException("Error in DateField: Illegal date format '" + date + "'.");
                    }
                    dDateField.setMax(c.getTime());
                }
                ++i;
            }
            return dDateField;
        }
        catch (Exception e) {
            throw new AdvSearchException("Error in attributes to DateField!", (Throwable)e);
        }
    }
}

