/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.lucene.messages.indexstructure;

import org.eclipse.smila.search.lucene.messages.indexstructure.DAnalyzer;
import org.eclipse.smila.search.utils.indexstructure.ISException;
import org.eclipse.smila.search.utils.param.ParameterException;
import org.eclipse.smila.search.utils.param.set.DParameterSet;
import org.eclipse.smila.search.utils.param.set.DParameterSetCodec;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class DAnalyzerCodec {
    private DAnalyzerCodec() {
    }

    public static Element encode(DAnalyzer dAnalyzer, Element parent) throws ISException {
        if (parent == null) {
            throw new ISException("parameter must not be null [parent]");
        }
        if (dAnalyzer == null) {
            throw new ISException("parameter must not be null [dAnalyzer]");
        }
        Document doc = parent.getOwnerDocument();
        Element el = doc.createElement("Analyzer");
        el.setAttribute("ClassName", dAnalyzer.getClassName());
        if (dAnalyzer.getParameterSet() != null) {
            try {
                DParameterSetCodec.encode((DParameterSet)dAnalyzer.getParameterSet(), (Element)el);
            }
            catch (ParameterException e) {
                throw new ISException("unable to encode parameter set for analyzer '" + dAnalyzer.getClassName() + "'", (Throwable)e);
            }
        }
        parent.appendChild(el);
        return el;
    }

    public static DAnalyzer decode(Element element) throws ISException {
        if (element == null) {
            throw new ISException("parameter must not be null [element]");
        }
        DAnalyzer dAnalyzer = new DAnalyzer();
        dAnalyzer.setClassName(element.getAttribute("ClassName"));
        NodeList nl = element.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Element el;
            if (nl.item(i) instanceof Element && "ParameterSet".equals((el = (Element)nl.item(i)).getLocalName())) {
                try {
                    dAnalyzer.setParameterSet(DParameterSetCodec.decode((Element)((Element)nl.item(i))));
                }
                catch (ParameterException e) {
                    throw new ISException("unable to decode parameter set for analyzer '" + dAnalyzer.getClassName() + "'", (Throwable)e);
                }
            }
            ++i;
        }
        return dAnalyzer;
    }
}

