/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.datadictionary;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.smila.search.datadictionary.DataDictionaryException;
import org.eclipse.smila.search.datadictionary.messages.datadictionary.DConnection;
import org.eclipse.smila.search.datadictionary.messages.datadictionary.DDException;
import org.w3c.dom.Element;

public abstract class DataDictionaryAccess {
    public static final String EXTENSION_POINT_NAME_DATA_DICTIONARY_ACCESS = "org.eclipse.smila.search.datadictionary.access";
    private static DataDictionaryAccess[] s_cachedDataDictionaryAccess;

    public static DataDictionaryAccess getInstance() {
        DataDictionaryAccess[] types;
        block5: {
            Log log = LogFactory.getLog(DataDictionaryAccess.class);
            try {
                types = DataDictionaryAccess.getTypes();
                if (types.length == 1) break block5;
                if (log.isWarnEnabled()) {
                    log.warn((Object)("invalid data dictionary access count [" + types.length + "]"));
                }
                return null;
            }
            catch (DataDictionaryException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)e);
                }
                return null;
            }
        }
        return types[0];
    }

    public static DataDictionaryAccess[] getTypes() throws DataDictionaryException {
        if (s_cachedDataDictionaryAccess != null) {
            return s_cachedDataDictionaryAccess;
        }
        Log log = LogFactory.getLog(DataDictionaryAccess.class);
        ArrayList<DataDictionaryAccess> found = new ArrayList<DataDictionaryAccess>();
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT_NAME_DATA_DICTIONARY_ACCESS).getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] configElements = extension.getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                IConfigurationElement configurationElement = configElements[j];
                DataDictionaryAccess clazz = null;
                try {
                    Object obj = configurationElement.createExecutableExtension("Clazz");
                    clazz = (DataDictionaryAccess)obj;
                }
                catch (Exception exception) {
                    if (log.isErrorEnabled()) {
                        if (configurationElement != null) {
                            log.error((Object)"Failed to instantiate data dictionary access");
                        } else {
                            log.error((Object)"Unknown!");
                        }
                    }
                    throw new DataDictionaryException("unable to load data dictionary access", exception);
                }
                if (clazz != null) {
                    found.add(clazz);
                }
                ++j;
            }
            ++i;
        }
        s_cachedDataDictionaryAccess = found.toArray(new DataDictionaryAccess[0]);
        return s_cachedDataDictionaryAccess;
    }

    public static String parseType(IConfigurationElement configurationElement, int ordinal) {
        if (!configurationElement.getName().equals("DataDictionaryAccess")) {
            return null;
        }
        Log log = LogFactory.getLog(DataDictionaryAccess.class);
        try {
            String name = configurationElement.getAttribute("Clazz");
            if (name == null) {
                name = "[missing attribute name]";
            }
            return name;
        }
        catch (Exception e) {
            String name = configurationElement.getAttribute("Clazz");
            if (name == null) {
                name = "[missing attribute name]";
            }
            String msg = "Failed to load StrategyType named " + name + " in " + configurationElement.getDeclaringExtension().getNamespaceIdentifier();
            if (log.isErrorEnabled()) {
                log.error((Object)msg, (Throwable)e);
            }
            return null;
        }
    }

    public abstract DConnection decodeConnection(Element var1) throws DDException;

    public abstract Element encodeConnection(DConnection var1, Element var2) throws DDException;
}

