/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.workermanager;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.smila.clusterconfig.ClusterConfigService;

public class ScaleUpControl {
    private final Map<String, Integer> _taskCounter = new HashMap<String, Integer>();
    private final Map<String, Integer> _scaleUpLimit = new HashMap<String, Integer>();

    public ScaleUpControl() {
    }

    public ScaleUpControl(ClusterConfigService clusterService) {
        for (String worker : clusterService.getWorkersWithScaleUp()) {
            Long workerScaleUp = clusterService.getWorkerScaleUp(worker);
            this.setScaleUpLimit(worker, workerScaleUp);
        }
    }

    public boolean canGetTask(String workerName, boolean isRunAlways) {
        int current = this.getTaskCounter(workerName);
        if (isRunAlways) {
            return current < 1;
        }
        int max = this.getScaleUpLimit(workerName);
        if (max > 0) {
            return current < max;
        }
        return max < 0;
    }

    public void incTaskCounter(String worker) {
        Integer taskCount = this._taskCounter.get(worker);
        if (taskCount == null) {
            this._taskCounter.put(worker, 1);
        } else {
            taskCount = taskCount + 1;
            this._taskCounter.put(worker, (int)taskCount);
        }
    }

    public void decTaskCounter(String worker) {
        Integer taskCount = this._taskCounter.get(worker);
        if (taskCount != null) {
            taskCount = taskCount - 1;
            this._taskCounter.put(worker, (int)taskCount);
        }
    }

    public int getTaskCounter(String worker) {
        Integer current = this._taskCounter.get(worker);
        if (current == null) {
            current = 0;
            this._taskCounter.put(worker, current);
        }
        return current;
    }

    public int getScaleUpLimit(String worker) {
        Integer limit = this._scaleUpLimit.get(worker);
        if (limit == null) {
            limit = 1;
            this._scaleUpLimit.put(worker, limit);
        }
        return limit;
    }

    public void setScaleUpLimit(String worker, Long scaleUp) {
        this._scaleUpLimit.put(worker, scaleUp.intValue());
    }
}

