/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.workermanager.keepalive;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.taskmanager.BadParameterTaskmanagerException;
import org.eclipse.smila.taskmanager.Task;
import org.eclipse.smila.taskmanager.TaskManager;
import org.eclipse.smila.taskmanager.TaskmanagerException;
import org.eclipse.smila.workermanager.TaskKeepAliveListener;
import org.eclipse.smila.workermanager.keepalive.DelayedTask;

public class TaskKeepAlive
implements Runnable {
    public static final long DEFAULT_SCHEDULE_MILLIS = 2000L;
    public static final long TIME_OUT_DEFAULT_SECONDS = 10L;
    private final DelayQueue<DelayedTask> _delayQueue = new DelayQueue();
    private final TaskManager _taskManager;
    private final Log _log = LogFactory.getLog(this.getClass());
    private final long _timeout;
    private final CopyOnWriteArrayList<TaskKeepAliveListener> _keepAliveListeners = new CopyOnWriteArrayList();

    public TaskKeepAlive(TaskManager taskManager) {
        this._taskManager = taskManager;
        this._timeout = 10L;
    }

    public TaskKeepAlive(TaskManager taskManager, long timeout) {
        this._taskManager = taskManager;
        this._timeout = timeout;
    }

    public synchronized void removeTask(Task task) {
        Iterator<DelayedTask> iter = this._delayQueue.iterator();
        while (iter.hasNext()) {
            DelayedTask delayedTask = iter.next();
            if (!delayedTask.getTask().getTaskId().equals(task.getTaskId())) continue;
            iter.remove();
            return;
        }
    }

    public void addTask(Task task) {
        this._delayQueue.offer(new DelayedTask(task, this._timeout, TimeUnit.SECONDS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        DelayedTask delayedTask;
        do {
            BadParameterTaskmanagerException ex2;
            block12: {
                TaskKeepAlive taskKeepAlive = this;
                synchronized (taskKeepAlive) {
                    delayedTask = (DelayedTask)this._delayQueue.poll();
                    if (delayedTask != null) {
                        this.addTask(delayedTask.getTask());
                    }
                }
                if (delayedTask == null) continue;
                try {
                    this.keepAlive(delayedTask);
                    continue;
                }
                catch (BadParameterTaskmanagerException ex2) {
                    if (ex2.getCauseCode() != BadParameterTaskmanagerException.Cause.taskId && ex2.getCauseCode() != BadParameterTaskmanagerException.Cause.workerName) break block12;
                    if (this._log.isInfoEnabled()) {
                        this._log.info((Object)("Task '" + delayedTask.getTask().getTaskId() + "' seems to be gone, processing should be canceled."), (Throwable)ex2);
                    }
                    this.removeTask(delayedTask.getTask());
                }
                for (TaskKeepAliveListener listener : this._keepAliveListeners) {
                    try {
                        listener.removedTask(delayedTask.getTask());
                    }
                    catch (Throwable t) {
                        this._log.error((Object)"Cannot inform listener about removal of task.", t);
                    }
                }
                continue;
                catch (TaskmanagerException ex3) {
                    this._log.error((Object)"Error while trying to keep alive task.", (Throwable)ex3);
                    continue;
                }
            }
            this._log.error((Object)"Error while trying to keep alive task.", (Throwable)ex2);
        } while (delayedTask != null);
    }

    private void keepAlive(DelayedTask delayedTask) throws TaskmanagerException {
        Task taskToKeepAlive = delayedTask.getTask();
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("Keeping task '" + taskToKeepAlive.getTaskId() + "' alive."));
        }
        this._taskManager.keepAlive(taskToKeepAlive.getWorkerName(), taskToKeepAlive.getTaskId());
    }

    public void addKeepAliveFailureListener(TaskKeepAliveListener keepAliveListener) {
        this._keepAliveListeners.add(keepAliveListener);
    }

    public void addKeepAliveFailureListeners(Collection<TaskKeepAliveListener> keepAliveListeners) {
        this._keepAliveListeners.addAll(keepAliveListeners);
    }

    public void removeKeepAliveFailureListener(TaskKeepAliveListener keepAliveListener) {
        this._keepAliveListeners.remove(keepAliveListener);
    }

    public Collection<TaskKeepAliveListener> getKeepAliveFailureListeners() {
        return this._keepAliveListeners;
    }
}

