/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.clusterconfig.simple;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.clusterconfig.ClusterConfigService;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.ipc.IpcSerializationUtils;
import org.eclipse.smila.utils.config.ConfigUtils;
import org.osgi.service.component.ComponentContext;

public class SimpleClusterConfigService
implements ClusterConfigService {
    public static final String BUNDLE_ID = "org.eclipse.smila.clusterconfig.simple";
    public static final long DEFAULT_ZK_GC_INTERVAL = 60L;
    public static final long DEFAULT_FAILSAFETY_LEVEL = 0L;
    public static final long DEFAULT_MAX_SCALE_UP = -1L;
    public static final long DEFAULT_MAX_RETRIES = 10L;
    public static final long DEFAULT_TIME_TO_LIVE = 300L;
    private static final String CONFIG_FILE_NAME = "clusterconfig.json";
    private static final String KEY_CLUSTER_NODES = "clusterNodes";
    private static final String KEY_LOCAL_HOST_NAME = "localHost";
    private static final String KEY_ZK_GC_INTERVAL = "zkGcInterval";
    private static final String KEY_FAILSAFETY_LEVEL = "failsafetyLevel";
    private static final String KEY_MAX_SCALE_UP = "maxScaleUp";
    private static final String KEY_WORKERS = "workers";
    private static final String KEY_SERVICES = "services";
    private static final String KEY_HTTP_PORT = "httpPort";
    private static final String KEY_TASKMANAGER = "taskmanager";
    private static final String KEY_TIME_TO_LIVE = "timeToLive";
    private static final String KEY_MAX_RETRIES = "maxRetries";
    private final Log _log = LogFactory.getLog(this.getClass());
    private AnyMap _properties = DataFactory.DEFAULT.createAnyMap();
    private boolean _isConfigured;

    protected void activate(ComponentContext context) {
        try {
            this.readConfiguration();
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)"successfully activated");
            }
        }
        catch (Throwable e) {
            if (this._log.isErrorEnabled()) {
                this._log.error((Object)"Error while activating org.eclipse.smila.clusterconfig.simple", e);
            }
            throw new RuntimeException("Error while activating org.eclipse.smila.clusterconfig.simple", e);
        }
    }

    protected void deactivate(ComponentContext context) {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)"deactivate");
        }
    }

    public List<String> getClusterNodes() {
        AnySeq clusterNodes;
        if (this._properties.containsKey((Object)KEY_CLUSTER_NODES)) {
            if (((Any)this._properties.get((Object)KEY_CLUSTER_NODES)).isSeq()) {
                clusterNodes = this._properties.getSeq(KEY_CLUSTER_NODES);
            } else {
                clusterNodes = DataFactory.DEFAULT.createAnySeq();
                clusterNodes.add(this._properties.getStringValue(KEY_CLUSTER_NODES));
            }
        } else {
            clusterNodes = DataFactory.DEFAULT.createAnySeq();
            clusterNodes.add(this.getLocalHost());
            this._properties.put(KEY_CLUSTER_NODES, (Any)clusterNodes);
        }
        return clusterNodes.asStrings();
    }

    public String getLocalHost() {
        String localHost;
        if (this._properties.containsKey((Object)KEY_LOCAL_HOST_NAME)) {
            localHost = this._properties.getStringValue(KEY_LOCAL_HOST_NAME);
        } else {
            String hostName = "localhost";
            try {
                InetAddress address = InetAddress.getLocalHost();
                hostName = address.getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                this._log.warn((Object)("Could not retrieve local host name. Using " + hostName));
            }
            localHost = hostName;
            this._properties.put(KEY_LOCAL_HOST_NAME, localHost);
        }
        return localHost;
    }

    public long getZkGcInterval() {
        return this.getLongPropertyOrSetDefault(KEY_ZK_GC_INTERVAL, 60L);
    }

    public long getFailSafetyLevel() {
        return this.getLongPropertyOrSetDefault(KEY_FAILSAFETY_LEVEL, 0L);
    }

    public boolean isConfigured() {
        return this._isConfigured;
    }

    public long getMaxScaleUp() {
        AnyMap taskManagerSection;
        if (this._properties.containsKey((Object)KEY_TASKMANAGER)) {
            taskManagerSection = this._properties.getMap(KEY_TASKMANAGER);
        } else {
            taskManagerSection = DataFactory.DEFAULT.createAnyMap();
            this._properties.put(KEY_TASKMANAGER, (Any)taskManagerSection);
        }
        return this.getLongPropertyOrSetDefault(taskManagerSection, KEY_MAX_SCALE_UP, -1L);
    }

    public long getWorkerScaleUp(String worker) {
        AnyMap workerProperties;
        AnyMap workersSection;
        if (this._properties.containsKey((Object)KEY_WORKERS)) {
            workersSection = this._properties.getMap(KEY_WORKERS);
        } else {
            workersSection = DataFactory.DEFAULT.createAnyMap();
            this._properties.put(KEY_WORKERS, (Any)workersSection);
        }
        if (workersSection.containsKey((Object)worker)) {
            workerProperties = workersSection.getMap(worker);
        } else {
            workerProperties = DataFactory.DEFAULT.createAnyMap();
            workersSection.put(worker, (Any)workerProperties);
        }
        return this.getLongPropertyOrSetDefault(workerProperties, KEY_MAX_SCALE_UP, -1L);
    }

    public Collection<String> getWorkersWithScaleUp() {
        ArrayList<String> workers = new ArrayList<String>();
        if (this._properties.containsKey((Object)KEY_WORKERS)) {
            for (Map.Entry entry : this._properties.getMap(KEY_WORKERS).entrySet()) {
                AnyMap workerMap = (AnyMap)entry.getValue();
                if (this.getLongPropertyOrSetDefault(workerMap, KEY_MAX_SCALE_UP, -1L) < 0L) continue;
                workers.add((String)entry.getKey());
            }
        }
        return workers;
    }

    public int getHttpPort(String serviceName) {
        AnyMap serviceMap;
        AnyMap servicesSectionMap = this._properties.getMap(KEY_SERVICES);
        if (servicesSectionMap != null && servicesSectionMap.containsKey((Object)serviceName) && (serviceMap = servicesSectionMap.getMap(serviceName)).containsKey((Object)KEY_HTTP_PORT)) {
            return serviceMap.getLongValue(KEY_HTTP_PORT).intValue();
        }
        if (this._log.isInfoEnabled()) {
            this._log.info((Object)("HTTP port for service '" + serviceName + "' not defined."));
        }
        return -1;
    }

    public long getMaxRetries() {
        AnyMap taskManagerSection;
        if (this._properties.containsKey((Object)KEY_TASKMANAGER)) {
            taskManagerSection = this._properties.getMap(KEY_TASKMANAGER);
        } else {
            taskManagerSection = DataFactory.DEFAULT.createAnyMap();
            this._properties.put(KEY_TASKMANAGER, (Any)taskManagerSection);
        }
        return this.getLongPropertyOrSetDefault(taskManagerSection, KEY_MAX_RETRIES, 10L);
    }

    public long getTimeToLive() {
        AnyMap taskManagerSection;
        if (this._properties.containsKey((Object)KEY_TASKMANAGER)) {
            taskManagerSection = this._properties.getMap(KEY_TASKMANAGER);
        } else {
            taskManagerSection = DataFactory.DEFAULT.createAnyMap();
            this._properties.put(KEY_TASKMANAGER, (Any)taskManagerSection);
        }
        return this.getLongPropertyOrSetDefault(taskManagerSection, KEY_TIME_TO_LIVE, 300L);
    }

    protected long getLongPropertyOrSetDefault(String key, long defaultValueToSet) {
        return this.getLongPropertyOrSetDefault(this._properties, key, defaultValueToSet);
    }

    protected long getLongPropertyOrSetDefault(AnyMap properties, String key, long defaultValueToSet) {
        long zkGcInterval;
        if (properties.containsKey((Object)key)) {
            zkGcInterval = properties.getLongValue(key);
        } else {
            zkGcInterval = defaultValueToSet;
            properties.put(key, (Number)zkGcInterval);
        }
        return zkGcInterval;
    }

    protected void readConfiguration() throws IOException {
        IpcSerializationUtils serializationUtils = new IpcSerializationUtils();
        InputStream configurationFileStream = null;
        try {
            try {
                configurationFileStream = ConfigUtils.getConfigStream((String)BUNDLE_ID, (String)CONFIG_FILE_NAME);
                this._properties = (AnyMap)serializationUtils.jsonStream2any(configurationFileStream);
                this._isConfigured = true;
            }
            catch (IOException ex) {
                throw new IOException("Could not read configuration property file clusterconfig.json: " + ex.toString());
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(configurationFileStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)configurationFileStream);
    }
}

