/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.store;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.compiler.wsdl.Definition4BPEL;

public class DocumentRegistry {
    private static final Log __log = LogFactory.getLog(DocumentRegistry.class);
    private final ArrayList<Definition4BPEL> _definitions = new ArrayList();

    public Definition4BPEL getDefinition(QName qName) {
        for (Definition4BPEL definition4BPEL : this._definitions) {
            if (!definition4BPEL.getTargetNamespace().equals(qName.getNamespaceURI()) || definition4BPEL.getService(qName) == null) continue;
            return definition4BPEL;
        }
        return null;
    }

    public Definition4BPEL getDefinitionForPortType(QName qName) {
        for (Definition4BPEL definition4BPEL : this._definitions) {
            if (!definition4BPEL.getTargetNamespace().equals(qName.getNamespaceURI()) || definition4BPEL.getPortType(qName) == null) continue;
            return definition4BPEL;
        }
        return null;
    }

    public Definition4BPEL[] getDefinitions() {
        return this._definitions.toArray(new Definition4BPEL[this._definitions.size()]);
    }

    public void addDefinition(Definition4BPEL definition4BPEL) throws CompilationException {
        if (definition4BPEL == null) {
            throw new NullPointerException("def=null");
        }
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("addDefinition(" + definition4BPEL.getTargetNamespace() + " from " + definition4BPEL.getDocumentBaseURI() + ")"));
        }
        this._definitions.add(definition4BPEL);
    }
}

