/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.framework.crawler.web.filter;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.connectivity.framework.crawler.web.configuration.Configuration;
import org.eclipse.smila.connectivity.framework.crawler.web.filter.IFilter;
import org.eclipse.smila.connectivity.framework.crawler.web.messages.FilterType;

public class FilterFactory {
    private static final Log LOG = LogFactory.getLog(FilterFactory.class);
    private final Configuration _conf;

    public FilterFactory(Configuration conf) {
        this._conf = conf;
    }

    public IFilter<?> getFilter(FilterType filterType) {
        String filterClassName = null;
        IFilter filter = null;
        try {
            if (filterType.equals((Object)FilterType.BEGINNING_PATH)) {
                filterClassName = this._conf.get("filter.beginningpath.class");
            } else if (filterType.equals((Object)FilterType.REG_EXP)) {
                filterClassName = this._conf.get("filter.regexp.class");
            } else if (filterType.equals((Object)FilterType.CONTENT_TYPE)) {
                filterClassName = this._conf.get("filter.contenttype.class");
            } else if (filterType.equals((Object)FilterType.CRAWL_SCOPE)) {
                filterClassName = this._conf.get("filter.crawlscope.class");
            } else if (filterType.equals((Object)FilterType.HTML_META_TAG)) {
                filterClassName = this._conf.get("filter.htmlmetatag.class");
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Using URL filter: " + filterClassName));
            }
            Class<?> filterClass = Class.forName(filterClassName);
            filter = (IFilter)filterClass.newInstance();
            this._conf.setObject(filterType.name(), filter);
        }
        catch (Exception exception) {
            LOG.error((Object)("Error creating filter: " + filterClassName));
            throw new RuntimeException("Couldn't create " + filterClassName, exception);
        }
        return filter;
    }
}

