/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.framework.crawler.web.filter;

import java.util.Calendar;
import java.util.Date;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.httpclient.protocol.Protocol;
import org.eclipse.smila.connectivity.framework.crawler.web.filter.WorkTypeFilter;
import org.eclipse.smila.connectivity.framework.crawler.web.messages.WebSite;
import org.eclipse.smila.connectivity.framework.crawler.web.parse.Outlink;

public abstract class UrlFilter
extends WorkTypeFilter<Outlink> {
    private static final int SECONDS_IN_MINUTE = 60;
    private String _value;
    private WebSite.Filters.Filter.Refinements _refinements;

    public String getValue() {
        return this._value;
    }

    public void setValue(String value) {
        this._value = value;
    }

    public WebSite.Filters.Filter.Refinements getRefinements() {
        return this._refinements;
    }

    public void setRefinements(WebSite.Filters.Filter.Refinements refinements) {
        this._refinements = refinements;
    }

    public boolean isEnabled(Outlink link) {
        if (this._refinements != null) {
            int from = 0;
            int to = 0;
            WebSite.Filters.Filter.Refinements.TimeOfDay timeOfDay = this._refinements.getTimeOfDay();
            if (timeOfDay == null) {
                return false;
            }
            XMLGregorianCalendar cl = timeOfDay.getFrom();
            from = cl.getHour() * 60 * 60 + cl.getMinute() * 60 + cl.getSecond();
            cl = timeOfDay.getTo();
            to = cl.getHour() * 60 * 60 + cl.getMinute() * 60 + cl.getSecond();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            int now = calendar.get(11) * 60 * 60 + calendar.get(12) * 60 + calendar.get(13);
            if (now < from || now > to) {
                return false;
            }
            WebSite.Filters.Filter.Refinements.Port port = this._refinements.getPort();
            if (port != null) {
                int iPort = this._refinements.getPort().getNumber().intValue();
                int linkPort = link.getUrl().getPort();
                if (linkPort == -1) {
                    linkPort = Protocol.getProtocol((String)link.getUrl().getProtocol()).getDefaultPort();
                }
                if (iPort > 0 && linkPort != iPort) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }
}

