/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.framework.crawler.web.http;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.contrib.ssl.AuthSSLProtocolSocketFactory;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.connectivity.framework.crawler.web.auth.Rfc2617Authentication;
import org.eclipse.smila.connectivity.framework.crawler.web.auth.SslCertificateAuthentication;
import org.eclipse.smila.connectivity.framework.crawler.web.configuration.Configuration;
import org.eclipse.smila.connectivity.framework.crawler.web.filter.FilterProcessor;
import org.eclipse.smila.connectivity.framework.crawler.web.http.HttpBase;
import org.eclipse.smila.connectivity.framework.crawler.web.http.HttpResponse;
import org.eclipse.smila.connectivity.framework.crawler.web.http.Response;

public class Http
extends HttpBase {
    private static MultiThreadedHttpConnectionManager s_connectionManager = new MultiThreadedHttpConnectionManager();
    private static final Log LOG = LogFactory.getLog(Http.class);
    private static final String COLON = ":";
    private static final String SEMICOLON = ";";
    private static HttpClient s_client = new HttpClient((HttpConnectionManager)s_connectionManager);
    private Protocol _https;

    static synchronized HttpClient getClient() {
        return s_client;
    }

    @Override
    public void setConf(Configuration conf) {
        super.setConf(conf);
        this.configureClient();
    }

    @Override
    protected Response getResponse(String urlString) throws IOException {
        return this.getResponse(urlString, null);
    }

    @Override
    protected Response getResponse(String urlString, FilterProcessor filterProcessor) throws IOException {
        return new HttpResponse(this, urlString, filterProcessor);
    }

    private void configureClient() {
        String[] webSiteHeaders;
        HttpConnectionManagerParams params = s_connectionManager.getParams();
        if (this._timeout != 0) {
            params.setConnectionTimeout(this._timeout);
            params.setSoTimeout(this._timeout);
        } else {
            params.setConnectionTimeout(this._connectTimeout);
            params.setSoTimeout(this._readTimeout);
        }
        params.setSendBufferSize(8192);
        params.setReceiveBufferSize(8192);
        HostConfiguration hostConf = s_client.getHostConfiguration();
        ArrayList<Header> headers = new ArrayList<Header>();
        headers.add(new Header("Accept-Language", "en-us,en-gb,en;q=0.7,*;q=0.3"));
        headers.add(new Header("Accept-Charset", "utf-8,ISO-8859-1;q=0.7,*;q=0.7"));
        headers.add(new Header("Accept", "text/html,application/xml;q=0.9,application/xhtml+xml,text/xml;q=0.9,text/plain;q=0.8"));
        headers.add(new Header("Accept-Encoding", "x-gzip, gzip"));
        String[] stringArray = webSiteHeaders = this.getConf().get("http.headers").split(SEMICOLON);
        int n = webSiteHeaders.length;
        int n2 = 0;
        while (n2 < n) {
            String header = stringArray[n2];
            String[] headerInformation = header.split(COLON);
            if (headerInformation.length > 2) {
                headers.add(new Header(headerInformation[0].trim(), headerInformation[1].trim()));
            }
            ++n2;
        }
        hostConf.getParams().setParameter("http.default-headers", headers);
        if (this._useProxy) {
            hostConf.setProxy(this._proxyHost, this._proxyPort);
            if (this._proxyLogin.length() > 0) {
                UsernamePasswordCredentials proxyCreds = new UsernamePasswordCredentials(this._proxyLogin, this._proxyPassword);
                s_client.getState().setProxyCredentials(new AuthScope(AuthScope.ANY), (Credentials)proxyCreds);
            }
        }
        List<Rfc2617Authentication> httpAuthentications = this._authentication.getRfc2617Authentications();
        for (Rfc2617Authentication auth : httpAuthentications) {
            s_client.getState().setCredentials(new AuthScope(auth.getHost(), Integer.valueOf(auth.getPort()).intValue(), auth.getRealm()), (Credentials)new UsernamePasswordCredentials(auth.getLogin(), auth.getPassword()));
        }
        SslCertificateAuthentication sslAuth = this._authentication.getSslCertificateAuthentication();
        if (sslAuth != null) {
            try {
                URL truststoreURL = new File(sslAuth.getTruststoreUrl()).toURL();
                URL keystoreURL = new File(sslAuth.getKeystoreUrl()).toURL();
                AuthSSLProtocolSocketFactory sslFactory = new AuthSSLProtocolSocketFactory(keystoreURL, sslAuth.getKeystorePassword(), truststoreURL, sslAuth.getTruststorePassword());
                this._https = new Protocol(sslAuth.getProtocolName(), (ProtocolSocketFactory)sslFactory, Integer.valueOf(sslAuth.getPort()).intValue());
                Protocol.registerProtocol((String)sslAuth.getProtocolName(), (Protocol)this._https);
            }
            catch (MalformedURLException exception) {
                LOG.error((Object)("unable to bind https protocol" + exception.toString()));
            }
        }
    }
}

