/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.framework.crawler.web.net;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.Perl5Pattern;
import org.apache.oro.text.regex.Perl5Substitution;
import org.apache.oro.text.regex.Substitution;
import org.apache.oro.text.regex.Util;
import org.eclipse.smila.connectivity.framework.crawler.web.configuration.Configured;
import org.eclipse.smila.connectivity.framework.crawler.web.net.UrlNormalizer;

public class BasicUrlNormalizer
extends Configured
implements UrlNormalizer {
    private static final Log LOG = LogFactory.getLog(BasicUrlNormalizer.class);
    private final Perl5Compiler _compiler = new Perl5Compiler();
    private final ThreadLocal<PatternMatcher> _matchers = new ThreadLocal<PatternMatcher>(){

        @Override
        protected synchronized PatternMatcher initialValue() {
            return new Perl5Matcher();
        }
    };
    private Rule _relativePathRule;
    private Rule _leadingRelativePathRule;

    public BasicUrlNormalizer() {
        try {
            this._relativePathRule = new Rule();
            this._relativePathRule.setPattern((Perl5Pattern)this._compiler.compile("(/[^/]*[^/.]{1}[^/]*/\\.\\./)", 32768));
            this._relativePathRule.setSubstitution(new Perl5Substitution("/"));
            this._leadingRelativePathRule = new Rule();
            this._leadingRelativePathRule.setPattern((Perl5Pattern)this._compiler.compile("^(/\\.\\./)+", 32768));
            this._leadingRelativePathRule.setSubstitution(new Perl5Substitution("/"));
        }
        catch (MalformedPatternException exception) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)exception);
            }
            throw new RuntimeException(exception);
        }
    }

    @Override
    public String normalize(String urlString) throws MalformedURLException {
        if ("".equals(urlString)) {
            return urlString;
        }
        urlString = urlString.trim();
        URL url = new URL(urlString);
        String protocol = url.getProtocol();
        String host = url.getHost();
        int port = url.getPort();
        String file = url.getFile();
        boolean changed = false;
        if (!urlString.startsWith(protocol)) {
            changed = true;
        }
        if ("http".equals(protocol) || "ftp".equals(protocol)) {
            String file2;
            String newHost;
            if (host != null && !host.equals(newHost = host.toLowerCase())) {
                host = newHost;
                changed = true;
            }
            if (port == url.getDefaultPort()) {
                port = -1;
                changed = true;
            }
            if (file == null || "".equals(file)) {
                file = "/";
                changed = true;
            }
            if (url.getRef() != null) {
                changed = true;
            }
            if (!file.equals(file2 = this.substituteUnnecessaryRelativePaths(file))) {
                changed = true;
                file = file2;
            }
        }
        if (changed) {
            urlString = new URL(protocol, host, port, file).toString();
        }
        return urlString;
    }

    private String substituteUnnecessaryRelativePaths(String file) {
        String fileWorkCopy = file;
        int oldLen = file.length();
        int newLen = oldLen - 1;
        Perl5Matcher matcher = (Perl5Matcher)this._matchers.get();
        while (oldLen != newLen) {
            oldLen = fileWorkCopy.length();
            fileWorkCopy = Util.substitute((PatternMatcher)matcher, (Pattern)this._relativePathRule.getPattern(), (Substitution)this._relativePathRule.getSubstitution(), (String)fileWorkCopy, (int)1);
            fileWorkCopy = Util.substitute((PatternMatcher)matcher, (Pattern)this._leadingRelativePathRule.getPattern(), (Substitution)this._leadingRelativePathRule.getSubstitution(), (String)fileWorkCopy, (int)1);
            newLen = fileWorkCopy.length();
        }
        return fileWorkCopy;
    }

    private static class Rule {
        private Perl5Pattern _pattern;
        private Perl5Substitution _substitution;

        private Rule() {
        }

        public Perl5Pattern getPattern() {
            return this._pattern;
        }

        public void setPattern(Perl5Pattern pattern) {
            this._pattern = pattern;
        }

        public Perl5Substitution getSubstitution() {
            return this._substitution;
        }

        public void setSubstitution(Perl5Substitution substitution) {
            this._substitution = substitution;
        }
    }
}

