/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.meta;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.lib.meta.ClassArgParser;
import org.apache.openjpa.lib.meta.ClasspathMetaDataIterator;
import org.apache.openjpa.lib.meta.FileMetaDataIterator;
import org.apache.openjpa.lib.meta.MetaDataFilter;
import org.apache.openjpa.lib.meta.MetaDataIterator;
import org.apache.openjpa.lib.meta.MetaDataParser;
import org.apache.openjpa.lib.meta.MetaDataSerializer;
import org.apache.openjpa.lib.meta.ResourceMetaDataIterator;
import org.apache.openjpa.lib.meta.URLMetaDataIterator;
import org.apache.openjpa.lib.meta.ZipFileMetaDataIterator;
import org.apache.openjpa.lib.meta.ZipStreamMetaDataIterator;
import org.apache.openjpa.lib.util.Files;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.AbstractMetaDataFactory;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.meta.QueryMetaData;
import org.apache.openjpa.meta.SequenceMetaData;
import org.apache.openjpa.util.GeneralException;
import org.apache.openjpa.util.UserException;
import serp.util.Strings;

public abstract class AbstractCFMetaDataFactory
extends AbstractMetaDataFactory {
    private static final Localizer _loc = Localizer.forPackage(AbstractMetaDataFactory.class);
    protected Collection files = null;
    protected Collection urls = null;
    protected Collection rsrcs = null;
    protected Collection cpath = null;
    private Set _typeNames = null;

    public void setFiles(Collection files) {
        this.files = files;
    }

    public void setFiles(String files) {
        if (StringUtils.isEmpty((String)files)) {
            this.files = null;
        } else {
            String[] strs = Strings.split((String)files, (String)";", (int)0);
            this.files = new HashSet((int)((double)strs.length * 1.33 + 1.0));
            for (int i = 0; i < strs.length; ++i) {
                File file = new File(strs[i]);
                if (!((Boolean)AccessController.doPrivileged(J2DoPrivHelper.existsAction(file))).booleanValue()) continue;
                this.files.add(file);
            }
        }
    }

    public void setURLs(Collection urls) {
        this.urls = urls;
    }

    public void setURLs(String urls) {
        if (StringUtils.isEmpty((String)urls)) {
            this.urls = null;
        } else {
            String[] strs = Strings.split((String)urls, (String)";", (int)0);
            this.urls = new HashSet((int)((double)strs.length * 1.33 + 1.0));
            try {
                for (int i = 0; i < strs.length; ++i) {
                    this.urls.add(new URL(strs[i]));
                }
            }
            catch (MalformedURLException mue) {
                throw new UserException(mue);
            }
        }
    }

    public void setResources(Collection rsrcs) {
        this.rsrcs = rsrcs;
    }

    public void setResources(String rsrcs) {
        this.rsrcs = StringUtils.isEmpty((String)rsrcs) ? null : new ArrayList<String>(Arrays.asList(Strings.split((String)rsrcs, (String)";", (int)0)));
    }

    public void setClasspathScan(Collection cpath) {
        this.cpath = cpath;
    }

    public void setClasspathScan(String cpath) {
        this.cpath = StringUtils.isEmpty((String)cpath) ? null : new ArrayList<String>(Arrays.asList(Strings.split((String)cpath, (String)";", (int)0)));
    }

    public boolean store(ClassMetaData[] metas, QueryMetaData[] queries, SequenceMetaData[] seqs, int mode, Map output) {
        int i;
        Parser parser;
        Serializer ser;
        if (mode == 0) {
            return true;
        }
        if (this.isMappingOnlyFactory() && (mode & 2) == 0) {
            return true;
        }
        if (!this.strict && (mode & 1) != 0) {
            mode |= 2;
        }
        Class cls = metas.length == 0 ? null : metas[0].getDescribedType();
        ClassLoader loader = this.repos.getConfiguration().getClassResolverInstance().getClassLoader(cls, null);
        HashMap<String, ClassMetaData> clsNames = new HashMap<String, ClassMetaData>((int)((double)metas.length * 1.33 + 1.0));
        for (int i2 = 0; i2 < metas.length; ++i2) {
            clsNames.put(metas[i2].getDescribedType().getName(), metas[i2]);
        }
        Set metaFiles = null;
        Set queryFiles = null;
        if (this.isMappingOnlyFactory() || (mode & 1) != 0) {
            metaFiles = this.assignDefaultMetaDataFiles(metas, queries, seqs, mode, clsNames);
        }
        if (!this.isMappingOnlyFactory() && (mode & 4) != 0) {
            queryFiles = this.assignDefaultQueryFiles(queries, clsNames);
        }
        if (mode != 4) {
            int sermode = this.isMappingOnlyFactory() ? mode : mode | 1;
            ser = (mode & 0x10) != 0 ? this.newAnnotationSerializer() : this.newSerializer();
            ser.setMode(sermode);
            if (metaFiles != null) {
                parser = this.newParser(false);
                parser.setMode(sermode);
                parser.setClassLoader(loader);
                this.parse((MetaDataParser)parser, metaFiles);
                MetaDataRepository pr = parser.getRepository();
                pr.setSourceMode(mode);
                if (this.isMappingOnlyFactory()) {
                    pr.setResolve(0);
                } else {
                    pr.setResolve(2, false);
                }
                ser.addAll(pr);
            }
            for (i = 0; i < metas.length; ++i) {
                ser.addMetaData(metas[i]);
            }
            if ((mode & 2) != 0) {
                for (i = 0; i < seqs.length; ++i) {
                    ser.addSequenceMetaData(seqs[i]);
                }
            }
            for (i = 0; i < queries.length; ++i) {
                if (queries[i].getSourceMode() == 4 || (queries[i].getSourceMode() & mode) == 0) continue;
                ser.addQueryMetaData(queries[i]);
            }
            int flags = 1;
            if ((this.store & 2) != 0) {
                flags |= 4;
            }
            this.serialize(ser, output, flags);
        }
        if (!this.isMappingOnlyFactory()) {
            boolean qFiles = queryFiles != null;
            for (i = 0; !qFiles && i < queries.length; ++i) {
                qFiles = queries[i].getSourceMode() == 4;
            }
            if (qFiles) {
                ser = (mode & 0x10) != 0 ? this.newAnnotationSerializer() : this.newSerializer();
                ser.setMode(4);
                if (queryFiles != null) {
                    parser = this.newParser(false);
                    parser.setMode(4);
                    parser.setClassLoader(loader);
                    this.parse((MetaDataParser)parser, queryFiles);
                    ser.addAll(parser.getRepository());
                }
                for (i = 0; i < queries.length; ++i) {
                    if (queries[i].getSourceMode() != 4) continue;
                    ser.addQueryMetaData(queries[i]);
                }
                this.serialize(ser, output, 1);
            }
        }
        return true;
    }

    public boolean drop(Class[] cls, int mode, ClassLoader envLoader) {
        int i;
        if (mode == 0) {
            return true;
        }
        if (this.isMappingOnlyFactory() && (mode & 2) == 0) {
            return true;
        }
        Parser parser = this.newParser(false);
        MetaDataRepository pr = parser.getRepository();
        pr.setSourceMode(2, false);
        pr.setResolve(2, false);
        if ((mode & 3) != 0) {
            parser.setMode(this.isMappingOnlyFactory() ? mode : 7);
            this.parse((MetaDataParser)parser, cls);
        }
        if (!this.isMappingOnlyFactory() && (mode & 4) != 0) {
            parser.setMode(4);
            this.parse((MetaDataParser)parser, cls);
        }
        HashSet<File> files = new HashSet<File>();
        HashSet<String> clsNames = null;
        if ((mode & 3) != 0) {
            clsNames = new HashSet<String>((int)((double)cls.length * 1.33 + 1.0));
            for (int i2 = 0; i2 < cls.length; ++i2) {
                if (cls[i2] == null) {
                    clsNames.add(null);
                } else {
                    clsNames.add(cls[i2].getName());
                }
                ClassMetaData meta = pr.getMetaData(cls[i2], envLoader, false);
                if (meta == null) continue;
                if (this.getSourceFile(meta) != null) {
                    files.add(this.getSourceFile(meta));
                }
                if ((mode & 1) != 0) {
                    pr.removeMetaData(meta);
                    continue;
                }
                if (this.isMappingOnlyFactory()) continue;
                this.clearMapping(meta);
            }
        }
        QueryMetaData[] queries = pr.getQueryMetaDatas();
        ArrayList<QueryMetaData> qqs = !this.isMappingOnlyFactory() && (mode & 4) == 0 ? null : new ArrayList<QueryMetaData>();
        for (int i3 = 0; i3 < queries.length; ++i3) {
            boolean rem;
            if (!this.isMappingOnlyFactory() && queries[i3].getSourceFile() != null) {
                files.add(queries[i3].getSourceFile());
            }
            Class def = queries[i3].getDefiningType();
            boolean bl = (queries[i3].getSourceMode() & mode) != 0 && clsNames.contains(def == null ? null : def.getName()) ? true : (rem = false);
            if (rem || !this.isMappingOnlyFactory() && queries[i3].getSourceMode() == 4) {
                pr.removeQueryMetaData(queries[i3]);
            }
            if (qqs == null || queries[i3].getSourceMode() != 4 || rem) continue;
            qqs.add(queries[i3]);
        }
        this.backupAndDelete(files);
        if ((mode & 3) != 0) {
            Serializer ser = this.newSerializer();
            ser.setMode(this.isMappingOnlyFactory() ? mode : mode | 1);
            ser.addAll(pr);
            if (this.isMappingOnlyFactory()) {
                for (i = 0; i < cls.length; ++i) {
                    ser.removeMetaData(pr.getMetaData(cls[i], envLoader, false));
                }
            }
            this.serialize(ser, null, 1);
        }
        if (qqs != null && !qqs.isEmpty()) {
            Serializer ser = this.newSerializer();
            ser.setMode(4);
            for (i = 0; i < qqs.size(); ++i) {
                ser.addQueryMetaData((QueryMetaData)qqs.get(i));
            }
            this.serialize(ser, null, 1);
        }
        return true;
    }

    private Set assignDefaultMetaDataFiles(ClassMetaData[] metas, QueryMetaData[] queries, SequenceMetaData[] seqs, int mode, Map clsNames) {
        int i;
        HashSet<File> files = null;
        for (i = 0; i < metas.length; ++i) {
            if (this.getSourceFile(metas[i]) == null) {
                this.setSourceFile(metas[i], this.defaultSourceFile(metas[i]));
            }
            if (!((Boolean)AccessController.doPrivileged(J2DoPrivHelper.existsAction(this.getSourceFile(metas[i])))).booleanValue()) continue;
            if (files == null) {
                files = new HashSet<File>();
            }
            files.add(this.getSourceFile(metas[i]));
        }
        for (i = 0; i < queries.length; ++i) {
            if (queries[i].getSourceMode() == 4 || (mode & queries[i].getSourceMode()) == 0) continue;
            if (queries[i].getSourceFile() == null) {
                queries[i].setSource(this.defaultSourceFile(queries[i], clsNames), queries[i].getSourceScope(), queries[i].getSourceType());
            }
            if (!((Boolean)AccessController.doPrivileged(J2DoPrivHelper.existsAction(queries[i].getSourceFile()))).booleanValue()) continue;
            if (files == null) {
                files = new HashSet();
            }
            files.add(queries[i].getSourceFile());
        }
        if ((mode & 2) != 0) {
            for (i = 0; i < seqs.length; ++i) {
                if (this.getSourceFile(seqs[i]) == null) {
                    this.setSourceFile(seqs[i], this.defaultSourceFile(seqs[i], clsNames));
                }
                if (!((Boolean)AccessController.doPrivileged(J2DoPrivHelper.existsAction(this.getSourceFile(seqs[i])))).booleanValue()) continue;
                if (files == null) {
                    files = new HashSet();
                }
                files.add(this.getSourceFile(seqs[i]));
            }
        }
        return files;
    }

    private Set assignDefaultQueryFiles(QueryMetaData[] queries, Map clsNames) {
        HashSet<File> files = null;
        for (int i = 0; i < queries.length; ++i) {
            if (queries[i].getSourceMode() != 4) continue;
            if (queries[i].getSourceFile() == null) {
                queries[i].setSource(this.defaultSourceFile(queries[i], clsNames), queries[i].getSourceScope(), queries[i].getSourceType());
            }
            if (!((Boolean)AccessController.doPrivileged(J2DoPrivHelper.existsAction(queries[i].getSourceFile()))).booleanValue()) continue;
            if (files == null) {
                files = new HashSet<File>();
            }
            files.add(queries[i].getSourceFile());
        }
        return files;
    }

    protected boolean isMappingOnlyFactory() {
        return false;
    }

    protected void parse(MetaDataParser parser, Collection files) {
        try {
            Iterator itr = files.iterator();
            while (itr.hasNext()) {
                parser.parse((File)itr.next());
            }
        }
        catch (IOException ioe) {
            throw new GeneralException(ioe);
        }
    }

    protected void parse(MetaDataParser parser, Class[] cls) {
        try {
            for (int i = 0; i < cls.length; ++i) {
                parser.parse(cls[i], this.isParseTopDown());
            }
        }
        catch (IOException ioe) {
            throw new GeneralException(ioe);
        }
    }

    protected boolean isParseTopDown() {
        return false;
    }

    protected void serialize(MetaDataSerializer ser, Map output, int flags) {
        try {
            if (output == null) {
                ser.serialize(flags);
            } else {
                ser.serialize(output, flags);
            }
        }
        catch (IOException ioe) {
            throw new GeneralException(ioe);
        }
    }

    protected void backupAndDelete(Collection files) {
        for (File file : files) {
            if (Files.backup(file, false) == null) continue;
            AccessController.doPrivileged(J2DoPrivHelper.deleteAction(file));
        }
    }

    protected void clearMapping(ClassMetaData meta) {
        meta.setSourceMode(2, false);
    }

    protected File getSourceFile(ClassMetaData meta) {
        return meta.getSourceFile();
    }

    protected void setSourceFile(ClassMetaData meta, File sourceFile) {
        meta.setSource(sourceFile, meta.getSourceType());
    }

    protected File getSourceFile(SequenceMetaData meta) {
        return meta.getSourceFile();
    }

    protected void setSourceFile(SequenceMetaData meta, File sourceFile) {
        meta.setSource(sourceFile, meta.getSourceScope(), meta.getSourceType());
    }

    protected abstract File defaultSourceFile(ClassMetaData var1);

    protected abstract File defaultSourceFile(QueryMetaData var1, Map var2);

    protected abstract File defaultSourceFile(SequenceMetaData var1, Map var2);

    protected abstract Parser newParser(boolean var1);

    protected abstract Serializer newSerializer();

    protected abstract Serializer newAnnotationSerializer();

    protected ClassMetaData getDefiningMetaData(QueryMetaData query, Map clsNames) {
        Class def = query.getDefiningType();
        if (def != null) {
            return (ClassMetaData)clsNames.get(def.getName());
        }
        for (Map.Entry entry : clsNames.entrySet()) {
            String pkg = Strings.getPackageName((String)((String)entry.getKey()));
            if (pkg.length() != 0) continue;
            return (ClassMetaData)entry.getValue();
        }
        return null;
    }

    public Set getPersistentTypeNames(boolean devpath, ClassLoader envLoader) {
        if (this._typeNames != null) {
            return this._typeNames.isEmpty() ? null : this._typeNames;
        }
        try {
            ClassLoader loader = this.repos.getConfiguration().getClassResolverInstance().getClassLoader(this.getClass(), envLoader);
            long start = System.currentTimeMillis();
            Set names = this.parsePersistentTypeNames(loader);
            if (names.isEmpty() && devpath) {
                this.scan(new ClasspathMetaDataIterator(null, this.newMetaDataFilter()), this.newClassArgParser(), names, false, null);
            } else {
                this._typeNames = names;
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace(_loc.get("found-pcs", String.valueOf(names.size()), String.valueOf(System.currentTimeMillis() - start)));
            }
            return names.isEmpty() ? null : names;
        }
        catch (IOException ioe) {
            throw new GeneralException(ioe);
        }
    }

    private Set parsePersistentTypeNames(ClassLoader loader) throws IOException {
        String[] clss;
        ClassArgParser cparser = this.newClassArgParser();
        HashSet<String> names = new HashSet<String>();
        if (this.files != null) {
            for (File file : this.files) {
                if (((Boolean)AccessController.doPrivileged(J2DoPrivHelper.isDirectoryAction(file))).booleanValue()) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace(_loc.get("scanning-directory", file));
                    }
                    this.scan(new FileMetaDataIterator(file, this.newMetaDataFilter()), cparser, names, true, file);
                    continue;
                }
                if (file.getName().endsWith(".jar")) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace(_loc.get("scanning-jar", file));
                    }
                    try {
                        ZipFile zFile = (ZipFile)AccessController.doPrivileged(J2DoPrivHelper.newZipFileAction(file));
                        this.scan(new ZipFileMetaDataIterator(zFile, this.newMetaDataFilter()), cparser, names, true, file);
                        continue;
                    }
                    catch (PrivilegedActionException pae) {
                        throw (IOException)pae.getException();
                    }
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace(_loc.get("scanning-file", file));
                }
                clss = cparser.parseTypeNames(new FileMetaDataIterator(file));
                if (this.log.isTraceEnabled()) {
                    this.log.trace(_loc.get("scan-found-names", clss, file));
                }
                names.addAll(Arrays.asList(clss));
                File f = (File)AccessController.doPrivileged(J2DoPrivHelper.getAbsoluteFileAction(file));
                try {
                    this.mapPersistentTypeNames(AccessController.doPrivileged(J2DoPrivHelper.toURLAction(f)), clss);
                }
                catch (PrivilegedActionException pae) {
                    throw (FileNotFoundException)pae.getException();
                }
            }
        }
        if (this.urls != null) {
            for (URL url : this.urls) {
                if ("file".equals(url.getProtocol())) {
                    File file = (File)AccessController.doPrivileged(J2DoPrivHelper.getAbsoluteFileAction(new File(url.getFile())));
                    if (this.files != null && this.files.contains(file)) continue;
                    if (((Boolean)AccessController.doPrivileged(J2DoPrivHelper.isDirectoryAction(file))).booleanValue()) {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace(_loc.get("scanning-directory", file));
                        }
                        this.scan(new FileMetaDataIterator(file, this.newMetaDataFilter()), cparser, names, true, file);
                        continue;
                    }
                }
                if ("jar".equals(url.getProtocol()) && url.getPath().endsWith("!/")) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace(_loc.get("scanning-jar-url", url));
                    }
                    this.scan(new ZipFileMetaDataIterator(url, this.newMetaDataFilter()), cparser, names, true, url);
                    continue;
                }
                if (url.getPath().endsWith(".jar")) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace(_loc.get("scanning-jar-at-url", url));
                    }
                    try {
                        InputStream is = (InputStream)AccessController.doPrivileged(J2DoPrivHelper.openStreamAction(url));
                        this.scan(new ZipStreamMetaDataIterator(new ZipInputStream(is), this.newMetaDataFilter()), cparser, names, true, url);
                        continue;
                    }
                    catch (PrivilegedActionException pae) {
                        throw (IOException)pae.getException();
                    }
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace(_loc.get("scanning-url", url));
                }
                clss = cparser.parseTypeNames(new URLMetaDataIterator(url));
                if (this.log.isTraceEnabled()) {
                    this.log.trace(_loc.get("scan-found-names", clss, url));
                }
                names.addAll(Arrays.asList(clss));
                this.mapPersistentTypeNames(url, clss);
            }
        }
        if (this.rsrcs != null) {
            for (String rsrc : this.rsrcs) {
                URL url;
                if (rsrc.endsWith(".jar")) {
                    url = (URL)AccessController.doPrivileged(J2DoPrivHelper.getResourceAction(loader, rsrc));
                    if (url == null) continue;
                    if (this.log.isTraceEnabled()) {
                        this.log.trace(_loc.get("scanning-jar-stream-url", url));
                    }
                    try {
                        InputStream is = (InputStream)AccessController.doPrivileged(J2DoPrivHelper.openStreamAction(url));
                        this.scan(new ZipStreamMetaDataIterator(new ZipInputStream(is), this.newMetaDataFilter()), cparser, names, true, url);
                        continue;
                    }
                    catch (PrivilegedActionException pae) {
                        throw (IOException)pae.getException();
                    }
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace(_loc.get("scanning-resource", rsrc));
                }
                ResourceMetaDataIterator mitr = new ResourceMetaDataIterator(rsrc, loader);
                while (mitr.hasNext()) {
                    url = (URL)mitr.next();
                    clss = cparser.parseTypeNames(new URLMetaDataIterator(url));
                    if (this.log.isTraceEnabled()) {
                        this.log.trace(_loc.get("scan-found-names", clss, rsrc));
                    }
                    names.addAll(Arrays.asList(clss));
                    this.mapPersistentTypeNames(url, clss);
                }
                mitr.close();
            }
        }
        if (this.cpath != null) {
            String[] dirs = this.cpath.toArray(new String[this.cpath.size()]);
            this.scan(new ClasspathMetaDataIterator(dirs, this.newMetaDataFilter()), cparser, names, true, dirs);
        }
        if (this.types != null) {
            names.addAll(this.types);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace(_loc.get("parse-found-names", names));
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scan(MetaDataIterator mitr, ClassArgParser cparser, Set names, boolean mapNames, Object debugContext) throws IOException {
        Map map;
        try {
            map = cparser.mapTypeNames(mitr);
            Object var8_7 = null;
            mitr.close();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            mitr.close();
            throw throwable;
        }
        for (Map.Entry entry : map.entrySet()) {
            if (mapNames) {
                this.mapPersistentTypeNames(entry.getKey(), (String[])entry.getValue());
            }
            List<String> newNames = Arrays.asList((String[])entry.getValue());
            if (this.log.isTraceEnabled()) {
                this.log.trace(_loc.get("scan-found-names", newNames, debugContext));
            }
            names.addAll(newNames);
        }
    }

    protected void mapPersistentTypeNames(Object rsrc, String[] names) {
    }

    protected abstract MetaDataFilter newMetaDataFilter();

    public void clear() {
        super.clear();
        this._typeNames = null;
    }

    public static interface Serializer
    extends MetaDataSerializer {
        public void setMode(int var1);

        public void addMetaData(ClassMetaData var1);

        public boolean removeMetaData(ClassMetaData var1);

        public void addSequenceMetaData(SequenceMetaData var1);

        public void addQueryMetaData(QueryMetaData var1);

        public void addAll(MetaDataRepository var1);
    }

    public static interface Parser
    extends MetaDataParser {
        public MetaDataRepository getRepository();

        public void setMode(int var1);
    }
}

