/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.datamodel.ipc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.datamodel.ValueFormatHelper;
import org.eclipse.smila.ipc.IpcFactory;
import org.eclipse.smila.ipc.IpcStreamReader;
import org.eclipse.smila.ipc.IpcStreamWriter;
import org.eclipse.smila.ipc.IpcToken;
import org.eclipse.smila.ipc.bon.BinaryFactory;
import org.eclipse.smila.ipc.json.JsonFactory;

public class IpcSerializationUtils {
    public static final String ENCODING = "UTF-8";
    private static final String ATTACHMENT_NAMES = "__attachmentNamesForIpc";
    private final IpcFactory _binaryFactory = new BinaryFactory();
    private final IpcFactory _jsonFactory;
    private final ValueFormatHelper _formatHelper = new ValueFormatHelper();

    public IpcSerializationUtils() {
        this(true);
    }

    public IpcSerializationUtils(boolean printPretty) {
        this._jsonFactory = new JsonFactory(printPretty);
    }

    public IpcFactory getBinaryFactory() {
        return this._binaryFactory;
    }

    public Record binaryObject2record(byte[] binaryObject) throws IOException {
        Record record;
        ByteArrayInputStream bais = null;
        try {
            bais = new ByteArrayInputStream(binaryObject);
            record = this.binaryStream2record(bais);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(bais);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)bais);
        return record;
    }

    public Record binaryStream2record(InputStream stream) throws IOException {
        IpcStreamReader reader = this._binaryFactory.newStreamReader(stream);
        return this.stream2record(reader);
    }

    public Any binaryObject2any(byte[] binaryObject) throws IOException {
        Any any;
        ByteArrayInputStream bais = null;
        try {
            bais = new ByteArrayInputStream(binaryObject);
            any = this.binaryStream2any(bais);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(bais);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)bais);
        return any;
    }

    public Any binaryStream2any(InputStream stream) throws IOException {
        IpcStreamReader reader = this._binaryFactory.newStreamReader(stream);
        return this.stream2any(reader);
    }

    public byte[] record2BinaryObject(Record record) throws IOException {
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream();
            this.record2BinaryStream(baos, record);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            IOUtils.closeQuietly((OutputStream)baos);
        }
    }

    public void record2BinaryStream(OutputStream stream, Record record) throws IOException {
        IpcStreamWriter writer = this._binaryFactory.newStreamWriter(stream);
        this.record2Stream(writer, record);
    }

    public void any2BinaryStream(OutputStream stream, Any object) throws IOException {
        IpcStreamWriter writer = this._binaryFactory.newStreamWriter(stream);
        this.any2Stream(writer, object);
    }

    public byte[] any2BinaryObject(Any object) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.any2BinaryStream(outputStream, object);
        return outputStream.toByteArray();
    }

    public IpcFactory getJsonFactory() {
        return this._jsonFactory;
    }

    public Record jsonObject2record(String jsonString) throws IOException {
        Record record;
        ByteArrayInputStream bais = null;
        try {
            Record record2;
            bais = new ByteArrayInputStream(jsonString.getBytes(ENCODING));
            record = record2 = this.jsonStream2record(bais);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(bais);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)bais);
        return record;
    }

    public Record jsonStream2record(InputStream stream) throws IOException {
        IpcStreamReader reader = this._jsonFactory.newStreamReader(stream);
        try {
            Record record = this.stream2record(reader);
            return record;
        }
        finally {
            reader.closeWithoutStream();
        }
    }

    public Any jsonStream2any(InputStream stream) throws IOException {
        IpcStreamReader reader = this._jsonFactory.newStreamReader(stream);
        try {
            Any any = this.stream2any(reader);
            return any;
        }
        finally {
            reader.closeWithoutStream();
        }
    }

    public Record stream2record(IpcStreamReader reader) throws IOException {
        IpcToken token = reader.nextToken();
        if (token == null) {
            return null;
        }
        if (token != IpcToken.OBJECT_START) {
            throw new IllegalStateException("Expected OBJECT_START Token; Token = " + token);
        }
        token = reader.nextToken();
        if (token != IpcToken.MAPPING_START) {
            throw new IllegalStateException("Expected MAPPING_START Token; Token = " + token);
        }
        AnyMap metadata = this.readMap(reader);
        Record record = DataFactory.DEFAULT.createRecord();
        if (metadata.containsKey(ATTACHMENT_NAMES)) {
            for (Any attName : metadata.getSeq(ATTACHMENT_NAMES)) {
                record.setAttachment(attName.asValue().asString(), null);
            }
            metadata.remove(ATTACHMENT_NAMES);
        }
        record.getMetadata().putAll(metadata);
        token = reader.nextToken();
        if (token != IpcToken.OBJECT_END) {
            throw new IllegalStateException("Expected OBJECT_END Token; Token = " + token);
        }
        return record;
    }

    public Any stream2any(IpcStreamReader reader) throws IOException {
        Any any;
        IpcToken token = reader.nextToken();
        if (token == null) {
            return null;
        }
        if (token != IpcToken.OBJECT_START) {
            throw new IllegalStateException("Expected OBJECT_START Token; Token = " + token);
        }
        token = reader.nextToken();
        if (token != IpcToken.OBJECT_END) {
            any = this.readAny(reader, token);
            token = reader.nextToken();
        } else {
            any = null;
        }
        if (token != IpcToken.OBJECT_END) {
            throw new IllegalStateException("Expected OBJECT_END Token; Token = " + token);
        }
        return any;
    }

    public String record2JsonObject(Record record) throws IOException {
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream();
            this.record2JsonStream(baos, record);
            String string = baos.toString(ENCODING);
            return string;
        }
        finally {
            IOUtils.closeQuietly((OutputStream)baos);
        }
    }

    public void record2JsonStream(OutputStream stream, Record record) throws IOException {
        IpcStreamWriter writer = this._jsonFactory.newStreamWriter(stream);
        try {
            this.record2Stream(writer, record);
        }
        finally {
            writer.closeWithoutStream();
        }
    }

    public void map2JsonStream(OutputStream stream, AnyMap object) throws IOException {
        this.any2JsonStream(stream, object);
    }

    public String map2JsonObject(AnyMap object) throws IOException {
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream();
            this.map2JsonStream(baos, object);
            String string = baos.toString(ENCODING);
            return string;
        }
        finally {
            IOUtils.closeQuietly((OutputStream)baos);
        }
    }

    public void any2JsonStream(OutputStream stream, Any object) throws IOException {
        IpcStreamWriter writer = this._jsonFactory.newStreamWriter(stream);
        try {
            this.any2Stream(writer, object);
        }
        finally {
            writer.closeWithoutStream();
        }
    }

    public void any2Stream(IpcStreamWriter writer, Any object) throws IOException {
        writer.writeObjectStart();
        this.writeAny(writer, object);
        writer.writeObjectEnd();
    }

    public void record2Stream(IpcStreamWriter writer, Record record) throws IOException {
        AnyMap recordMetadata = record.getMetadata();
        Iterator<String> attNames = record.getAttachmentNames();
        while (attNames.hasNext()) {
            recordMetadata.add(ATTACHMENT_NAMES, recordMetadata.getFactory().createStringValue(attNames.next()));
        }
        this.any2Stream(writer, recordMetadata);
        recordMetadata.remove(ATTACHMENT_NAMES);
    }

    private AnyMap readMap(IpcStreamReader reader) throws IOException {
        IpcToken token;
        AnyMap map = DataFactory.DEFAULT.createAnyMap();
        while ((token = reader.nextToken()) != IpcToken.MAPPING_END) {
            if (token != IpcToken.SCALAR_STRING) {
                throw new IllegalStateException("Expected SCALAR_STRING Token; Token = " + token);
            }
            String key = reader.currentStringValue();
            map.put(key, this.readAny(reader, reader.nextToken()));
        }
        return map;
    }

    private AnySeq readSeq(IpcStreamReader reader) throws IOException {
        AnySeq anySeq = DataFactory.DEFAULT.createAnySeq();
        IpcToken token = null;
        while ((token = reader.nextToken()) != IpcToken.SEQUENCE_END) {
            anySeq.add(this.readAny(reader, token));
        }
        return anySeq;
    }

    private Value readValue(IpcStreamReader reader, IpcToken token) throws IOException {
        Value value = null;
        switch (token) {
            case SCALAR_BOOL: {
                value = DataFactory.DEFAULT.createBooleanValue(reader.currentBoolValue());
                break;
            }
            case SCALAR_DOUBLE: {
                value = DataFactory.DEFAULT.createDoubleValue(reader.currentDoubleValue());
                break;
            }
            case SCALAR_INT: {
                value = DataFactory.DEFAULT.createLongValue(reader.currentLongValue());
                break;
            }
            default: {
                value = DataFactory.DEFAULT.tryDateTimestampParsingFromString(reader.currentStringValue());
            }
        }
        return value;
    }

    private Any readAny(IpcStreamReader reader, IpcToken token) throws IOException {
        Any any = null;
        switch (token) {
            case MAPPING_START: {
                any = this.readMap(reader);
                break;
            }
            case SEQUENCE_START: {
                any = this.readSeq(reader);
                break;
            }
            default: {
                any = this.readValue(reader, token);
            }
        }
        return any;
    }

    private void writeSeq(IpcStreamWriter writer, AnySeq seq) throws IOException {
        writer.writeSequenceStart();
        for (Any any : seq) {
            this.writeAny(writer, any);
        }
        writer.writeSequenceEnd();
    }

    private void writeMap(IpcStreamWriter writer, AnyMap object) throws IOException {
        if (object != null) {
            writer.writeMappingStart();
            if (!object.isEmpty()) {
                for (Map.Entry childEntry : object.entrySet()) {
                    String childKey = (String)childEntry.getKey();
                    writer.writeMappingKey(childKey);
                    Any any = (Any)childEntry.getValue();
                    this.writeAny(writer, any);
                }
            }
            writer.writeMappingEnd();
        }
    }

    private void writeValue(IpcStreamWriter writer, Value value) throws IOException {
        if (value != null) {
            if (value.isBoolean()) {
                writer.writeScalarBoolean(value.asBoolean().booleanValue());
            } else if (value.isLong()) {
                writer.writeScalarLong(value.asLong().longValue());
            } else if (value.isDouble()) {
                writer.writeScalarDouble(value.asDouble().doubleValue());
            } else {
                writer.writeScalarString(value.asString());
            }
        }
    }

    private void writeAny(IpcStreamWriter writer, Any object) throws IOException {
        if (object != null) {
            if (object.isMap()) {
                this.writeMap(writer, (AnyMap)object);
            } else if (object.isSeq()) {
                this.writeSeq(writer, (AnySeq)object);
            } else if (object.isValue()) {
                this.writeValue(writer, (Value)object);
            }
        }
    }
}

