/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher, Andreas Weber, Drazen Cindric, Andreas Schank (all Attensity Europe GmbH) - initial
 * implementation
 **********************************************************************************************************************/
package org.eclipse.smila.jobmanager.taskgenerator;

/**
 * Provides access to different TaskGenerator services.
 */
public interface TaskGeneratorProvider {

  /** The name of the default task generator. */
  String DEFAULT_TASK_GENERATOR = "default";

  /**
   * @param taskGeneratorName
   *          the TaskGenerator service is selected by name
   * @return TaskGenerator for the given name
   */
  TaskGenerator getTaskGenerator(final String taskGeneratorName);

  /**
   * @return the default {@link TaskGenerator}.
   */
  TaskGenerator getDefaultTaskGenerator();

}
