/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.utils.compression;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;

public final class CompressionHelper {
    private CompressionHelper() {
    }

    public static void unzip(File dest, InputStream inputStream) throws IOException {
        ZipInputStream zis = null;
        FileOutputStream fileOutputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        try {
            ZipEntry entry;
            zis = new ZipInputStream(inputStream);
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.isDirectory()) {
                    new File(dest, entry.getName()).mkdir();
                    continue;
                }
                File destFile = new File(dest, entry.getName());
                if (!destFile.getParentFile().exists()) {
                    destFile.getParentFile().mkdirs();
                }
                try {
                    fileOutputStream = new FileOutputStream(destFile);
                    bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                    IOUtils.copy((InputStream)zis, (OutputStream)bufferedOutputStream);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fileOutputStream);
                    IOUtils.closeQuietly(bufferedOutputStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)fileOutputStream);
                IOUtils.closeQuietly((OutputStream)bufferedOutputStream);
                destFile.setLastModified(entry.getTime());
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(zis);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)zis);
    }
}

