/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.utils.extensions;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;

public abstract class AbstractPluginRegistryBase<T> {
    protected IRegistryChangeListener _listener = new RegistryListener();
    protected Object _mutex = new Object();
    private final Log _log = LogFactory.getLog(AbstractPluginRegistryBase.class);

    public AbstractPluginRegistryBase() {
        this.initialize();
        Platform.getExtensionRegistry().addRegistryChangeListener(this._listener);
    }

    protected abstract String getExtensionPointNameSpace();

    protected abstract String getExtensionPointLocalName();

    protected void initialize() {
        IExtension[] extensions;
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(this.getExtensionPointFullName());
        IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            try {
                this.extensionAdded(extension.getUniqueIdentifier(), extension);
            }
            catch (Throwable e) {
                this._log.error((Object)"Error initializing AbstractPluginRegistryBase", e);
            }
            ++n2;
        }
        this.finalizeExtensionChanges();
    }

    protected abstract void extensionAdded(String var1, IExtension var2) throws CoreException;

    protected abstract void extensionRemoved(String var1) throws CoreException;

    protected abstract void finalizeExtensionChanges();

    protected String getExtensionPointFullName() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getExtensionPointNameSpace());
        sb.append('.');
        sb.append(this.getExtensionPointLocalName());
        return sb.toString();
    }

    protected T createInstance(IExtension extension) throws CoreException {
        return (T)extension.getConfigurationElements()[0].createExecutableExtension("class");
    }

    protected class RegistryListener
    implements IRegistryChangeListener {
        protected RegistryListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void registryChanged(IRegistryChangeEvent event) {
            IExtensionDelta[] deltas = event.getExtensionDeltas(AbstractPluginRegistryBase.this.getExtensionPointNameSpace(), AbstractPluginRegistryBase.this.getExtensionPointLocalName());
            if (AbstractPluginRegistryBase.this._log.isTraceEnabled()) {
                AbstractPluginRegistryBase.this._log.trace((Object)("RegistryListener registryChanged: DELTAS length=" + deltas.length));
            }
            if (deltas.length > 0) {
                Object object = AbstractPluginRegistryBase.this._mutex;
                synchronized (object) {
                    IExtensionDelta[] iExtensionDeltaArray = deltas;
                    int n = deltas.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IExtensionDelta delta = iExtensionDeltaArray[n2];
                        String id = delta.getExtension().getUniqueIdentifier();
                        if (delta.getKind() == 1) {
                            if (AbstractPluginRegistryBase.this._log.isTraceEnabled()) {
                                AbstractPluginRegistryBase.this._log.trace((Object)("Extension " + id + " state changed (ADDED)"));
                            }
                            try {
                                AbstractPluginRegistryBase.this.extensionAdded(id, delta.getExtension());
                            }
                            catch (Throwable e) {
                                AbstractPluginRegistryBase.this._log.error((Object)"", e);
                            }
                        } else if (delta.getKind() == 2) {
                            if (AbstractPluginRegistryBase.this._log.isTraceEnabled()) {
                                AbstractPluginRegistryBase.this._log.trace((Object)("Extension " + id + " state changed (REMOVED)"));
                            }
                            try {
                                AbstractPluginRegistryBase.this.extensionRemoved(id);
                            }
                            catch (Throwable e) {
                                AbstractPluginRegistryBase.this._log.error((Object)"", e);
                            }
                        } else {
                            throw new RuntimeException("Unknown Delta Kind=" + delta.getKind());
                        }
                        AbstractPluginRegistryBase.this.finalizeExtensionChanges();
                        ++n2;
                    }
                }
            }
        }
    }
}

