/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.pipelets.xmlprocessing.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Hashtable;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.smila.processing.pipelets.xmlprocessing.util.XMLUtils;
import org.eclipse.smila.processing.pipelets.xmlprocessing.util.XmlException;
import org.eclipse.smila.processing.pipelets.xmlprocessing.util.XslException;
import org.w3c.dom.Document;

public class XslTransformer {
    private static TransformerFactory s_transformerFactory = TransformerFactory.newInstance();
    private final Hashtable<String, SubTemplates> _templates = new Hashtable();

    public Document transform(Document document, String xslFile) throws XslException, XmlException, IOException {
        try {
            Transformer transformer = this.getTransformer(xslFile);
            DOMSource source = new DOMSource(document);
            Document resultDocument = XMLUtils.newDocument();
            DOMResult result = new DOMResult(resultDocument);
            transformer.transform(source, result);
            return resultDocument;
        }
        catch (TransformerException e) {
            throw new XslException(e);
        }
    }

    private Transformer getTransformer(String xslFile) throws XslException, IOException {
        SubTemplates subTemplates = this._templates.get(xslFile);
        try {
            File file = new File(xslFile);
            if (!file.exists()) {
                throw new FileNotFoundException(xslFile);
            }
            if (subTemplates == null || subTemplates.getTimestamp() != file.lastModified()) {
                StreamSource source = new StreamSource(file);
                Templates template = s_transformerFactory.newTemplates(source);
                SubTemplates newSubTemplates = new SubTemplates(template, file.lastModified());
                this._templates.put(xslFile, newSubTemplates);
                subTemplates = newSubTemplates;
            }
            return subTemplates.getTemplates().newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new XslException(e);
        }
    }

    private class SubTemplates {
        private final Templates _templates;
        private final long _timestamp;

        public SubTemplates(Templates templates, long timestamp) {
            this._templates = templates;
            this._timestamp = timestamp;
        }

        public Templates getTemplates() {
            return this._templates;
        }

        public long getTimestamp() {
            return this._timestamp;
        }
    }
}

