/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.bulkbuilder.outputs;

import java.io.IOException;
import org.eclipse.smila.bulkbuilder.BulkbuilderException;
import org.eclipse.smila.bulkbuilder.outputs.BulkType;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.objectstore.ObjectStoreException;
import org.eclipse.smila.taskworker.io.IODataObject;
import org.eclipse.smila.taskworker.output.Output;

public abstract class BulkOutput {
    protected Output _bulk;
    private final String _jobName;
    private String _currentBulkId;
    private final BulkType _bulkType;
    private final long _bulkStartTime = System.currentTimeMillis();
    private long _lastModificationTime = System.currentTimeMillis();
    private long _bulkSizeLimit = -1L;
    private long _commitTimeout = -1L;

    public BulkOutput(String jobName, String bulkId, BulkType bulkType) {
        this._jobName = jobName;
        this._currentBulkId = bulkId;
        this._bulkType = bulkType;
    }

    public String getJobName() {
        return this._jobName;
    }

    public String getCurrentBulkId() {
        return this._currentBulkId;
    }

    public void setCurrentBulkId(String currentBulkId) {
        this._currentBulkId = currentBulkId;
    }

    public BulkType getBulkType() {
        return this._bulkType;
    }

    public Output getBulk() {
        return this._bulk;
    }

    public void setBulk(Output bulk) {
        this._bulk = bulk;
    }

    public long getBulkStartTime() {
        return this._bulkStartTime;
    }

    public long getLastModificationTime() {
        return this._lastModificationTime;
    }

    public void setLastModificationTime(long lastModificationTime) {
        this._lastModificationTime = lastModificationTime;
    }

    public long getCommitTimeout() {
        return this._commitTimeout;
    }

    public boolean isTimedOut() {
        return this._commitTimeout >= 0L && System.currentTimeMillis() - this._lastModificationTime >= this._commitTimeout;
    }

    public void setCommitTimeout(long commitTimeout) {
        this._commitTimeout = commitTimeout;
    }

    public void setBulkSizeLimit(long bulkSizeLimit) {
        this._bulkSizeLimit = bulkSizeLimit;
    }

    public long getBulkSizeLimit() {
        return this._bulkSizeLimit;
    }

    public boolean hasGrownBeyondLimit() {
        return this._bulkSizeLimit >= 0L && this.getBytesWritten() > this._bulkSizeLimit;
    }

    public void commit() throws BulkbuilderException {
        try {
            this._bulk.commit();
        }
        catch (IOException ex) {
            throw new BulkbuilderException(String.valueOf(ex.getClass().getSimpleName()) + " committing bulk " + this.getCurrentBulkId(), ex);
        }
        catch (ObjectStoreException ex) {
            throw new BulkbuilderException(String.valueOf(((Object)((Object)ex)).getClass().getSimpleName()) + " committing bulk " + this.getCurrentBulkId(), ex);
        }
    }

    public IODataObject getOutput() {
        return this._bulk;
    }

    public abstract void addRecord(Record var1) throws BulkbuilderException;

    public abstract long getBytesWritten();
}

