/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.framework.impl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.connectivity.ConnectivityException;
import org.eclipse.smila.connectivity.ConnectivityManager;
import org.eclipse.smila.connectivity.deltaindexing.DeltaIndexingManager;
import org.eclipse.smila.connectivity.framework.compound.CompoundManager;
import org.eclipse.smila.connectivity.framework.schema.ConfigurationLoader;
import org.eclipse.smila.connectivity.framework.schema.config.DataConnectionID;
import org.eclipse.smila.connectivity.framework.schema.config.DataSourceConnectionConfig;
import org.eclipse.smila.connectivity.framework.schema.config.DeltaIndexingType;
import org.eclipse.smila.connectivity.framework.schema.config.interfaces.IAttribute;
import org.eclipse.smila.utils.config.ConfigUtils;
import org.osgi.service.component.ComponentFactory;
import org.osgi.service.component.ComponentInstance;

public abstract class AbstractController {
    protected final ReadWriteLock _lock = new ReentrantReadWriteLock(true);
    private final Log _log = LogFactory.getLog(this.getClass());
    private ConnectivityManager _connectivityManager;
    private DeltaIndexingManager _diManager;
    private CompoundManager _compoundManager;
    private List<ComponentFactory> _componentFactories;

    public ConnectivityManager getConnectivityManager() {
        return this._connectivityManager;
    }

    public void setConnectivityManager(ConnectivityManager connectivityManager) {
        this._connectivityManager = connectivityManager;
    }

    public void unsetConnectivityManager(ConnectivityManager connectivityManager) {
        if (this._connectivityManager == connectivityManager) {
            this._connectivityManager = null;
        }
    }

    public DeltaIndexingManager getDeltaIndexingManager() {
        return this._diManager;
    }

    public void setDeltaIndexingManager(DeltaIndexingManager diManager) {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)"Binding DeltaIndexingManager");
        }
        this._diManager = diManager;
    }

    public void unsetDeltaIndexingManager(DeltaIndexingManager diManager) {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)"Unbinding DeltaIndexingManager");
        }
        if (this._diManager == diManager) {
            this._diManager = null;
        }
    }

    public CompoundManager getCompoundManager() {
        return this._compoundManager;
    }

    public void setCompoundManager(CompoundManager compoundManager) {
        this._compoundManager = compoundManager;
    }

    public void unsetCompoundManager(CompoundManager compoundManager) {
        if (this._compoundManager == compoundManager) {
            this._compoundManager = null;
        }
    }

    public void addComponentFactory(ComponentFactory factory) {
        if (this._componentFactories == null) {
            this._componentFactories = new ArrayList<ComponentFactory>();
        }
        this._componentFactories.add(factory);
        this._log.debug((Object)("REGISTERED FACTORY: " + factory.toString() + " - " + this.toString()));
    }

    public void removeComponentFactory(ComponentFactory factory) {
        if (this._componentFactories != null) {
            this._componentFactories.remove(factory);
        }
        this._log.debug((Object)("UNREGISTERED FACTORY: " + factory.toString() + " - " + this.toString()));
    }

    protected Collection<String> getAvailableFactories() {
        ArrayList<String> availFactories = new ArrayList<String>();
        if (this._componentFactories != null) {
            for (ComponentFactory cf : this._componentFactories) {
                availFactories.add(this.getFactoryComponentName(cf));
            }
        }
        return availFactories;
    }

    protected <T> T createInstance(Class<T> clazz, String componentId) throws ConnectivityException {
        String msg = "Could not create instance of " + clazz.getName() + " with Id " + componentId + " Perhaps the bundle or the OSGi service is not started.";
        int i = 0;
        while (i < this._componentFactories.size()) {
            block4: {
                ComponentFactory factory = this._componentFactories.get(i);
                try {
                    String factoryId = this.getFactoryComponentName(factory);
                    if (componentId.equals(factoryId)) {
                        ComponentInstance instance = factory.newInstance(null);
                        return (T)instance.getInstance();
                    }
                }
                catch (Exception e) {
                    if (!this._log.isErrorEnabled()) break block4;
                    this._log.error((Object)msg, (Throwable)e);
                }
            }
            ++i;
        }
        throw new ConnectivityException(msg);
    }

    protected DataSourceConnectionConfig getConfiguration(String bundleId, String dataSourceId) throws ConnectivityException {
        if (StringUtils.isBlank((String)dataSourceId)) {
            throw new IllegalArgumentException("DataSourceId cannot be null!");
        }
        String fileName = StringUtils.endsWithIgnoreCase((String)dataSourceId, (String)".xml") ? dataSourceId : String.valueOf(dataSourceId) + ".xml";
        try {
            DataSourceConnectionConfig configuration = ConfigurationLoader.unmarshall((InputStream)ConfigUtils.getConfigStream((String)bundleId, (String)fileName));
            if (!configuration.getDataSourceID().equals(dataSourceId)) {
                throw new RuntimeException(String.format("DataSourceId is case sensitive, %s != %s ! ", dataSourceId, configuration.getDataSourceID()));
            }
            this.checkConfiguration(configuration);
            return configuration;
        }
        catch (Exception e) {
            String msg = "Error loading DataSource with DataSourceId '" + dataSourceId + "'";
            if (this._log.isErrorEnabled()) {
                this._log.error((Object)msg, (Throwable)e);
            }
            throw new ConnectivityException(msg, (Throwable)e);
        }
    }

    protected void checkConfiguration(DataSourceConnectionConfig configuration) throws ConnectivityException {
        List attributes = configuration.getAttributes().getAttribute();
        boolean hasKey = false;
        boolean hasHash = false;
        for (IAttribute iAttribute : attributes) {
            hasKey |= iAttribute.isKeyAttribute();
            hasHash |= iAttribute.isHashAttribute();
        }
        if (!hasKey) {
            throw new ConnectivityException("Data source '" + configuration.getDataSourceID() + "' does not specify key attributes.");
        }
        if (!hasHash) {
            throw new ConnectivityException("Data source '" + configuration.getDataSourceID() + "' does not specify hash attributes.");
        }
    }

    protected Collection<String> getConfigurations(String bundleId, DataConnectionID.DataConnectionType type) {
        ArrayList<String> configFiles = new ArrayList<String>();
        List files = ConfigUtils.getConfigEntries((String)bundleId, (String)"");
        for (String file : files) {
            try {
                DataSourceConnectionConfig configuration = ConfigurationLoader.unmarshall((InputStream)ConfigUtils.getConfigStream((String)bundleId, (String)file));
                if (!type.equals((Object)configuration.getDataConnectionID().getType())) continue;
                configFiles.add(configuration.getDataSourceID());
            }
            catch (Exception e) {
                if (!this._log.isWarnEnabled()) continue;
                this._log.warn((Object)("Error while checking for available '" + type + "' configurations in file " + file + ": " + e.getMessage()));
            }
        }
        return configFiles;
    }

    protected void assertNotEmpty(String parameterValue, String parameterName) {
        if (StringUtils.isEmpty((String)parameterValue)) {
            String msg = "Parameter '" + parameterName + "' is not set or empty.";
            this._log.error((Object)msg);
            throw new IllegalArgumentException(msg);
        }
    }

    public boolean doCheckForUpdate(DeltaIndexingType deltaIndexingType) {
        this.assertDeltaIndexingManager(deltaIndexingType);
        switch (deltaIndexingType) {
            case FULL: {
                return true;
            }
            case ADDITIVE: {
                return true;
            }
            case INITIAL: {
                return false;
            }
            case DISABLED: {
                return false;
            }
        }
        throw new RuntimeException("Unknwon DeltaIndexingType " + deltaIndexingType.toString());
    }

    public boolean doDeltaIndexing(DeltaIndexingType deltaIndexingType) {
        this.assertDeltaIndexingManager(deltaIndexingType);
        switch (deltaIndexingType) {
            case FULL: {
                return true;
            }
            case ADDITIVE: {
                return true;
            }
            case INITIAL: {
                return true;
            }
            case DISABLED: {
                return false;
            }
        }
        throw new RuntimeException("Unknwon DeltaIndexingType " + deltaIndexingType.toString());
    }

    public boolean doDeltaDelete(DeltaIndexingType deltaIndexingType) {
        this.assertDeltaIndexingManager(deltaIndexingType);
        switch (deltaIndexingType) {
            case FULL: {
                return true;
            }
            case ADDITIVE: {
                return false;
            }
            case INITIAL: {
                return false;
            }
            case DISABLED: {
                return false;
            }
        }
        throw new RuntimeException("Unknwon DeltaIndexingType " + deltaIndexingType.toString());
    }

    private void assertDeltaIndexingManager(DeltaIndexingType deltaIndexingType) {
        if (this._diManager == null && !DeltaIndexingType.DISABLED.equals((Object)deltaIndexingType)) {
            throw new RuntimeException("No DeltaIndexingManager is bound. Only valid DeltaIndexingType is " + DeltaIndexingType.DISABLED);
        }
    }

    private String getFactoryComponentName(ComponentFactory factory) {
        String factoryName = factory.toString();
        if (factoryName != null) {
            return factoryName.substring(factoryName.lastIndexOf(" ") + 1, factoryName.length());
        }
        return null;
    }
}

