/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.management.jmx.client.cmd.task.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.management.jmx.client.cmd.task.Task;
import org.eclipse.smila.management.jmx.client.config.OperationType;
import org.eclipse.smila.management.jmx.client.config.ParameterType;
import org.eclipse.smila.management.jmx.client.exceptions.JmxInvocationException;
import org.eclipse.smila.management.jmx.client.exceptions.OperationException;
import org.eclipse.smila.management.jmx.client.helpers.ConversionHelper;
import org.eclipse.smila.management.jmx.client.helpers.JmxConnection;
import org.eclipse.smila.management.jmx.client.helpers.OutWriter;
import org.eclipse.smila.management.jmx.client.helpers.ParameterFormatHelper;

public class OperationTask
implements Task<OperationType> {
    private final Log _log = LogFactory.getLog(this.getClass());

    @Override
    public Object execute(OperationType config, JmxConnection connection, Object globalResult, String[] parameters, Object localResult) throws OperationException {
        Object newLocalResult;
        int operationParamatersLength;
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)ParameterFormatHelper.format(config.getEcho(), globalResult, parameters, localResult));
        }
        if ((operationParamatersLength = config.getParameter().size()) > parameters.length) {
            throw new IllegalArgumentException(String.format("Operation parameters are not matched, it's required %d parameters, but is was passed %d", operationParamatersLength, parameters.length));
        }
        String[] signature = new String[operationParamatersLength];
        Object[] arguments = new Object[operationParamatersLength];
        int i = 0;
        while (i < operationParamatersLength) {
            ParameterType parameterConfig = config.getParameter().get(i);
            signature[i] = parameterConfig.getClazz();
            if (parameterConfig.getValue() != null) {
                arguments[i] = ConversionHelper.convert(parameterConfig.getValue(), parameterConfig.getClazz());
            } else if (parameterConfig.getArgument() != null) {
                int source = parameterConfig.getArgument();
                if (source == 0) {
                    arguments[i] = globalResult;
                } else {
                    if (parameters.length < source) {
                        throw new IllegalArgumentException();
                    }
                    arguments[i] = ConversionHelper.convert(parameters[source - 1], parameterConfig.getClazz());
                }
            } else {
                arguments[i] = ConversionHelper.convert(parameters[i], parameterConfig.getClazz());
            }
            ++i;
        }
        try {
            newLocalResult = connection.invoke(ParameterFormatHelper.format(config.getDomain(), globalResult, parameters, localResult), ParameterFormatHelper.format(config.getKey(), globalResult, parameters, localResult), ParameterFormatHelper.format(config.getName(), globalResult, parameters, localResult), arguments, signature);
        }
        catch (JmxInvocationException e) {
            throw new OperationException(e);
        }
        if (config.isVoidType()) {
            OutWriter.write(ParameterFormatHelper.format(config.getEcho(), globalResult, parameters, localResult), this._log);
        } else {
            OutWriter.write(ParameterFormatHelper.format(config.getEcho(), globalResult, parameters, localResult), newLocalResult, this._log);
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)"JMX operation successfully invoked");
        }
        return newLocalResult;
    }
}

