/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.http.server.json;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.http.server.HttpExchange;
import org.eclipse.smila.http.server.json.JsonHttpUtils;
import org.eclipse.smila.http.server.util.ARequestHandler;
import org.eclipse.smila.http.server.util.UnsupportedMethodException;
import org.eclipse.smila.ipc.IpcException;

public abstract class JsonBulkRequestHandler
extends ARequestHandler {
    protected static final DataFactory FACTORY = DataFactory.DEFAULT;
    private final Log _log = LogFactory.getLog(this.getClass());
    private String _requestHost = "";

    public abstract void process(String var1, String var2, Record var3) throws Exception;

    public abstract Object finish(String var1, String var2) throws Exception;

    public abstract void start(String var1, String var2) throws Exception;

    public abstract void end(String var1, String var2) throws Exception;

    @Override
    public void handle(HttpExchange exchange) {
        boolean closeConnection = false;
        Object resultObject = null;
        String method = exchange.getRequestMethod();
        String requestUri = exchange.getRequestURI();
        String headerHost = exchange.getRequestHeader("Host");
        if (headerHost != null) {
            this._requestHost = headerHost;
        }
        try {
            if (!this.isValidMethod(method, requestUri)) {
                throw new UnsupportedMethodException("Unsupported http method '" + method + "'");
            }
            String encoding = exchange.getCharacterEncoding();
            if (encoding != null && !"UTF-8".equalsIgnoreCase(encoding)) {
                throw new IpcException("Unsupported character encoding '" + encoding + "'. UTF-8 is required");
            }
            InputStream postDataStream = exchange.getRequestStream();
            resultObject = this.handlePostStream(method, requestUri, postDataStream);
        }
        catch (Throwable error) {
            this._log.error((Object)("Error processing " + method + " " + requestUri), error);
            closeConnection = this.writeErrorResult(exchange, error);
            try {
                if (closeConnection) {
                    IOUtils.closeQuietly((OutputStream)exchange.getResponseStream());
                } else {
                    exchange.getResponseStream().flush();
                }
            }
            catch (Exception exception) {}
            return;
        }
        try {
            try {
                closeConnection = this.writeSuccessResult(exchange, resultObject);
            }
            catch (IOException ex) {
                this._log.error((Object)"Error writing the response. Maybe client has closed the connection.", (Throwable)ex);
                closeConnection = true;
                try {
                    if (closeConnection) {
                        IOUtils.closeQuietly((OutputStream)exchange.getResponseStream());
                    }
                    exchange.getResponseStream().flush();
                }
                catch (Exception exception) {}
            }
        }
        catch (Throwable throwable) {
            try {
                if (closeConnection) {
                    IOUtils.closeQuietly((OutputStream)exchange.getResponseStream());
                } else {
                    exchange.getResponseStream().flush();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (closeConnection) {
                IOUtils.closeQuietly((OutputStream)exchange.getResponseStream());
            } else {
                exchange.getResponseStream().flush();
            }
        }
        catch (Exception exception) {}
    }

    private Object handlePostStream(String method, String requestUri, InputStream postDataStream) throws Exception {
        this.start(method, requestUri);
        BufferedReader reader = new BufferedReader(new InputStreamReader(postDataStream, "UTF8"));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                Record record = JsonHttpUtils.SERIALIZATION_UTILS.jsonObject2record(line);
                this.process(method, requestUri, record);
            }
            Object object = this.finish(method, requestUri);
            return object;
        }
        finally {
            this.end(method, requestUri);
        }
    }

    protected boolean isValidMethod(String method, String requestUri) {
        return "POST".equals(method);
    }

    protected boolean writeSuccessResult(HttpExchange exchange, Object resultObject) throws IOException {
        int statusCode = this.getSuccessStatus(exchange.getRequestMethod(), exchange.getRequestURI(), resultObject);
        boolean closeConnection = JsonHttpUtils.prepareResponseHeader(exchange, statusCode, resultObject != null);
        this.writeResultObject(exchange.getResponseStream(), resultObject);
        return closeConnection;
    }

    protected int getSuccessStatus(String method, String requestUri, Object resultObject) {
        return 202;
    }

    protected void writeResultObject(OutputStream responseStream, Object resultObject) throws IOException {
        JsonHttpUtils.writeResultObject(responseStream, resultObject);
    }

    protected boolean writeErrorResult(HttpExchange exchange, Throwable error) throws IOException {
        int errorCode = this.getErrorStatus(exchange.getRequestMethod(), exchange.getRequestMethod(), error);
        boolean writeErrorDetails = !"HEAD".equals(exchange.getRequestMethod());
        boolean closeConnection = JsonHttpUtils.prepareResponseHeader(exchange, errorCode, writeErrorDetails);
        if (writeErrorDetails) {
            JsonHttpUtils.writeErrorDetails(exchange, error);
        }
        return closeConnection;
    }

    protected int getErrorStatus(String method, String requestUri, Throwable ex) {
        return JsonHttpUtils.getErrorStatus(ex);
    }

    protected String getRequestHost() {
        return this._requestHost;
    }
}

