/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.http.server.json;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.util.Enumeration;
import org.apache.commons.io.IOUtils;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.datamodel.ValueFormatHelper;
import org.eclipse.smila.datamodel.ipc.IpcSerializationUtils;
import org.eclipse.smila.http.server.HttpExchange;
import org.eclipse.smila.http.server.util.UnsupportedMethodException;
import org.eclipse.smila.ipc.IpcException;
import org.eclipse.smila.ipc.IpcStreamWriter;
import org.eclipse.smila.ipc.json.JsonFactory;
import org.eclipse.smila.ipc.json.JsonStreamWriter;
import org.eclipse.smila.utils.http.NotFoundHTTPResult;

public final class JsonHttpUtils {
    public static final IpcSerializationUtils SERIALIZATION_UTILS = new IpcSerializationUtils();

    private JsonHttpUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Record convertRequest(HttpExchange exchange) throws IpcException {
        Record inputRecord = null;
        if (!JsonHttpUtils.hasRequestContent(exchange)) return JsonHttpUtils.convertGetRequest(exchange);
        String encoding = exchange.getCharacterEncoding();
        if (encoding == null) return JsonHttpUtils.convertPostRequest(exchange);
        if (!"UTF-8".equalsIgnoreCase(encoding)) throw new IpcException("Unsupported character encoding '" + encoding + "'. UTF-8 is required");
        return JsonHttpUtils.convertPostRequest(exchange);
    }

    public static Record convertGetRequest(HttpExchange he) throws IpcException {
        String httpQueryString = he.getQueryString();
        if (httpQueryString == null || httpQueryString.trim().length() == 0) {
            return null;
        }
        try {
            Record record = DataFactory.DEFAULT.createRecord();
            Enumeration<String> paramNames = he.getParameterNames();
            while (paramNames.hasMoreElements()) {
                String parameter = paramNames.nextElement();
                String[] values = he.getParameterValues(parameter);
                if (values.length == 1) {
                    record.getMetadata().put(parameter, (Any)JsonHttpUtils.parseValue(values[0]));
                    continue;
                }
                String[] stringArray = values;
                int n = values.length;
                int n2 = 0;
                while (n2 < n) {
                    String value = stringArray[n2];
                    record.getMetadata().add(parameter, (Any)JsonHttpUtils.parseValue(value));
                    ++n2;
                }
            }
            return record;
        }
        catch (Exception e) {
            throw new IpcException("Error parsing GET request", (Throwable)e);
        }
    }

    public static Record convertPostRequest(HttpExchange he) throws IpcException {
        InputStream in = null;
        String requestMethod = he.getRequestMethod();
        try {
            in = he.getRequestStream();
            Record record = SERIALIZATION_UTILS.jsonStream2record(in);
            return record;
        }
        catch (Exception e) {
            throw new IpcException("Error parsing JSON object in " + requestMethod + " request", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    public static boolean hasRequestContent(HttpExchange exchange) {
        String contentLength = exchange.getRequestHeader("Content-Length");
        if (contentLength != null) {
            long length = Long.parseLong(contentLength);
            return length > 0L;
        }
        String transferEnc = exchange.getRequestHeader("Transfer-Encoding");
        if (transferEnc != null) {
            return "chunked".equalsIgnoreCase(transferEnc);
        }
        return false;
    }

    private static Value parseValue(String value) {
        try {
            long longValue = Long.parseLong(value);
            return DataFactory.DEFAULT.createLongValue(Long.valueOf(longValue));
        }
        catch (NumberFormatException numberFormatException) {
            try {
                double doubleValue = Double.parseDouble(value);
                return DataFactory.DEFAULT.createDoubleValue(Double.valueOf(doubleValue));
            }
            catch (NumberFormatException numberFormatException2) {
                if ("true".equalsIgnoreCase(value.trim())) {
                    return DataFactory.DEFAULT.createBooleanValue(Boolean.valueOf(true));
                }
                if ("false".equalsIgnoreCase(value.trim())) {
                    return DataFactory.DEFAULT.createBooleanValue(Boolean.valueOf(false));
                }
                return DataFactory.DEFAULT.createStringValue(value);
            }
        }
    }

    public static boolean prepareResponseHeader(HttpExchange exchange, int statusCode, boolean hasResponseBody) {
        boolean closeConnection = false;
        exchange.setResponseStatus(statusCode);
        String connectionHeader = exchange.getRequestHeader("Connection");
        if (connectionHeader != null && connectionHeader.equals("close")) {
            closeConnection = true;
            exchange.setResponseHeader("Connection", "close");
        } else {
            exchange.setResponseHeader("Connection", "keep-alive");
            exchange.setResponseHeader("Keep-Alive", "timeout=0");
        }
        if (hasResponseBody && statusCode != 204) {
            exchange.setResponseHeader("Content-Type", "application/json; charset=utf-8");
            exchange.setResponseHeader("Transfer-Encoding", "chunked");
        } else {
            exchange.setResponseHeader("Content-Length", "0");
        }
        return closeConnection;
    }

    public static void writeResultObject(OutputStream responseStream, Object resultObject) throws IOException {
        if (resultObject instanceof Record) {
            Record resultRecord = (Record)resultObject;
            SERIALIZATION_UTILS.record2JsonStream(responseStream, resultRecord);
        } else if (resultObject instanceof Any) {
            Any resultAny = (Any)resultObject;
            SERIALIZATION_UTILS.any2JsonStream(responseStream, resultAny);
        } else if (resultObject != null) {
            ObjectMapper mapper = JsonHttpUtils.getObjectMapper();
            mapper.writeValue(responseStream, resultObject);
        }
    }

    public static int getErrorStatus(Throwable ex) {
        if (ex instanceof UnsupportedMethodException) {
            return 405;
        }
        if (ex instanceof IpcException || ex instanceof IllegalArgumentException) {
            return 400;
        }
        if (ex instanceof NotFoundHTTPResult || ex.getCause() instanceof NotFoundHTTPResult) {
            return 404;
        }
        if (ex instanceof HttpException) {
            return ((HttpException)ex).getStatus();
        }
        return 500;
    }

    public static void writeErrorDetails(HttpExchange exchange, Throwable error) throws IOException {
        JsonFactory jsonFactory = new JsonFactory();
        JsonStreamWriter jsonWriter = jsonFactory.newStreamWriter(exchange.getResponseStream());
        if (error instanceof IpcException) {
            ((IpcException)error).write((IpcStreamWriter)jsonWriter);
        } else if (error instanceof HttpException) {
            new IpcException(((HttpException)error).getReason(), error.getCause()).write((IpcStreamWriter)jsonWriter);
        } else {
            IpcException.write((IpcStreamWriter)jsonWriter, (Throwable)error);
        }
    }

    public static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.getJsonFactory().disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        objectMapper.configure(SerializationConfig.Feature.INDENT_OUTPUT, true);
        objectMapper.getSerializationConfig().setDateFormat((DateFormat)ValueFormatHelper.getDefaultDateTimeFormat());
        return objectMapper;
    }
}

