/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.utils.param.def;

import org.eclipse.smila.search.utils.param.ParameterException;
import org.eclipse.smila.search.utils.param.def.DEnumeration;
import org.eclipse.smila.search.utils.param.def.DParameter;
import org.eclipse.smila.search.utils.param.def.DParameterCodec;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class DEnumerationCodec {
    private DEnumerationCodec() {
    }

    public static DParameter decode(Element element) throws ParameterException {
        DEnumeration dParameter = new DEnumeration();
        NodeList nl = element.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node node = nl.item(i);
            Node textElement = node.getFirstChild();
            String text = null;
            if (textElement != null) {
                text = textElement.getNodeValue();
            }
            if ("Default".equals(node.getLocalName())) {
                dParameter.addDefault(text == null ? "" : text);
            }
            if ("Value".equals(node.getLocalName())) {
                dParameter.addValue(text == null ? "" : text);
            }
            if ("AllowMultiple".equals(node.getLocalName())) {
                dParameter.setAllowMultiple(Boolean.valueOf(text));
            }
            ++i;
        }
        return dParameter;
    }

    public static Element encode(DEnumeration dParameter, Element element) throws ParameterException {
        Element e;
        String value;
        int i;
        Document doc = element.getOwnerDocument();
        Element el = doc.createElementNS("http://www.brox.de/ParameterDefinition", "Parameter");
        DParameterCodec.encodeStandardValues(dParameter, el, doc);
        if (dParameter.hasDefault()) {
            String[] defaults = dParameter.getDefaults();
            i = 0;
            while (i < defaults.length) {
                value = defaults[i];
                e = doc.createElementNS("http://www.brox.de/ParameterDefinition", "Default");
                e.appendChild(doc.createTextNode(value));
                el.appendChild(e);
                ++i;
            }
        }
        String[] values = dParameter.getValues();
        i = 0;
        while (i < values.length) {
            value = values[i];
            e = doc.createElementNS("http://www.brox.de/ParameterDefinition", "Value");
            e.appendChild(doc.createTextNode(value));
            el.appendChild(e);
            ++i;
        }
        if (dParameter.isAllowMultiple()) {
            Element e2 = doc.createElementNS("http://www.brox.de/ParameterDefinition", "AllowMultiple");
            e2.appendChild(doc.createTextNode(String.valueOf(dParameter.isAllowMultiple())));
            el.appendChild(e2);
        }
        element.appendChild(el);
        return el;
    }
}

