/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.utils.search;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.smila.search.utils.search.DSearchException;
import org.eclipse.smila.search.utils.search.IDFParameter;
import org.eclipse.smila.search.utils.search.INFParameter;
import org.eclipse.smila.search.utils.search.ITFParameter;

public abstract class SearchAccess {
    public static final String EXTENSION_POINT_NAME_SEARCH_ACCESS = "org.eclipse.smila.search.utils.search.access";
    private static SearchAccess[] s_cachedSearchAccess;

    public static SearchAccess getInstance() {
        SearchAccess[] types;
        block5: {
            Log log = LogFactory.getLog(SearchAccess.class);
            try {
                types = SearchAccess.getTypes();
                if (types.length == 1) break block5;
                if (log.isWarnEnabled()) {
                    log.warn((Object)("invalid index structure access count [" + types.length + "]"));
                }
                return null;
            }
            catch (DSearchException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)e);
                }
                return null;
            }
        }
        return types[0];
    }

    public static SearchAccess[] getTypes() throws DSearchException {
        if (s_cachedSearchAccess != null) {
            return s_cachedSearchAccess;
        }
        Log log = LogFactory.getLog(SearchAccess.class);
        ArrayList<SearchAccess> found = new ArrayList<SearchAccess>();
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT_NAME_SEARCH_ACCESS).getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] configElements = extension.getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                IConfigurationElement configurationElement = configElements[j];
                SearchAccess.parseType(configurationElement, found.size());
                SearchAccess clazz = null;
                try {
                    Object obj = configurationElement.createExecutableExtension("Clazz");
                    clazz = (SearchAccess)obj;
                }
                catch (Exception exception) {
                    if (log.isErrorEnabled()) {
                        if (configurationElement != null) {
                            log.error((Object)"Failed to instantiate search access");
                        } else {
                            log.error((Object)"Unknown!");
                        }
                    }
                    throw new DSearchException("unable to load search access", exception);
                }
                if (clazz != null) {
                    found.add(clazz);
                }
                ++j;
            }
            ++i;
        }
        s_cachedSearchAccess = found.toArray(new SearchAccess[0]);
        return s_cachedSearchAccess;
    }

    public static String parseType(IConfigurationElement configurationElement, int ordinal) {
        if (!configurationElement.getName().equals("SearchAccess")) {
            return null;
        }
        Log log = LogFactory.getLog(SearchAccess.class);
        try {
            String name = configurationElement.getAttribute("Clazz");
            if (name == null) {
                name = "[missing attribute name]";
            }
            return name;
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                String name = configurationElement.getAttribute("Clazz");
                if (name == null) {
                    name = "[missing attribute name]";
                }
                String msg = "Failed to load search type named " + name + " in " + configurationElement.getDeclaringExtension().getNamespaceIdentifier();
                log.error((Object)msg, (Throwable)e);
            }
            return null;
        }
    }

    public abstract Class getCodecClass(IDFParameter var1);

    public abstract Class getCodecClass(INFParameter var1);

    public abstract Class getCodecClass(ITFParameter var1);

    public abstract Class getCodecClass(String var1) throws ClassNotFoundException;
}

