/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.datamodel.impl;

import java.io.Serializable;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.InvalidValueTypeException;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.datamodel.impl.DefaultDataFactoryImpl;

public abstract class AbstractAny
implements Any,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final Any.ValueType _valueType;

    protected AbstractAny(Any.ValueType valueType) {
        this._valueType = valueType;
    }

    @Override
    public Any.ValueType getValueType() {
        return this._valueType;
    }

    @Override
    public boolean isMap() {
        return this._valueType == Any.ValueType.MAP;
    }

    @Override
    public boolean isSeq() {
        return this._valueType == Any.ValueType.SEQ;
    }

    @Override
    public boolean isValue() {
        return this._valueType != Any.ValueType.MAP && this._valueType != Any.ValueType.SEQ;
    }

    @Override
    public boolean isString() {
        return this._valueType == Any.ValueType.STRING;
    }

    @Override
    public boolean isDouble() {
        return this._valueType == Any.ValueType.DOUBLE;
    }

    @Override
    public boolean isBoolean() {
        return this._valueType == Any.ValueType.BOOLEAN;
    }

    @Override
    public boolean isLong() {
        return this._valueType == Any.ValueType.LONG;
    }

    @Override
    public boolean isDate() {
        return this._valueType == Any.ValueType.DATE;
    }

    @Override
    public boolean isDateTime() {
        return this._valueType == Any.ValueType.DATETIME;
    }

    @Override
    public boolean isNumber() {
        return this._valueType == Any.ValueType.LONG || this._valueType == Any.ValueType.DOUBLE;
    }

    @Override
    public DataFactory getFactory() {
        return DefaultDataFactoryImpl.INSTANCE;
    }

    @Override
    public Value asValue() {
        throw new InvalidValueTypeException(String.format("cannot return a %s as a Value", new Object[]{this._valueType}));
    }

    @Override
    public AnyMap asMap() {
        throw new InvalidValueTypeException(String.format("cannot return a %s as a %s", new Object[]{this._valueType, Any.ValueType.MAP}));
    }

    @Override
    public AnySeq asSeq() {
        throw new InvalidValueTypeException(String.format("cannot return a %s as a %s", new Object[]{this._valueType, Any.ValueType.SEQ}));
    }
}

