/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.taskworker.output;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.smila.objectstore.ObjectStoreException;
import org.eclipse.smila.objectstore.ObjectStoreService;
import org.eclipse.smila.taskmanager.BulkInfo;
import org.eclipse.smila.taskworker.Counters;
import org.eclipse.smila.taskworker.io.IODataObject;
import org.eclipse.smila.taskworker.io.IODataObjects;
import org.eclipse.smila.taskworker.output.Output;
import org.eclipse.smila.taskworker.output.RecordOutput;
import org.eclipse.smila.taskworker.output.StreamOutput;

public class Outputs
extends IODataObjects {
    private long _durationCommit;

    public Outputs(Map<String, List<BulkInfo>> dataObjects, ObjectStoreService objectStore) {
        super(dataObjects, objectStore);
    }

    public <T extends Output> T getAsOutput(String slotName, Class<T> inputClass) {
        return this.getAsOutput(slotName, 0, inputClass);
    }

    public <T extends Output> T getAsOutput(String slotName, int index, Class<T> outputClass) {
        if (this.canCreate(slotName, index)) {
            BulkInfo dataObject = this.getDataObject(slotName, index);
            try {
                Constructor<T> outputConstructor = outputClass.getConstructor(BulkInfo.class, ObjectStoreService.class);
                Output output = (Output)outputConstructor.newInstance(dataObject, this.getObjectStore());
                this.putIOData(slotName, index, output);
                return (T)output;
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Canot create instance of class " + outputClass, ex);
            }
        }
        return null;
    }

    public StreamOutput getAsStreamOutput(String slotName, int index) {
        return this.getAsOutput(slotName, index, StreamOutput.class);
    }

    public StreamOutput getAsStreamOutput(String slotName) {
        return this.getAsStreamOutput(slotName, 0);
    }

    public RecordOutput getAsRecordOutput(String slotName, int index) {
        return this.getAsOutput(slotName, index, RecordOutput.class);
    }

    public RecordOutput getAsRecordOutput(String slotName) {
        return this.getAsRecordOutput(slotName, 0);
    }

    public void commitAll() throws ObjectStoreException, IOException {
        Iterator<IODataObject[]> iterator = this.getIOData().values().iterator();
        while (iterator.hasNext()) {
            IODataObject[] outputs;
            IODataObject[] iODataObjectArray = outputs = iterator.next();
            int n = outputs.length;
            int n2 = 0;
            while (n2 < n) {
                IODataObject output = iODataObjectArray[n2];
                if (output != null) {
                    long startTime = System.nanoTime();
                    ((Output)output).commit();
                    this._durationCommit += System.nanoTime() - startTime;
                }
                ++n2;
            }
        }
    }

    public void abortAll() throws ObjectStoreException, IOException {
        Iterator<IODataObject[]> iterator = this.getIOData().values().iterator();
        while (iterator.hasNext()) {
            IODataObject[] outputs;
            IODataObject[] iODataObjectArray = outputs = iterator.next();
            int n = outputs.length;
            int n2 = 0;
            while (n2 < n) {
                IODataObject output = iODataObjectArray[n2];
                if (output != null) {
                    long startTime = System.nanoTime();
                    ((Output)output).abort();
                    this._durationCommit += System.nanoTime() - startTime;
                }
                ++n2;
            }
        }
    }

    public void addOutputCounters(Map<String, Number> counters) {
        if (this._durationCommit > 0L) {
            Counters.addDuration(counters, "duration.iodata.close", this._durationCommit);
        }
        this.addCounters(counters, "output");
    }
}

