/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.api.helper;

import org.apache.commons.lang.NullArgumentException;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.search.api.helper.ResultAccessor;

public class ResultBuilder
extends ResultAccessor {
    public ResultBuilder(String workflowName, Record result) {
        super(workflowName, result);
        this._result.getMetadata().getSeq("records", true);
    }

    public AnyMap addResultItem(String id, Double score) {
        AnyMap resultItem = this.getResultRecords().getFactory().createAnyMap();
        this.getResultRecords().add((Object)resultItem);
        resultItem.put("_recordid", id);
        resultItem.put("_weight", (Number)score);
        return resultItem;
    }

    public void setCount(Long count) {
        this._result.getMetadata().put("count", (Number)count);
    }

    public void setRuntime(Long millis) {
        this._result.getMetadata().put("runtime", (Number)millis);
    }

    public AnySeq addGroup(String groupName) {
        AnyMap groups = this._result.getMetadata().getMap("groups", true);
        return groups.getSeq(groupName, true);
    }

    public AnyMap addGroupValue(AnySeq group, Any value, Long count) {
        if (group == null) {
            throw new NullArgumentException("group must not be null");
        }
        if (value == null) {
            throw new NullArgumentException("value must not be null");
        }
        AnyMap groupValue = group.getFactory().createAnyMap();
        groupValue.put("value", value);
        if (count != null) {
            groupValue.put("count", (Number)count);
        }
        group.add((Object)groupValue);
        return groupValue;
    }

    public AnyMap addGroupValue(AnySeq group, Object value, Long count) {
        Value autoConvertValue = group.getFactory().autoConvertValue(value);
        return this.addGroupValue(group, (Any)autoConvertValue, count);
    }
}

