/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Iterator;
import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColPermsDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TablePermsDescriptor;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.dictionary.ViewDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.PrivilegeInfo;

public class TablePrivilegeInfo
extends PrivilegeInfo {
    public static final int SELECT_ACTION = 0;
    public static final int DELETE_ACTION = 1;
    public static final int INSERT_ACTION = 2;
    public static final int UPDATE_ACTION = 3;
    public static final int REFERENCES_ACTION = 4;
    public static final int TRIGGER_ACTION = 5;
    public static final int ACTION_COUNT = 6;
    private static final String YES_WITH_GRANT_OPTION = "Y";
    private static final String YES_WITHOUT_GRANT_OPTION = "y";
    private static final String NO = "N";
    private static final String[][] actionString = new String[][]{{"s", "S"}, {"d", "D"}, {"i", "I"}, {"u", "U"}, {"r", "R"}, {"t", "T"}};
    private TableDescriptor td;
    private boolean[] actionAllowed;
    private FormatableBitSet[] columnBitSets;
    private List descriptorList;

    public TablePrivilegeInfo(TableDescriptor tableDescriptor, boolean[] blArray, FormatableBitSet[] formatableBitSetArray, List list) {
        this.actionAllowed = blArray;
        this.columnBitSets = formatableBitSetArray;
        this.td = tableDescriptor;
        this.descriptorList = list;
    }

    protected void checkOwnership(String string, TableDescriptor tableDescriptor, SchemaDescriptor schemaDescriptor, DataDictionary dataDictionary, LanguageConnectionContext languageConnectionContext, boolean bl) throws StandardException {
        super.checkOwnership(string, tableDescriptor, schemaDescriptor, dataDictionary);
        if (bl) {
            this.checkPrivileges(string, tableDescriptor, schemaDescriptor, dataDictionary, languageConnectionContext);
        }
    }

    private void checkPrivileges(String string, TableDescriptor tableDescriptor, SchemaDescriptor schemaDescriptor, DataDictionary dataDictionary, LanguageConnectionContext languageConnectionContext) throws StandardException {
        if (string.equals(dataDictionary.getAuthorizationDatabaseOwner())) {
            return;
        }
        if (tableDescriptor.getTableType() == 2 && this.descriptorList != null) {
            TransactionController transactionController = languageConnectionContext.getTransactionExecute();
            int n = this.descriptorList.size();
            for (int i = 0; i < n; ++i) {
                TupleDescriptor tupleDescriptor;
                SchemaDescriptor schemaDescriptor2 = null;
                TupleDescriptor tupleDescriptor2 = (TupleDescriptor)this.descriptorList.get(i);
                if (tupleDescriptor2 instanceof TableDescriptor) {
                    tupleDescriptor = (TableDescriptor)tupleDescriptor2;
                    schemaDescriptor2 = ((TableDescriptor)tupleDescriptor).getSchemaDescriptor();
                } else if (tupleDescriptor2 instanceof ViewDescriptor) {
                    tupleDescriptor = (ViewDescriptor)tupleDescriptor2;
                    schemaDescriptor2 = dataDictionary.getSchemaDescriptor(((ViewDescriptor)tupleDescriptor).getCompSchemaId(), transactionController);
                } else if (tupleDescriptor2 instanceof AliasDescriptor) {
                    tupleDescriptor = (AliasDescriptor)tupleDescriptor2;
                    schemaDescriptor2 = dataDictionary.getSchemaDescriptor(((AliasDescriptor)tupleDescriptor).getSchemaUUID(), transactionController);
                }
                if (schemaDescriptor2 == null || string.equals(schemaDescriptor2.getAuthorizationId())) continue;
                throw StandardException.newException("4250A", string, (Object)"grant", (Object)schemaDescriptor.getSchemaName(), (Object)tableDescriptor.getName());
            }
        }
    }

    public void executeGrantRevoke(Activation activation, boolean bl, List list) throws StandardException {
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        String string = languageConnectionContext.getAuthorizationId();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        SchemaDescriptor schemaDescriptor = this.td.getSchemaDescriptor();
        this.checkOwnership(string, this.td, schemaDescriptor, dataDictionary, languageConnectionContext, bl);
        DataDescriptorGenerator dataDescriptorGenerator = dataDictionary.getDataDescriptorGenerator();
        TablePermsDescriptor tablePermsDescriptor = dataDescriptorGenerator.newTablePermsDescriptor(this.td, this.getPermString(0, false), this.getPermString(1, false), this.getPermString(2, false), this.getPermString(3, false), this.getPermString(4, false), this.getPermString(5, false), string);
        ColPermsDescriptor[] colPermsDescriptorArray = new ColPermsDescriptor[this.columnBitSets.length];
        for (int i = 0; i < this.columnBitSets.length; ++i) {
            if (this.columnBitSets[i] == null && (bl || !this.hasColumnPermissions(i) || !this.actionAllowed[i])) continue;
            colPermsDescriptorArray[i] = dataDescriptorGenerator.newColPermsDescriptor(this.td, this.getActionString(i, false), this.columnBitSets[i], string);
        }
        dataDictionary.startWriting(languageConnectionContext);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            boolean bl2 = false;
            String string2 = (String)iterator.next();
            if (tablePermsDescriptor != null && dataDictionary.addRemovePermissionsDescriptor(bl, tablePermsDescriptor, string2, transactionController)) {
                bl2 = true;
                dataDictionary.getDependencyManager().invalidateFor(tablePermsDescriptor, 44, languageConnectionContext);
                dataDictionary.getDependencyManager().invalidateFor(this.td, 23, languageConnectionContext);
            }
            for (int i = 0; i < this.columnBitSets.length; ++i) {
                if (colPermsDescriptorArray[i] == null || !dataDictionary.addRemovePermissionsDescriptor(bl, colPermsDescriptorArray[i], string2, transactionController)) continue;
                bl2 = true;
                dataDictionary.getDependencyManager().invalidateFor(colPermsDescriptorArray[i], 44, languageConnectionContext);
                dataDictionary.getDependencyManager().invalidateFor(this.td, 23, languageConnectionContext);
            }
            this.addWarningIfPrivilegeNotRevoked(activation, bl, bl2, string2);
        }
    }

    private String getPermString(int n, boolean bl) {
        if (this.actionAllowed[n] && this.columnBitSets[n] == null) {
            return bl ? YES_WITH_GRANT_OPTION : YES_WITHOUT_GRANT_OPTION;
        }
        return NO;
    }

    private String getActionString(int n, boolean bl) {
        return actionString[n][bl ? 1 : 0];
    }

    private boolean hasColumnPermissions(int n) {
        return n == 0 || n == 3 || n == 4;
    }
}

