/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.framework.util.internal;

import java.util.Map;
import org.eclipse.smila.connectivity.ConnectivityId;
import org.eclipse.smila.connectivity.framework.CrawlerCallback;
import org.eclipse.smila.connectivity.framework.CrawlerCriticalException;
import org.eclipse.smila.connectivity.framework.CrawlerException;
import org.eclipse.smila.connectivity.framework.DataReference;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;

public class DataReferenceImpl
implements DataReference {
    private final ConnectivityId _id;
    private final String _hash;
    private final CrawlerCallback _callback;

    @Deprecated
    public DataReferenceImpl(CrawlerCallback callback, String sourceId, String id, String hash) {
        if (callback == null) {
            throw new IllegalArgumentException("Parameter callback must not be null");
        }
        if (id == null) {
            throw new IllegalArgumentException("Parameter id must not be null");
        }
        if (hash == null) {
            throw new IllegalArgumentException("Parameter hash must not be null");
        }
        this._callback = callback;
        this._id = new ConnectivityId(sourceId, id);
        this._hash = hash;
    }

    public DataReferenceImpl(CrawlerCallback callback, ConnectivityId id, String hash) {
        if (callback == null) {
            throw new IllegalArgumentException("Parameter callback must not be null");
        }
        if (id == null) {
            throw new IllegalArgumentException("Parameter id must not be null");
        }
        if (hash == null) {
            throw new IllegalArgumentException("Parameter hash must not be null");
        }
        this._callback = callback;
        this._id = id;
        this._hash = hash;
    }

    @Override
    public ConnectivityId getId() {
        return this._id;
    }

    @Override
    public String getHash() {
        return this._hash;
    }

    @Override
    public Record getRecord() throws CrawlerException, CrawlerCriticalException {
        String[] attachmenNames;
        Record record = DataFactory.DEFAULT.createRecord();
        record.setId(this._id.getObjectId());
        record.setSource(this._id.getDataSourceId());
        record.getMetadata().putAll((Map)this._callback.getMetadata(this._id));
        String[] stringArray = attachmenNames = this._callback.getAttachmentNames(this._id);
        int n = attachmenNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            record.setAttachment(name, this._callback.getAttachment(this._id, name));
            ++n2;
        }
        return record;
    }

    @Override
    public void dispose() {
        this._callback.dispose(this._id);
    }
}

