/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.lucene;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.search.index.IndexConnection;
import org.eclipse.smila.search.index.IndexException;
import org.eclipse.smila.search.lucene.messages.advsearch.DOP1;
import org.eclipse.smila.search.lucene.messages.advsearch.DOPN;
import org.eclipse.smila.search.lucene.messages.advsearch.DQueryExpression;
import org.eclipse.smila.search.lucene.messages.advsearch.DTemplateField;
import org.eclipse.smila.search.lucene.messages.advsearch.DTerm;
import org.eclipse.smila.search.lucene.messages.advsearch.DTextTemplateField;
import org.eclipse.smila.search.lucene.messages.advsearch.DWMEAN;
import org.eclipse.smila.search.lucene.tools.search.lucene.DTextFieldParameter;
import org.eclipse.smila.search.plugin.ITemplateAccess;
import org.eclipse.smila.search.templates.NodeTransformer;
import org.eclipse.smila.search.templates.NodeTransformerException;
import org.eclipse.smila.search.templates.NodeTransformerRegistryController;
import org.eclipse.smila.search.templates.TemplateException;
import org.eclipse.smila.search.templates.messages.fieldtemplates.DFieldTemplate;
import org.eclipse.smila.search.templates.messages.searchtemplates.DTemplate;
import org.eclipse.smila.search.utils.advsearch.IQueryExpression;
import org.eclipse.smila.search.utils.advsearch.ITerm;
import org.eclipse.smila.search.utils.advsearch.ITermContent;
import org.eclipse.smila.search.utils.indexstructure.DIndexField;
import org.eclipse.smila.search.utils.indexstructure.DIndexStructure;
import org.eclipse.smila.search.utils.search.DField;
import org.eclipse.smila.search.utils.search.DQuery;
import org.eclipse.smila.search.utils.search.DTextField;
import org.eclipse.smila.search.utils.search.parameterobjects.DNodeTransformer;

public class TemplateAccess
implements ITemplateAccess {
    private final Log _log = LogFactory.getLog(this.getClass());

    public IQueryExpression applyTemplate(DQuery dQuery, DTemplate dTemplate, IndexConnection ic) throws TemplateException, NodeTransformerException, IndexException {
        DQueryExpression queryExp = (DQueryExpression)((DQueryExpression)dTemplate.getAdvSearch().getQueryExpression(0)).clone();
        Hashtable<Integer, DField> fields = new Hashtable<Integer, DField>();
        Enumeration enm = dQuery.getFields();
        while (enm.hasMoreElements()) {
            DField dField = (DField)enm.nextElement();
            fields.put(new Integer(dField.getFieldNo()), dField);
        }
        this.transformSearchQuery((DTerm)queryExp.getTerm(), fields, ic.getIndex().getIndexStructure(), ic);
        queryExp.setMaxHits(dQuery.getMaxHits());
        queryExp.setIndexName(dQuery.getIndexName());
        queryExp.setMinSimilarity(dQuery.getMinSimilarity());
        queryExp.setShowHitDistribution(dQuery.getShowHitDistribution());
        return queryExp;
    }

    private void transformSearchQuery(DTerm term, Hashtable fields, DIndexStructure is, IndexConnection ic) throws TemplateException, NodeTransformerException, IndexException {
        block17: {
            block19: {
                block18: {
                    block16: {
                        DIndexField isField;
                        if (!(term.getTerm() instanceof DTemplateField)) break block16;
                        if (this._log.isDebugEnabled()) {
                            this._log.debug((Object)("term=" + term));
                        }
                        DTemplateField tplField = term.getTemplateField();
                        NodeTransformer transformer = NodeTransformerRegistryController.getNodeTransformer((DNodeTransformer)tplField.getNodeTransformer(), (IndexConnection)ic);
                        DField field = (DField)((DField)fields.get(new Integer(tplField.getSourceFieldNo()))).clone();
                        if (field == null) {
                            throw new TemplateException("unable to locate field in search query [" + tplField.getSourceFieldNo() + "]");
                        }
                        if (tplField.getNodeTransformer() != null) {
                            transformer = NodeTransformerRegistryController.getNodeTransformer((DNodeTransformer)tplField.getNodeTransformer(), (IndexConnection)ic);
                            if (this._log.isDebugEnabled()) {
                                this._log.debug((Object)("using node transformer from template field [" + tplField.getFieldNo() + ";" + tplField.getNodeTransformer() + "]"));
                            }
                        }
                        if ((isField = is.getField(tplField.getFieldNo())) == null) {
                            throw new TemplateException("field referenced in template does not exist in index [" + tplField.getFieldNo() + "]");
                        }
                        if (field instanceof DTextField) {
                            DTextField tf = (DTextField)field;
                            DTextFieldParameter tfp = (DTextFieldParameter)tf.getParameter();
                            if (!isField.getType().equals("Text")) {
                                throw new TemplateException("conversion impossible [DTextField;" + isField.getClass().getName() + "]");
                            }
                            if (tplField instanceof DTextTemplateField) {
                                DTextTemplateField ttf = (DTextTemplateField)tplField;
                                if (ttf.getParameter() != null) {
                                    DTextFieldParameter ttfp = ttf.getParameter();
                                    if (ttfp.getOperator() != null) {
                                        if (this._log.isDebugEnabled()) {
                                            this._log.debug((Object)("using operator from template field [" + tplField.getFieldNo() + ";" + ttfp.getOperator().toString() + "]"));
                                        }
                                        tfp.setOperator(ttfp.getOperator());
                                    }
                                    if (ttfp.getTolerance() != null) {
                                        if (this._log.isDebugEnabled()) {
                                            this._log.debug((Object)("using tolerance from template field [" + tplField.getFieldNo() + ";" + ttfp.getTolerance().toString() + "]"));
                                        }
                                        tfp.setTolerance(ttfp.getTolerance());
                                    }
                                }
                            } else {
                                throw new TemplateException("invalid template field type for field [" + tplField.getFieldNo() + ";" + tplField.getClass().getName() + "]");
                            }
                        }
                        field.setFieldNo(tplField.getFieldNo());
                        term.setTerm(transformer.transformNode(field));
                        break block17;
                    }
                    if (!(term.getTerm() instanceof DOP1)) break block18;
                    this.transformSearchQuery(term.getOP1().getTerm(), fields, is, ic);
                    break block17;
                }
                if (!(term.getTerm() instanceof DOPN)) break block19;
                DOPN op = term.getOpN();
                int i = 0;
                while (i < op.getTermCount()) {
                    this.transformSearchQuery(op.getTerm(i), fields, is, ic);
                    ++i;
                }
                break block17;
            }
            if (!(term.getTerm() instanceof DWMEAN)) break block17;
            DWMEAN op = term.getWMEAN();
            int i = 0;
            while (i < op.getTermCount()) {
                this.transformSearchQuery(op.getTerm(i), fields, is, ic);
                ++i;
            }
        }
    }

    public ITerm applyFieldTemplate(DField dField, DFieldTemplate dTemplate, IndexConnection ic) throws TemplateException, NodeTransformerException, IndexException {
        DFieldTemplate template = null;
        try {
            template = (DFieldTemplate)dTemplate.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        DTerm dTerm = (DTerm)template.getTerm();
        this.evaluateTemplateFields(dTerm, dField, ic);
        return dTerm;
    }

    protected void evaluateTemplateFields(DTerm newField, DField dField, IndexConnection ic) throws NodeTransformerException, TemplateException, IndexException {
        ITermContent tc = newField.getTerm();
        if (tc instanceof DWMEAN) {
            Iterator<DTerm> i = ((DWMEAN)tc).getTerms();
            while (i.hasNext()) {
                this.evaluateTemplateFields(i.next(), dField, ic);
            }
        } else if (tc instanceof DOPN) {
            Iterator<DTerm> i = ((DOPN)tc).getTerms();
            while (i.hasNext()) {
                this.evaluateTemplateFields(i.next(), dField, ic);
            }
        } else if (tc instanceof DOP1) {
            this.evaluateTemplateFields(((DOP1)tc).getTerm(), dField, ic);
        } else if (tc instanceof DTemplateField) {
            DTemplateField tplField = (DTemplateField)tc;
            if (tplField.getSourceFieldNo() != dField.getFieldNo()) {
                throw new TemplateException("SourceFieldNo in TemplateField (" + tplField.getSourceFieldNo() + ") must match FieldNo in search field (" + dField.getFieldNo() + ")");
            }
            NodeTransformer transformer = null;
            DNodeTransformer transformerDef = ((DTemplateField)tc).getNodeTransformer();
            if (transformerDef == null) {
                transformerDef = dField.getNodeTransformer();
            }
            transformer = NodeTransformerRegistryController.getNodeTransformer((DNodeTransformer)transformerDef, (IndexConnection)ic);
            DField fld = (DField)dField.clone();
            if (tplField.getNodeTransformer() != null) {
                transformer = NodeTransformerRegistryController.getNodeTransformer((DNodeTransformer)tplField.getNodeTransformer(), (IndexConnection)ic);
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)("using node transformer from template field [" + tplField.getFieldNo() + ";" + tplField.getNodeTransformer() + "]"));
                }
            }
            if (dField instanceof DTextField) {
                DTextFieldParameter tfp = (DTextFieldParameter)((DTextField)fld).getParameter();
                if (tplField instanceof DTextTemplateField) {
                    DTextTemplateField ttf = (DTextTemplateField)tplField;
                    if (ttf.getParameter() != null) {
                        DTextFieldParameter ttfp = ttf.getParameter();
                        if (ttfp.getOperator() != null) {
                            if (this._log.isDebugEnabled()) {
                                this._log.debug((Object)("using operator from template field [" + tplField.getFieldNo() + ";" + ttfp.getOperator().toString() + "]"));
                            }
                            tfp.setOperator(ttfp.getOperator());
                        }
                        if (ttfp.getTolerance() != null) {
                            if (this._log.isDebugEnabled()) {
                                this._log.debug((Object)("using tolerance from template field [" + tplField.getFieldNo() + ";" + ttfp.getTolerance().toString() + "]"));
                            }
                            tfp.setTolerance(ttfp.getTolerance());
                        }
                    }
                } else {
                    throw new TemplateException("invalid template field type for field [" + tplField.getFieldNo() + ";" + tplField.getClass().getName() + "]");
                }
            }
            fld.setFieldNo(tplField.getFieldNo());
            newField.setTerm(transformer.transformNode(fld));
        }
    }
}

