/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.lucene.index;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RangeQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.search.datadictionary.DataDictionaryController;
import org.eclipse.smila.search.datadictionary.DataDictionaryException;
import org.eclipse.smila.search.datadictionary.messages.datadictionary.DIndex;
import org.eclipse.smila.search.datadictionary.messages.ddconfig.DConfiguration;
import org.eclipse.smila.search.index.IndexException;
import org.eclipse.smila.search.lucene.index.AnalyzerFactory;
import org.eclipse.smila.search.lucene.index.AnnotationFormatter;
import org.eclipse.smila.search.lucene.index.access.AddDocumentOperation;
import org.eclipse.smila.search.lucene.index.access.CountTotalOperation;
import org.eclipse.smila.search.lucene.index.access.DeleteDocumentsOperation;
import org.eclipse.smila.search.lucene.index.access.DoQueryOperation;
import org.eclipse.smila.search.lucene.index.access.ExistsOperation;
import org.eclipse.smila.search.lucene.index.access.GetDocumentOperation;
import org.eclipse.smila.search.lucene.index.access.IndexWriterPool;
import org.eclipse.smila.search.lucene.index.access.SynchronizedIndexReaderExecutor;
import org.eclipse.smila.search.lucene.index.access.SynchronizedIndexSearcherExecutor;
import org.eclipse.smila.search.lucene.index.access.SynchronizedIndexWriterExecutor;
import org.eclipse.smila.search.lucene.messages.advsearch.DNumField;
import org.eclipse.smila.search.lucene.messages.advsearch.DOP1;
import org.eclipse.smila.search.lucene.messages.advsearch.DOPN;
import org.eclipse.smila.search.lucene.messages.advsearch.DQueryExpression;
import org.eclipse.smila.search.lucene.messages.advsearch.DQueryExpressionCodec;
import org.eclipse.smila.search.lucene.messages.advsearch.DTerm;
import org.eclipse.smila.search.lucene.messages.advsearch.DWMEAN;
import org.eclipse.smila.search.lucene.messages.indexstructure.DIndexField;
import org.eclipse.smila.search.lucene.tools.search.lucene.DTextFieldParameter;
import org.eclipse.smila.search.templates.NodeTransformer;
import org.eclipse.smila.search.templates.NodeTransformerException;
import org.eclipse.smila.search.templates.NodeTransformerRegistryController;
import org.eclipse.smila.search.templates.TemplateException;
import org.eclipse.smila.search.templates.TemplateRegistryController;
import org.eclipse.smila.search.templates.messages.fieldtemplates.DFieldTemplate;
import org.eclipse.smila.search.utils.advsearch.AdvSearchException;
import org.eclipse.smila.search.utils.advsearch.IQueryExpression;
import org.eclipse.smila.search.utils.indexstructure.DIndexStructure;
import org.eclipse.smila.search.utils.search.DDateField;
import org.eclipse.smila.search.utils.search.DField;
import org.eclipse.smila.search.utils.search.DNumberField;
import org.eclipse.smila.search.utils.search.DQuery;
import org.eclipse.smila.search.utils.search.DTextField;
import org.eclipse.smila.search.utils.search.IDFParameter;
import org.eclipse.smila.search.utils.search.INFParameter;
import org.eclipse.smila.search.utils.search.ITFParameter;
import org.eclipse.smila.search.utils.search.parameterobjects.DNodeTransformer;
import org.eclipse.smila.search.utils.searchresult.DHit;
import org.eclipse.smila.search.utils.searchresult.DHitDistribution;
import org.eclipse.smila.search.utils.searchresult.LuceneSearchResult;
import org.eclipse.smila.utils.workspace.WorkspaceHelper;
import org.eclipse.smila.utils.xml.XMLUtils;
import org.eclipse.smila.utils.xml.XMLUtilsException;
import org.w3c.dom.Element;

public class IndexConnection
extends org.eclipse.smila.search.index.IndexConnection {
    public static final String DATE_FORMAT_PATTERN = "yyyyMMddHHmmss";
    private static final int MAX_NUMBER_FRAGMENTS = 100;
    private static final boolean MERGE_CONTIGUOSE_FRAGMENTS = false;
    private static final String[] ZEROES = new String[]{"", "0", "00", "000", "0000", "00000", "000000", "0000000", "00000000", "000000000", "0000000000", "00000000000", "000000000000", "0000000000000", "00000000000000", "000000000000000", "0000000000000000", "00000000000000000", "000000000000000000", "0000000000000000000"};
    private final Log _log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private final String _indexName;
    private DIndex _index;
    private final String _indexStore;
    private final Analyzer _analyzer;
    private Map<String, Document> _hits;

    public IndexConnection(String indexName) throws IndexException {
        super(indexName);
        try {
            this._index = DataDictionaryController.getIndex((String)indexName);
        }
        catch (DataDictionaryException e) {
            throw new IndexException(e.getMessage(), (Throwable)e);
        }
        if (this._index == null) {
            throw new IndexException("index not in data dictionary [" + indexName + "]");
        }
        try {
            int maxClauseCount = Integer.parseInt("4096");
            BooleanQuery.setMaxClauseCount((int)maxClauseCount);
        }
        catch (NumberFormatException ex) {
            this._log.error((Object)"unable to set BooleanQuery max clause count. using default value", (Throwable)ex);
        }
        this._indexName = indexName;
        try {
            File dataFolder = WorkspaceHelper.createWorkingDir((String)"org.eclipse.smila.lucene", (String)indexName);
            this._indexStore = dataFolder.getAbsolutePath();
        }
        catch (IOException e) {
            if (this._log.isErrorEnabled()) {
                this._log.error((Object)"", (Throwable)e);
            }
            throw new IndexException((Throwable)e);
        }
        this._analyzer = AnalyzerFactory.getAnalyzer(this._index);
    }

    protected void close() {
    }

    public boolean docExists(String id) throws IndexException {
        SynchronizedIndexReaderExecutor<Boolean> executor = new SynchronizedIndexReaderExecutor<Boolean>(this._index, this._indexStore);
        ExistsOperation operation = new ExistsOperation(new Term("##key", id));
        return executor.execute(operation);
    }

    public void deleteDocument(String id) throws IndexException {
        SynchronizedIndexWriterExecutor<Void> executor = new SynchronizedIndexWriterExecutor<Void>(this._index, this._indexStore, this._analyzer);
        DeleteDocumentsOperation operation = new DeleteDocumentsOperation(new Term("##key", id));
        executor.execute(operation);
        this.flushIndex();
    }

    public void learnDocument(Blackboard blackboard, String id, Map<String, Integer> attributeMapping, Map<String, Integer> attachmentMapping) throws IndexException, BlackboardAccessException {
        Document document = this.recordToDocument(blackboard, id, attributeMapping, attachmentMapping);
        this.writeDocumentToIndex(document);
    }

    private void writeDocumentToIndex(Document document) throws IndexException {
        SynchronizedIndexWriterExecutor<Void> executor = new SynchronizedIndexWriterExecutor<Void>(this._index, this._indexStore, this._analyzer);
        AddDocumentOperation operation = new AddDocumentOperation(document);
        executor.execute(operation);
        this.flushIndex();
    }

    private void flushIndex() throws IndexException {
        if (this._index.isForceFlush()) {
            IndexWriterPool.flushIndexWriter(this._indexName);
        }
    }

    private Document recordToDocument(Blackboard blackboard, String id, Map<String, Integer> attributeMapping, Map<String, Integer> attachmentMapping) throws BlackboardAccessException, IndexException {
        AnyMap metadata = blackboard.getMetadata(id);
        Document document = new Document();
        document.add((Fieldable)new Field("##key", id, Field.Store.YES, Field.Index.UN_TOKENIZED));
        if (metadata.containsKey((Object)"_source")) {
            String source = metadata.getStringValue("_source");
            document.add((Fieldable)new Field("##source", source, Field.Store.YES, Field.Index.UN_TOKENIZED));
        }
        Set<Map.Entry<String, Integer>> set = attributeMapping.entrySet();
        for (Map.Entry<String, Integer> entry : set) {
            String attribute = entry.getKey();
            if (metadata.containsKey((Object)attribute)) {
                int fieldNo = entry.getValue();
                Any values = (Any)metadata.get((Object)attribute);
                for (Any value : values) {
                    if (!value.isValue()) continue;
                    String stringValue = this.getLiteralAsString(fieldNo, (Value)value);
                    document.add((Fieldable)this.createField(fieldNo, stringValue));
                }
                continue;
            }
            if (!this._log.isInfoEnabled()) continue;
            this._log.info((Object)("Record does not contain a attribute named " + entry.getKey()));
        }
        set = attachmentMapping.entrySet();
        for (Map.Entry<String, Integer> entry : set) {
            if (blackboard.hasAttachment(id, entry.getKey())) {
                try {
                    byte[] byteValue = blackboard.getAttachment(id, entry.getKey());
                    if (byteValue == null) continue;
                    String stringValue = new String(byteValue, "UTF-8");
                    document.add((Fieldable)this.createField(entry.getValue(), stringValue));
                }
                catch (UnsupportedEncodingException e) {
                    if (!this._log.isWarnEnabled()) continue;
                    this._log.warn((Object)("Error while converting attachment " + entry.getKey()), (Throwable)e);
                }
                continue;
            }
            if (!this._log.isInfoEnabled()) continue;
            this._log.info((Object)("Record does not contain a attachment named " + entry.getKey()));
        }
        return document;
    }

    private String getLiteralAsString(int fieldNo, Value value) {
        String stringValue;
        DIndexField dIF = (DIndexField)this._index.getIndexStructure().getField(fieldNo);
        if (dIF.getType().equals("Date")) {
            SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT_PATTERN);
            stringValue = df.format(value.asDateTime());
        } else {
            stringValue = value.asString();
        }
        return stringValue;
    }

    private Field createField(int fieldNo, String fieldText) {
        DIndexField dIF = (DIndexField)this._index.getIndexStructure().getField(fieldNo);
        if (dIF.getType().equals("Number")) {
            fieldText = this.padNumField(fieldText);
        }
        Field.Store storeText = dIF.getStoreText() ? Field.Store.YES : Field.Store.NO;
        Field.Index index = null;
        index = dIF.getIndexValue() ? (dIF.getTokenize() ? Field.Index.TOKENIZED : Field.Index.UN_TOKENIZED) : Field.Index.NO;
        return new Field(dIF.getName(), fieldText, storeText, index);
    }

    public String padNumField(String text) {
        boolean negative;
        long num;
        block4: {
            text = text.trim();
            num = 0L;
            if (!"".equals(text)) {
                try {
                    num = Long.parseLong(text);
                }
                catch (NumberFormatException numberFormatException) {
                    double d = Double.parseDouble(text);
                    num = new BigDecimal(d).longValueExact();
                    text = Long.toString(num);
                    if (!this._log.isTraceEnabled()) break block4;
                    this._log.trace((Object)"converted double to long value for indexing");
                }
            }
        }
        boolean bl = negative = num < 0L;
        if (negative) {
            text = text.substring(1);
        }
        int z = Math.min(Math.max(0, 19 - text.length()), 19);
        text = negative ? "a" + ZEROES[z] + text : "z" + ZEROES[z] + text;
        return text;
    }

    public Analyzer getAnalyzer() {
        return this._analyzer;
    }

    protected void startBurstmode() throws IndexException {
    }

    protected void stopBurstmode() throws IndexException {
    }

    public IQueryExpression getSimpleSearchQuery(DQuery dQuery) throws IndexException, NodeTransformerException, TemplateException {
        DQueryExpression dQE = new DQueryExpression(dQuery.getIndexName(), dQuery.getMaxHits());
        dQE.setShowHitDistribution(dQuery.getShowHitDistribution());
        dQE.setMinSimilarity(dQuery.getMinSimilarity());
        dQE.setStartHits(dQuery.getStartHits());
        dQE.setMaxHits(dQuery.getMaxHits());
        if (dQuery.getFieldsCount() > 1) {
            Enumeration enm = dQuery.getFields();
            DWMEAN op = new DWMEAN();
            op.setOperation("MEAN");
            while (enm.hasMoreElements()) {
                DField dField = (DField)enm.nextElement();
                DFieldTemplate dFieldTemplate = TemplateRegistryController.getFieldTemplate((DQuery)dQuery, (DField)dField, (String)dQuery.getIndexName());
                if (dFieldTemplate != null) {
                    op.addTerm((DTerm)TemplateRegistryController.applyFieldTemplate((DField)dField, (DFieldTemplate)dFieldTemplate, (org.eclipse.smila.search.index.IndexConnection)this), dField.getWeight().floatValue(), dField.getConstraint());
                    continue;
                }
                NodeTransformer transformer = NodeTransformerRegistryController.getNodeTransformer((DNodeTransformer)dField.getNodeTransformer(), (org.eclipse.smila.search.index.IndexConnection)this);
                op.addTerm(new DTerm(transformer.transformNode(dField)), dField.getWeight().floatValue(), dField.getConstraint());
            }
            dQE.setTerm(new DTerm(op));
        } else {
            DField dField = (DField)dQuery.getFields().nextElement();
            DFieldTemplate dFieldTemplate = TemplateRegistryController.getFieldTemplate((DQuery)dQuery, (DField)dField, (String)dQuery.getIndexName());
            if (dFieldTemplate != null) {
                dQE.setTerm(TemplateRegistryController.applyFieldTemplate((DField)dField, (DFieldTemplate)dFieldTemplate, (org.eclipse.smila.search.index.IndexConnection)this));
            } else {
                NodeTransformer transformer = NodeTransformerRegistryController.getNodeTransformer((DNodeTransformer)dField.getNodeTransformer(), (org.eclipse.smila.search.index.IndexConnection)this);
                dQE.setTerm(new DTerm(transformer.transformNode(dField)));
            }
        }
        return dQE;
    }

    public LuceneSearchResult doQuery(IQueryExpression queryExpression, int startPos) throws IndexException {
        if (!(queryExpression instanceof DQueryExpression)) {
            throw new IllegalArgumentException("invalid type for dQE [" + queryExpression.getClass().getName() + "]");
        }
        SynchronizedIndexSearcherExecutor<LuceneSearchResult> executor = new SynchronizedIndexSearcherExecutor<LuceneSearchResult>(this._index, this._indexStore);
        return executor.execute(new DoQueryOperation(this, (DQueryExpression)queryExpression, startPos));
    }

    public LuceneSearchResult doQueryCallback(IndexSearcher indexSearcher, DQueryExpression queryExpression, int startPos) throws XMLUtilsException, AdvSearchException, IndexException, IOException {
        Hits hits = null;
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Resulting advanced search:\n" + new String(XMLUtils.stream((Element)DQueryExpressionCodec.encode(queryExpression, XMLUtils.getDocument((String)"AnyFinderAdvancedSearch").getDocumentElement()), (boolean)false))));
        }
        Query q = this.transformQuery((DTerm)queryExpression.getTerm(), 1.0f);
        this._hits = new HashMap<String, Document>();
        hits = indexSearcher.search(q);
        int maxHits = queryExpression.getMaxHits();
        int minSimilarity = queryExpression.getMinSimilarity();
        boolean showHitDistribution = queryExpression.getShowHitDistribution();
        return this.doQueryHits2LuceneResult(hits, queryExpression.getIndexName(), maxHits, minSimilarity, startPos, showHitDistribution);
    }

    private LuceneSearchResult doQueryHits2LuceneResult(Hits hits, String indexName, int maxHits, int minSimilarity, int startPos, boolean showHitDistribution) throws IndexException {
        LuceneSearchResult result = new LuceneSearchResult();
        ArrayList<Record> resultList = new ArrayList<Record>();
        DHitDistribution dHitDist = new DHitDistribution();
        if (hits.length() > 0) {
            int score;
            int loopCnt = Math.min(hits.length(), maxHits + startPos);
            int hitScore = -1;
            int hitCnt = 0;
            int hitCnts = 0;
            int i = 0;
            while (i < hits.length()) {
                block14: {
                    try {
                        score = (int)Math.ceil(hits.score(i) * 100.0f);
                        if (score < minSimilarity) break;
                        if (hitScore == score) {
                            ++hitCnt;
                        } else {
                            if (hitScore >= 0) {
                                dHitDist.addHit(new DHit(hitScore, hitCnt));
                                hitCnts += hitCnt;
                            }
                            hitCnt = 1;
                            hitScore = score;
                        }
                        if (i < startPos) {
                            // empty if block
                        }
                    }
                    catch (IOException e) {
                        if (!this._log.isErrorEnabled()) break block14;
                        this._log.error((Object)"", (Throwable)e);
                    }
                }
                ++i;
            }
            if (startPos < loopCnt) {
                i = startPos;
                while (i < loopCnt) {
                    try {
                        score = (int)Math.ceil(hits.score(i) * 100.0f);
                        if (score < minSimilarity) break;
                        String id = hits.doc(i).get("##key");
                        String source = hits.doc(i).get("##source");
                        Record record = DataFactory.DEFAULT.createRecord(id, source);
                        this._hits.put(id, hits.doc(i));
                        double weight = (double)score / 100.0;
                        record.getMetadata().put("_weight", (Any)DataFactory.DEFAULT.createDoubleValue(Double.valueOf(weight)));
                        resultList.add(record);
                    }
                    catch (IOException e) {
                        this._log.error((Object)"", (Throwable)e);
                    }
                    ++i;
                }
            }
            if (hitScore >= 0) {
                dHitDist.addHit(new DHit(hitScore, hitCnt));
            }
            dHitDist.addHit(new DHit(0, this.getDocumentCount() - (hitCnts += hitCnt)));
        }
        result.setIndexName(indexName);
        result.setResultList(resultList);
        if (showHitDistribution) {
            result.setHitDistribution(dHitDist);
        }
        return result;
    }

    private int getDocumentCount() throws IndexException {
        SynchronizedIndexReaderExecutor<Integer> executor = new SynchronizedIndexReaderExecutor<Integer>(this._index, this._indexStore);
        CountTotalOperation operation = new CountTotalOperation();
        return executor.execute(operation);
    }

    /*
     * Unable to fully structure code
     */
    private Query transformQuery(DTerm dTerm, float boostFactor) {
        block63: {
            if (dTerm.getTerm() instanceof DOPN) {
                q = new BooleanQuery();
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)"<BooleanQuery>");
                }
                op = dTerm.getOpN();
                operation = op.getOperation();
                i = 0;
                while (i < op.getTermCount()) {
                    if (op.getTerm(i).getTerm() instanceof DOP1 && ((DOP1)op.getTerm(i).getTerm()).getOperation().equals("NOT")) {
                        if (this._log.isDebugEnabled()) {
                            this._log.debug((Object)("<BooleanClause boost=" + boostFactor + " prohibited>"));
                        }
                        tq = this.transformQuery(((DOP1)op.getTerm(i).getTerm()).getTerm(), boostFactor);
                        tq.setBoost(boostFactor);
                        bc = new BooleanClause(tq, BooleanClause.Occur.MUST_NOT);
                    } else {
                        if (this._log.isDebugEnabled()) {
                            this._log.debug((Object)("<BooleanClause boost=" + boostFactor + " " + (operation.equals("AND") != false ? "required" : "") + ">"));
                        }
                        tq = this.transformQuery(op.getTerm(i), boostFactor);
                        tq.setBoost(boostFactor);
                        bc = operation.equals("AND") != false ? new BooleanClause(tq, BooleanClause.Occur.MUST) : new BooleanClause(tq, BooleanClause.Occur.SHOULD);
                        if (this._log.isDebugEnabled()) {
                            this._log.debug((Object)"</BooleanClause>");
                        }
                    }
                    q.add(bc);
                    ++i;
                }
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)"</BooleanQuery>");
                }
                return q;
            }
            if (dTerm.getTerm() instanceof DWMEAN) {
                q = new BooleanQuery();
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)"<BooleanQuery>");
                }
                op = dTerm.getWMEAN();
                i = 0;
                while (i < op.getTermCount()) {
                    constraint = op.getConstraint(i);
                    boost = op.getBoost(i) * boostFactor;
                    if (op.getTerm(i).getTerm() instanceof DOP1 && ((DOP1)op.getTerm(i).getTerm()).getOperation().equals("NOT")) {
                        if (this._log.isDebugEnabled()) {
                            this._log.debug((Object)("<BooleanClause boost=" + boost + " prohibited>"));
                        }
                        tq = this.transformQuery(((DOP1)op.getTerm(i).getTerm()).getTerm(), boost);
                        tq.setBoost(boost);
                        bc = new BooleanClause(tq, BooleanClause.Occur.MUST_NOT);
                        if (this._log.isDebugEnabled()) {
                            this._log.debug((Object)"</BooleanClause>");
                        }
                    } else {
                        if (this._log.isDebugEnabled()) {
                            this._log.debug((Object)("<BooleanClause boost=" + boost + " " + (constraint.equals("required") != false ? "required " : "") + (constraint.equals("prohibited") != false ? "prohibited" : "") + ">"));
                        }
                        tq = this.transformQuery(op.getTerm(i), boost);
                        tq.setBoost(boost);
                        bc = constraint.equals("required") != false ? new BooleanClause(tq, BooleanClause.Occur.MUST) : (constraint.equals("prohibited") != false ? new BooleanClause(tq, BooleanClause.Occur.MUST_NOT) : new BooleanClause(tq, BooleanClause.Occur.SHOULD));
                        if (this._log.isDebugEnabled()) {
                            this._log.debug((Object)"</BooleanClause>");
                        }
                    }
                    q.add(bc);
                    ++i;
                }
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)"</BooleanQuery>");
                }
                return q;
            }
            if (dTerm.getTerm() instanceof DOP1) {
                q = new BooleanQuery();
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)"<BooleanQuery>");
                }
                if ((op = dTerm.getOP1()).getOperation().equals("NOT")) {
                    if (this._log.isDebugEnabled()) {
                        this._log.debug((Object)"<BooleanClause prohibited>");
                    }
                    q.add(this.transformQuery(op.getTerm(), boostFactor), BooleanClause.Occur.MUST_NOT);
                    if (this._log.isDebugEnabled()) {
                        this._log.debug((Object)"</BooleanClause>");
                    }
                }
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)"</BooleanQuery>");
                }
                return q;
            }
            if (dTerm.getTerm() instanceof DNumField) {
                field = (DNumField)dTerm.getTerm();
                lower = new Term(this._index.getIndexStructure().getField(field.getFieldNo()).getName(), this.padNumField("" + field.getMin()));
                upper = new Term(this._index.getIndexStructure().getField(field.getFieldNo()).getName(), this.padNumField("" + field.getMax()));
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)"<RangeQuery inclusive>");
                    this._log.debug((Object)("<LowerTerm FieldName=" + lower.field() + " Text=" + lower.text() + "/>"));
                    this._log.debug((Object)("<UpperTerm FieldName=" + upper.field() + " Text=" + upper.text() + "/>"));
                    this._log.debug((Object)"</RangeQuery>");
                }
                q = new RangeQuery(lower, upper, true);
                return q;
            }
            if (dTerm.getTerm() instanceof org.eclipse.smila.search.lucene.messages.advsearch.DDateField) {
                field = (org.eclipse.smila.search.lucene.messages.advsearch.DDateField)dTerm.getTerm();
                df = new SimpleDateFormat("yyyyMMddHHmmss");
                lower = null;
                upper = null;
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)"<RangeQuery inclusive>");
                }
                if (field.getMin() != null) {
                    lower = new Term(this._index.getIndexStructure().getField(field.getFieldNo()).getName(), df.format(field.getMin()));
                    if (this._log.isDebugEnabled()) {
                        this._log.debug((Object)("<LowerTerm FieldName=" + lower.field() + " Text=" + lower.text() + "/>"));
                    }
                }
                if (field.getMax() != null) {
                    upper = new Term(this._index.getIndexStructure().getField(field.getFieldNo()).getName(), df.format(field.getMax()));
                    if (this._log.isDebugEnabled()) {
                        this._log.debug((Object)("<UpperTerm FieldName=" + upper.field() + " Text=" + upper.text() + "/>"));
                    }
                }
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)"</RangeQuery>");
                }
                q = new RangeQuery(lower, upper, true);
                return q;
            }
            tf = dTerm.getTextField();
            a = this.getAnalyzer();
            fieldName = this._index.getIndexStructure().getField(tf.getFieldNo()).getName();
            fieldText = tf.getText().trim();
            isPhraseSearch = fieldText.indexOf(" ") > 0;
            isWildcardSearch = false;
            isFuzzySearch = false;
            terms = new ArrayList<Term>();
            indexField = (DIndexField)this._index.getIndexStructure().getField(tf.getFieldNo());
            if (!indexField.getTokenize()) ** GOTO lbl136
            isWildcardSearch = tf.getParseWildcards() != false && isPhraseSearch == false && this.containsWildcards(fieldText) != false;
            v0 = isFuzzySearch = tf.getFuzzy() != false && isPhraseSearch == false && isWildcardSearch == false;
            if (isWildcardSearch) {
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)("fieldText=" + fieldText + ", token " + fieldText));
                }
                terms.add(new Term(fieldName, fieldText));
            } else {
                try {
                    ts = a.tokenStream(fieldName, (Reader)new StringReader(fieldText));
                    while ((t = ts.next()) != null) {
                        text = t.termText();
                        if (this._log.isDebugEnabled()) {
                            this._log.debug((Object)("fieldText=" + fieldText + ", token " + text + " (type " + t.type() + ")"));
                        }
                        terms.add(new Term(fieldName, text));
                    }
                    ts.close();
                }
                catch (IOException ioe) {
                    if (this._log.isErrorEnabled()) {
                        this._log.error((Object)ioe);
                    }
                    break block63;
                }
lbl136:
                // 1 sources

                isWildcardSearch = tf.getParseWildcards() != false && this.containsWildcards(fieldText) != false;
                v1 = isFuzzySearch = tf.getFuzzy() != false && isWildcardSearch == false;
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)("fieldText=" + fieldText + ", token " + fieldText));
                }
                terms.add(new Term(fieldName, fieldText));
            }
        }
        if (terms.size() == 0) {
            terms.add(new Term(fieldName, ""));
        }
        if (isFuzzySearch && terms.size() > 1) {
            q = new BooleanQuery();
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)"<BooleanQuery>");
            }
            i = 0;
            while (i < terms.size()) {
                fq = new FuzzyQuery(new Term(fieldName, ((Term)terms.get(i)).text()));
                q.add(new BooleanClause((Query)fq, BooleanClause.Occur.MUST));
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)("<FuzzyQuery FieldName=" + ((Term)terms.get(i)).field() + " Text=" + ((Term)terms.get(i)).text() + "/>"));
                }
                ++i;
            }
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)"</BooleanQuery>");
            }
        } else if (terms.size() > 1) {
            q = new PhraseQuery();
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("<PhraseQuery Slop=" + tf.getSlop() + ">"));
            }
            i = 0;
            while (i < terms.size()) {
                ((PhraseQuery)q).add((Term)terms.get(i));
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)("<Term FieldName=" + ((Term)terms.get(i)).field() + " Text=" + ((Term)terms.get(i)).text() + "/>"));
                }
                ++i;
            }
            ((PhraseQuery)q).setSlop(tf.getSlop());
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)"</PhraseQuery>");
            }
        } else if (isWildcardSearch) {
            v2 = txt = indexField.getTokenize() != false ? fieldText.toLowerCase() : fieldText;
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("<WildcardQuery FieldName=" + fieldName + " Text=" + txt + "/>"));
            }
            q = new WildcardQuery(new Term(fieldName, txt));
        } else if (isFuzzySearch) {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("<FuzzyQuery FieldName=" + fieldName + " Text=" + ((Term)terms.get(0)).text() + "/>"));
            }
            q = new FuzzyQuery(new Term(fieldName, ((Term)terms.get(0)).text()));
        } else {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("<TermQuery FieldName=" + fieldName + " Text=" + ((Term)terms.get(0)).text() + "/>"));
            }
            q = new TermQuery(new Term(fieldName, ((Term)terms.get(0)).text()));
        }
        return q;
    }

    private boolean containsWildcards(String fieldText) {
        return fieldText.indexOf("*") >= 0 || fieldText.indexOf("?") >= 0;
    }

    private Document getDocument(String key) throws IndexException {
        SynchronizedIndexSearcherExecutor<Document> executor = new SynchronizedIndexSearcherExecutor<Document>(this._index, this._indexStore);
        return executor.execute(new GetDocumentOperation(key));
    }

    protected IQueryExpression getTestQueryExpression(String text) throws IndexException {
        DQueryExpression dQueryExp = new DQueryExpression();
        String[] tokens = text.split(" ");
        DWMEAN wmean = new DWMEAN();
        String[] stringArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            org.eclipse.smila.search.lucene.messages.advsearch.DTextField field = new org.eclipse.smila.search.lucene.messages.advsearch.DTextField(0, token, true, true, 0);
            wmean.addTerm(new DTerm(field), 1.0f, "optional");
            ++n2;
        }
        dQueryExp.setIndexName(this._indexName);
        dQueryExp.setMaxHits(100);
        dQueryExp.setTerm(new DTerm(wmean));
        return dQueryExp;
    }

    protected void insertTextParameter(DTextField field, ITFParameter configParameter, String config, StringBuffer sb) {
        if (configParameter == null) {
            return;
        }
        DTextFieldParameter tfp = null;
        if (field.getParameter() == null) {
            field.setParameter((ITFParameter)new DTextFieldParameter());
        }
        tfp = (DTextFieldParameter)field.getParameter();
        DTextFieldParameter ctfp = (DTextFieldParameter)configParameter;
        if (ctfp.getTolerance() != null && tfp.getTolerance() == null) {
            tfp.setTolerance(ctfp.getTolerance());
            sb = sb.append(String.valueOf(config) + ":Tolerance=" + ctfp.getTolerance().toString() + " ");
        }
        if (ctfp.getOperator() != null && tfp.getOperator() == null) {
            tfp.setOperator(ctfp.getOperator());
            sb = sb.append(String.valueOf(config) + ":Operator=" + ctfp.getOperator().toString() + " ");
        }
    }

    protected void insertNumberParameter(DNumberField field, INFParameter configParameter, String config, StringBuffer sb) {
    }

    protected void insertDateParameter(DDateField field, IDFParameter configParameter, String config, StringBuffer sb) {
    }

    protected void getResultValues(String[] keys, int[] fields, String[][] values) throws IndexException {
        DIndexStructure dIS = this._index.getIndexStructure();
        Map<String, Document> documents = this._hits;
        int i = 0;
        while (i < keys.length) {
            Document doc = documents.get(keys[i]);
            int j = 0;
            while (j < fields.length) {
                DIndexField field = (DIndexField)dIS.getField(fields[j]);
                if (field == null) {
                    throw new IndexException("invalid field no in result [" + fields[j] + "]");
                }
                values[i][j] = doc.get(field.getName());
                ++j;
            }
            ++i;
        }
    }

    protected String[] getResultValues(String id, int fieldNo) throws IndexException {
        DIndexStructure dIS = this._index.getIndexStructure();
        Document doc = this._hits.get(id);
        DIndexField field = (DIndexField)dIS.getField(fieldNo);
        if (field == null) {
            throw new IndexException("invalid field no in result [" + fieldNo + "]");
        }
        return doc.getValues(field.getName());
    }

    private Map<Integer, Query> getHlQueries(int[] hrFields, IQueryExpression queryExpression, IndexReader indexReader) throws IOException {
        HashMap<Integer, Query> hlQueries = new HashMap<Integer, Query>();
        HashMap<Integer, Set<String>> highlightingTermsPerField = new HashMap<Integer, Set<String>>();
        this.getQueryText((DTerm)queryExpression.getTerm(), highlightingTermsPerField);
        int[] nArray = hrFields;
        int n = hrFields.length;
        int n2 = 0;
        while (n2 < n) {
            int hrField = nArray[n2];
            Query query = null;
            try {
                DTerm dTerm = (DTerm)queryExpression.getTerm().clone();
                dTerm = this.normalizeTemplateSearch(dTerm, hrField);
                if (dTerm != null && dTerm.getTerm() != null) {
                    query = this.transformQuery(dTerm, 1.0f);
                    query = query.rewrite(indexReader);
                    hlQueries.put(hrField, query);
                }
            }
            catch (CloneNotSupportedException exception) {
                this._log.error((Object)"unalbe to prepare highlighting query", (Throwable)exception);
            }
            ++n2;
        }
        return hlQueries;
    }

    private DTerm normalizeTemplateSearch(DTerm term, int remainingFieldNo) {
        if (term.getTerm() instanceof DNumField) {
            term.setTerm(null);
        } else if (term.getTerm() instanceof org.eclipse.smila.search.lucene.messages.advsearch.DDateField) {
            term.setTerm(null);
        } else if (term.getTerm() instanceof org.eclipse.smila.search.lucene.messages.advsearch.DTextField) {
            org.eclipse.smila.search.lucene.messages.advsearch.DTextField tf = term.getTextField();
            DIndexField ddField = (DIndexField)this._index.getIndexStructure().getField(tf.getFieldNo());
            if (!ddField.getStoreText()) {
                term.setTerm(null);
            }
            if (tf.getFieldNo() != remainingFieldNo) {
                term.setTerm(null);
            }
        } else if (term.getTerm() instanceof DOP1) {
            this.normalizeTemplateSearch(term.getOP1().getTerm(), remainingFieldNo);
            if (term.getOP1().getTerm().getTerm() == null) {
                term.setTerm(null);
            }
        } else if (term.getTerm() instanceof DOPN) {
            DOPN op = term.getOpN();
            int i = op.getTermCount() - 1;
            while (i >= 0) {
                this.normalizeTemplateSearch(op.getTerm(i), remainingFieldNo);
                if (op.getTerm(i).getTerm() == null) {
                    op.removeTerm(i);
                }
                --i;
            }
            if (op.getTermCount() == 1) {
                term.setTerm(op.getTerm(0).getTerm());
            } else if (op.getTermCount() == 0) {
                term.setTerm(null);
            }
        } else if (term.getTerm() instanceof DWMEAN) {
            DWMEAN op = term.getWMEAN();
            int i = op.getTermCount() - 1;
            while (i >= 0) {
                this.normalizeTemplateSearch(op.getTerm(i), remainingFieldNo);
                --i;
            }
            DWMEAN opNew = new DWMEAN();
            opNew.setOperation(op.getOperation());
            int i2 = 0;
            while (i2 < op.getTermCount()) {
                if (op.getTerm(i2).getTerm() != null) {
                    opNew.addTerm(op.getTerm(i2), op.getBoost(i2), op.getConstraint(i2));
                }
                ++i2;
            }
            if (opNew.getTermCount() > 1) {
                term.setTerm(opNew);
            } else if (opNew.getTermCount() == 1) {
                term.setTerm(opNew.getTerm(0).getTerm());
            } else if (opNew.getTermCount() == 0) {
                term.setTerm(null);
            }
        }
        return term;
    }

    private void getQueryText(DTerm term, Map<Integer, Set<String>> highlightingTermsPerField) {
        block12: {
            block11: {
                if (!(term.getTerm() instanceof org.eclipse.smila.search.lucene.messages.advsearch.DTextField)) break block11;
                org.eclipse.smila.search.lucene.messages.advsearch.DTextField textField = term.getTextField();
                Integer fieldNo = new Integer(textField.getFieldNo());
                Set<Object> terms = null;
                if (highlightingTermsPerField.containsKey(fieldNo)) {
                    terms = highlightingTermsPerField.get(fieldNo);
                } else {
                    terms = new HashSet();
                    highlightingTermsPerField.put(fieldNo, terms);
                }
                if (textField.getText() == null) break block12;
                String[] stringArray = textField.getText().split(" ");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String textTerm = stringArray[n2];
                    if (textTerm != null && !"".equals(textTerm = textTerm.trim())) {
                        terms.add(textTerm);
                    }
                    ++n2;
                }
                break block12;
            }
            if (term.getTerm() instanceof DOP1) {
                this.getQueryText(term.getOP1().getTerm(), highlightingTermsPerField);
            } else if (term.getTerm() instanceof DOPN) {
                DOPN op = term.getOpN();
                int i = 0;
                while (i < op.getTermCount()) {
                    this.getQueryText(op.getTerm(i), highlightingTermsPerField);
                    ++i;
                }
            } else if (term.getTerm() instanceof DWMEAN) {
                DWMEAN op = term.getWMEAN();
                int i = 0;
                while (i < op.getTermCount()) {
                    this.getQueryText(op.getTerm(i), highlightingTermsPerField);
                    ++i;
                }
            }
        }
    }

    protected void encodeTextField(DTextField tf) throws IndexException {
    }

    protected void isSupportedValue(int fieldNo, Object value) throws IndexException {
        if (value != null && !(value instanceof String)) {
            throw new IndexException("field has invalid content type [" + fieldNo + ";" + value.getClass().getName() + "]; null|java.lang.String required");
        }
    }

    protected Value createValue(DataFactory f, int fieldNo, String value) throws IndexException {
        DConfiguration dConfig = this._index.getConfiguration();
        String type = dConfig.getDefaultConfig().getField(fieldNo).getFieldConfig().getType();
        if ("FTText".equals(type)) {
            return f.createStringValue(value);
        }
        if ("FTDate".equals(type)) {
            try {
                SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT_PATTERN);
                return f.createDateTimeValue(df.parse(value));
            }
            catch (ParseException e) {
                throw new IndexException("error parsing valuee of field no " + fieldNo, (Throwable)e);
            }
        }
        if ("FTNumber".equals(type)) {
            String longValue = value.replaceAll("a|z[0]*", "");
            if (longValue.isEmpty() && !value.isEmpty()) {
                return f.createLongValue(0);
            }
            return f.createLongValue(Long.valueOf(Long.parseLong(longValue)));
        }
        throw new IndexException("unknown FieldConfig type " + type);
    }

    protected void addHighlightAnnotation(IQueryExpression dQE, String recordId, AnyMap highlight, int fieldNo, String attributeName, String indexName) throws IndexException {
        DIndexStructure dIS = this._index.getIndexStructure();
        Document doc = this._hits.get(recordId);
        DIndexField field = (DIndexField)dIS.getField(fieldNo);
        if (field == null) {
            throw new IndexException("invalid field no in result [" + fieldNo + "]");
        }
        String text = doc.get(field.getName());
        if (text != null) {
            AnnotationFormatter formatter = new AnnotationFormatter(highlight.getFactory());
            formatter.reset(text);
            try {
                Query hlQuery = this.getHighlightQuery(fieldNo, dQE);
                if (hlQuery != null) {
                    TokenStream tokenStream = this._analyzer.tokenStream(attributeName, (Reader)new StringReader(text));
                    Highlighter highlighter = new Highlighter((Formatter)formatter, (Scorer)new QueryScorer(hlQuery));
                    highlighter.getBestTextFragments(tokenStream, text, false, 100);
                    AnyMap attributeHighlight = highlight.getFactory().createAnyMap();
                    AnySeq highlightingPositions = formatter.getHighlightPositions();
                    attributeHighlight.put("positions", (Any)highlightingPositions);
                    attributeHighlight.put("text", (Any)highlight.getFactory().createStringValue(text));
                    highlight.put(attributeName, (Any)attributeHighlight);
                }
            }
            catch (Exception ex) {
                throw new IndexException("error getting result value for record with id " + recordId, (Throwable)ex);
            }
        }
    }

    private Query getHighlightQuery(int highlightResultFieldNo, IQueryExpression queryExpression) throws IOException {
        Query query = null;
        try {
            DTerm dTerm = (DTerm)queryExpression.getTerm().clone();
            dTerm = this.normalizeTemplateSearch(dTerm, highlightResultFieldNo);
            if (dTerm != null && dTerm.getTerm() != null) {
                query = this.transformQuery(dTerm, 1.0f);
                IndexReader indexReader = IndexReader.open((String)this._indexStore);
                query = query.rewrite(indexReader);
            }
        }
        catch (CloneNotSupportedException exception) {
            this._log.error((Object)"unalbe to prepare highlighting query", (Throwable)exception);
        }
        return query;
    }

    public void unlock() throws IndexException {
        try {
            if (IndexReader.isLocked((String)this._indexStore)) {
                IndexReader.unlock((Directory)FSDirectory.getDirectory((String)this._indexStore));
                if (this._log.isInfoEnabled()) {
                    this._log.info((Object)("Removed lock on Lucene index " + this._indexName));
                }
            }
        }
        catch (Exception e) {
            throw new IndexException((Throwable)e);
        }
    }
}

