/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.lucene.index.access;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.eclipse.smila.search.datadictionary.DataDictionaryController;
import org.eclipse.smila.search.datadictionary.messages.datadictionary.DIndex;
import org.eclipse.smila.search.index.IndexException;

public final class IndexWriterPool {
    private static final HashMap<String, IndexWriter> POOL = new HashMap();
    private static final Log LOG = LogFactory.getLog(IndexWriterPool.class);

    private IndexWriterPool() {
    }

    public static synchronized IndexWriter getIndexWriter(String indexName, String storage, Analyzer analyzer) throws IndexException {
        IndexWriter indexWriter = POOL.get(indexName);
        if (indexWriter == null) {
            try {
                if (IndexReader.isLocked((String)storage)) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn((Object)("Lucene index " + indexName + " was locked. Perhaps SMILA process was killed or another error happened."));
                    }
                    IndexReader.unlock((Directory)FSDirectory.getDirectory((String)storage));
                    if (LOG.isWarnEnabled()) {
                        LOG.warn((Object)("Removed lock on Lucene index " + indexName));
                    }
                }
                DIndex indexConfig = DataDictionaryController.getIndex((String)indexName);
                indexWriter = new IndexWriter(storage, analyzer, false);
                if (indexConfig.getRamBufferSize() != null) {
                    indexWriter.setRAMBufferSizeMB((double)indexConfig.getRamBufferSize().intValue());
                }
                if (indexConfig.getMaxBufferedDocs() != null) {
                    indexWriter.setMaxBufferedDocs(indexConfig.getMaxBufferedDocs().intValue());
                }
                if (indexConfig.getMaxBufferedDeleteTerms() != null) {
                    indexWriter.setMaxBufferedDeleteTerms(indexConfig.getMaxBufferedDeleteTerms().intValue());
                }
                POOL.put(indexName, indexWriter);
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Created new IndexWriter for Lucene index " + indexName));
                }
            }
            catch (Exception e) {
                throw new IndexException((Throwable)e);
            }
        }
        return indexWriter;
    }

    public static void flushIndexWriter(String indexName) throws IndexException {
        IndexWriter indexWriter = POOL.get(indexName);
        if (indexWriter != null) {
            try {
                indexWriter.flush();
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Flushed Lucene index " + indexName));
                }
            }
            catch (Exception e) {
                throw new IndexException((Throwable)e);
            }
        }
    }

    public static void closeIndexWriter(String indexName) throws IndexException {
        IndexWriter indexWriter = POOL.get(indexName);
        if (indexWriter != null) {
            try {
                indexWriter.close();
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Closed IndexWriter for Lucene index " + indexName));
                }
            }
            catch (Exception e) {
                throw new IndexException((Throwable)e);
            }
            POOL.remove(indexName);
        }
    }

    public static synchronized void closeAll() throws IndexException {
        for (IndexWriter indexWriter : POOL.values()) {
            if (indexWriter == null) continue;
            try {
                indexWriter.close();
                if (!LOG.isInfoEnabled()) continue;
                LOG.info((Object)("Closed IndexWriter for Lucene index " + indexWriter.getDirectory()));
            }
            catch (Exception e) {
                LOG.error((Object)"Failed to close an index writer", (Throwable)e);
            }
        }
        POOL.clear();
    }
}

