/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.lucene.messages.advsearch;

import org.eclipse.smila.search.lucene.messages.advsearch.DOP1;
import org.eclipse.smila.search.lucene.messages.advsearch.DTermCodec;
import org.eclipse.smila.search.utils.advsearch.AdvSearchException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class DOP1Codec {
    private DOP1Codec() {
    }

    public static Element encode(DOP1 dOP1, Element parent) throws AdvSearchException {
        Document doc = parent.getOwnerDocument();
        Element me = (Element)parent.appendChild(doc.createElementNS("http://www.anyfinder.de/AdvancedSearch", "OP_1"));
        me.setAttribute("Operation", String.valueOf(dOP1.getOperation()));
        DTermCodec.encode(dOP1.getTerm(), me);
        return me;
    }

    public static DOP1 decode(Element element) throws AdvSearchException {
        try {
            DOP1 dOP1 = new DOP1();
            dOP1.setOperation(element.getAttribute("Operation"));
            NodeList nl = element.getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                if ("Term".equals(nl.item(i).getLocalName())) {
                    dOP1.setTerm(DTermCodec.decode((Element)nl.item(i)));
                }
                ++i;
            }
            return dOP1;
        }
        catch (AdvSearchException e) {
            throw e;
        }
        catch (Exception exception) {
            throw new AdvSearchException("Error in attributes to OP_1!");
        }
    }
}

