/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.lucene.messages.advsearch;

import org.eclipse.smila.search.lucene.messages.advsearch.DTextField;
import org.eclipse.smila.search.utils.advsearch.AdvSearchException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

abstract class DTextFieldCodec {
    private DTextFieldCodec() {
    }

    public static Element encode(DTextField dTextField, Element parent) throws AdvSearchException {
        Document doc = parent.getOwnerDocument();
        Element me = (Element)parent.appendChild(doc.createElementNS("http://www.anyfinder.de/AdvancedSearch", "Field"));
        me.setAttribute("xsi:type", "TextField");
        me.setAttribute("FieldNo", String.valueOf(dTextField.getFieldNo()));
        me.setAttribute("Fuzzy", dTextField.getFuzzyAsString());
        me.setAttribute("ParseWildcards", dTextField.getParseWildcardsAsString());
        me.setAttribute("Slop", String.valueOf(dTextField.getSlop()));
        Element child = null;
        child = (Element)me.appendChild(doc.createElementNS("http://www.anyfinder.de/AdvancedSearch", "Text"));
        child.appendChild(doc.createTextNode(dTextField.getText()));
        return me;
    }

    public static DTextField decode(Element eTextField) throws AdvSearchException {
        try {
            DTextField dTextField = new DTextField();
            dTextField.setFieldNo(Integer.parseInt(eTextField.getAttribute("FieldNo")));
            dTextField.setFuzzy(eTextField.getAttribute("Fuzzy"));
            dTextField.setParseWildcards(eTextField.getAttribute("ParseWildcards"));
            dTextField.setSlop(Integer.parseInt(eTextField.getAttribute("Slop")));
            NodeList nl = eTextField.getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                if ("Text".equals(nl.item(i).getLocalName())) {
                    if (nl.item(i).hasChildNodes()) {
                        dTextField.setText(((Text)nl.item(i).getFirstChild()).getData());
                    } else {
                        dTextField.setText("");
                    }
                }
                ++i;
            }
            return dTextField;
        }
        catch (Exception e) {
            throw new AdvSearchException("Error in attributes to TextField!", (Throwable)e);
        }
    }
}

